/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.ws.sdk.client;

import eleme.openapi.ws.sdk.client.WsClientEndpoint;
import eleme.openapi.ws.sdk.config.Context;
import eleme.openapi.ws.sdk.exception.UnableConnectionException;
import eleme.openapi.ws.sdk.utils.ClientEnvUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectionManagement {
    private static final int START_SLEEP_TIME = 500;
    private static final int MAX_SLEEP_TIME = 512000;
    private static final int MIDDLE_SLEEP_TIME = 128000;
    public static ConcurrentHashMap<String, WsClientEndpoint> clientEndPointMap = new ConcurrentHashMap();

    public static void initConnection() throws UnableConnectionException {
        try {
            for (Map.Entry<String, String> entry : Context.wssAddressMap.entrySet()) {
                WsClientEndpoint clientEndPoint = new WsClientEndpoint(new URI(entry.getValue()), entry.getKey());
                clientEndPointMap.put(entry.getKey(), clientEndPoint);
                clientEndPoint.regiterMessageHandler(Context.businessHandle);
                Context.elemeSdkLogger.info("build connection success,key:" + entry.getKey());
            }
        }
        catch (URISyntaxException e) {
            Context.elemeSdkLogger.error("build connection error:" + e.getMessage());
            Context.elemeSdkLogger.error("context:" + ClientEnvUtils.getClientProfile());
            throw new UnableConnectionException(e.getMessage());
        }
    }

    public static void buildConnection(String appKey) throws UnableConnectionException {
        try {
            WsClientEndpoint clientEndPoint = new WsClientEndpoint(new URI(Context.wssAddressMap.get(appKey)), appKey);
            clientEndPointMap.put(appKey, clientEndPoint);
            clientEndPoint.regiterMessageHandler(Context.businessHandle);
            Context.elemeSdkLogger.info("build connection success,key:" + appKey);
        }
        catch (URISyntaxException e) {
            Context.elemeSdkLogger.error("build connection error:" + e.getMessage());
            throw new UnableConnectionException(e.getMessage());
        }
    }

    public static void reBuildConnection(String appkey) {
        int start = 500;
        while (true) {
            try {
                ConnectionManagement.close(clientEndPointMap.get(appkey));
                Thread.sleep(start);
                ConnectionManagement.buildConnection(appkey);
            }
            catch (Exception e) {
                start = Math.min(start * 2, 512000);
                if (start == 512000 || start == 128000) {
                    Context.elemeSdkLogger.error("rebuild context:" + ClientEnvUtils.getClientProfile());
                }
                Context.elemeSdkLogger.error("rebuild connection:" + e.getMessage());
                continue;
            }
            break;
        }
    }

    private static void close(WsClientEndpoint wsClientEndpoint) {
        if (wsClientEndpoint != null) {
            try {
                wsClientEndpoint.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

