package eleme.openapi.ws.sdk.utils;

import eleme.openapi.ws.sdk.config.Constants;
import eleme.openapi.ws.sdk.entity.BussinessAckPack;
import eleme.openapi.ws.sdk.entity.HeartBeatPack;
import eleme.openapi.ws.sdk.entity.UpstreamPack;

import java.util.UUID;


public class UpStreamPackBuild {
    public static UpstreamPack buildHeartBeatPack() {
        HeartBeatPack heartBeatPack = new HeartBeatPack(10);
        return new UpstreamPack(UUID.randomUUID().toString(), Constants.HEART_BEAT_TOPIC, JacksonUtils.obj2json(heartBeatPack));
    }

    public static UpstreamPack buildBussinessAckPack(String srcMsgId) {
        return new UpstreamPack(UUID.randomUUID().toString(), Constants.ACK_DATA, JacksonUtils.obj2json(new BussinessAckPack(srcMsgId)));
    }

    public static void main(String[] args) {
        System.out.println(JacksonUtils.obj2json(buildBussinessAckPack("231231")));
    }

}
