package eleme.openapi.ws.sdk.task;

import eleme.openapi.ws.sdk.config.Constants;
import eleme.openapi.ws.sdk.config.Context;
import eleme.openapi.ws.sdk.entity.Account;
import eleme.openapi.ws.sdk.entity.HeartBeatRecord;
import eleme.openapi.ws.sdk.entity.NcpRequest;
import eleme.openapi.ws.sdk.entity.ResponsePayload;
import eleme.openapi.ws.sdk.utils.HttpUtils;
import eleme.openapi.ws.sdk.utils.JacksonUtils;

import java.util.*;
import java.util.concurrent.*;


public class PullMessage {


    private static ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(2);

    public static ConcurrentHashMap<String, ArrayBlockingQueue<HeartBeatRecord>> heartBeatRecordQueueMap = new ConcurrentHashMap();

    public static Map<String, String> headerMap = new HashMap<String, String>();

    static {
        headerMap.put("invocation-protocol", "Napos-Communication-Protocol-2");
        headerMap.put("Content-type", "application/json;charset=UTF-8");
        headerMap.put("Connection", "keep-alive");
    }

    public static void startPullMessageTask() {
        executorService.scheduleAtFixedRate(new Runnable() {
            public void run() {
                for (Account account : Context.accounts) {
                    try {
                        String id = UUID.randomUUID().toString();
                        headerMap.put("X-Eleme-RequestID", id);
                        String response = HttpUtils.doPost(Constants.PULL_MESSAGE_URL, headerMap, JacksonUtils.obj2json(wrapNcpRequest(id, account.getToken())));
                        List<String> messages = resolveResponse(response);
                        if (messages == null) {
                            continue;
                        }
                        for (String message : messages) {
                            Context.elemeSdkLogger.info("pull message success :" + message);
                            Context.businessHandle.onMessage(message);
                        }
                    } catch (Exception e) {
                        Context.elemeSdkLogger.error("pull message error :" + e.getMessage());
                    }
                }
            }
        }, 10, 60 + new Random().nextInt(30), TimeUnit.SECONDS);

    }

    private static NcpRequest wrapNcpRequest(String id, String token) {
        NcpRequest request = new NcpRequest();
        request.setId(id);
        request.setNcp(Constants.NCP_VERSION);
        request.setParams(Collections.EMPTY_MAP);
        request.setMethod(Constants.PULL_MESSAGE_METHOD);
        request.setService(Constants.PULL_MESSAGE_SERVICE);
        Map<String, String> metas = new HashMap();
        metas.put("appName", "ws-sdk");
        metas.put("appVersion", Constants.SDK_VERSION);
        metas.put("ksid", token);
        request.setMetas(metas);
        return request;
    }

    private static List<String> resolveResponse(String response) {
        ResponsePayload ncpResponse = JacksonUtils.json2pojo(response, ResponsePayload.class);
        if (ncpResponse.getError() != null) {
            Context.elemeSdkLogger.error("eleme.ws.sdk error pull message server :" + ncpResponse.getError().getMessage());
            return null;
        }
        if (ncpResponse.getResult() == null) {
            return null;
        }
        return (List<String>) ncpResponse.getResult();
    }

}


