package eleme.openapi.ws.sdk.exception;

public class UnableConnectionException extends Exception {
    private String code = "UNABLE_CONNECTION";

    public UnableConnectionException() {
        super("无法建立连接，请重试");
    }

    public UnableConnectionException(String message) {
        super(message);
    }

    public UnableConnectionException(String code, String message) {
        this(message);
        this.setCode(code);
    }

    public UnableConnectionException(String code, String message, Throwable cause) {
        super(message, cause);
        this.setCode(code);
    }

    public UnableConnectionException(String code, Throwable cause) {
        super(cause);
        this.setCode(code);
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }
}
