/*
 * Decompiled with CFR 0.152.
 */
package net.sf.maventaglib.checker;

import java.util.ArrayList;
import net.sf.maventaglib.checker.Tag;
import net.sf.maventaglib.checker.TagAttribute;
import net.sf.maventaglib.checker.Tld;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TldParser {
    private static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sf.maventaglib.checker.TldParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    private TldParser() {
    }

    public static Tld parse(Document tldDoc, String tldName) {
        Tld tld = new Tld();
        tld.setFilename(tldName);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        NodeList tagList = tldDoc.getElementsByTagName("taglib").item(0).getChildNodes();
        int i = 0;
        while (i < tagList.getLength()) {
            Node tagNode = tagList.item(i);
            if ("shortname".equals(tagNode.getNodeName()) || "short-name".equals(tagNode.getNodeName())) {
                Node child = tagNode.getFirstChild();
                if (child != null) {
                    tld.setName(child.getNodeValue());
                }
            } else if ("tag".equals(tagNode.getNodeName())) {
                Tag tag = TldParser.parseTag(tagNode);
                tags.add(tag);
            }
            tld.setTags(tags.toArray(new Tag[tags.size()]));
            ++i;
        }
        return tld;
    }

    private static Tag parseTag(Node tagNode) {
        Tag tag = new Tag();
        ArrayList<TagAttribute> attributes = new ArrayList<TagAttribute>();
        NodeList tagAttributes = tagNode.getChildNodes();
        int k = 0;
        while (k < tagAttributes.getLength()) {
            Node tagAttribute = tagAttributes.item(k);
            String nodeName = tagAttribute.getNodeName();
            if ("name".equals(nodeName)) {
                tag.setName(tagAttribute.getFirstChild().getNodeValue());
            } else if ("tag-class".equals(nodeName) || "tagclass".equals(nodeName)) {
                tag.setTagClass(tagAttribute.getFirstChild().getNodeValue());
            } else if ("tei-class".equals(nodeName) || "teiclass".equals(nodeName)) {
                tag.setTeiClass(tagAttribute.getFirstChild().getNodeValue());
            } else if ("attribute".equals(nodeName)) {
                TagAttribute attribute = TldParser.parseTagAttribute(tagAttribute);
                attributes.add(attribute);
            }
            tag.setAttributes(attributes.toArray(new TagAttribute[attributes.size()]));
            ++k;
        }
        return tag;
    }

    private static TagAttribute parseTagAttribute(Node tagAttribute) {
        TagAttribute attribute = new TagAttribute();
        NodeList attributeParams = tagAttribute.getChildNodes();
        int z = 0;
        while (z < attributeParams.getLength()) {
            Node param = attributeParams.item(z);
            if (param.getNodeType() != 3 && param.hasChildNodes()) {
                if ("name".equals(param.getNodeName())) {
                    attribute.setAttributeName(param.getFirstChild().getNodeValue());
                } else if ("type".equals(param.getNodeName())) {
                    attribute.setAttributeType(param.getFirstChild().getNodeValue());
                }
            }
            ++z;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)attribute);
        }
        return attribute;
    }
}

