/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import ma.glasnost.orika.Mapper;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.impl.GeneratedMapperBase;
import ma.glasnost.orika.impl.ReversedMapper;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.util.Ordering;
import ma.glasnost.orika.util.SortedCollection;

public final class MultipleMapperWrapper
extends GeneratedMapperBase {
    private Collection<Mapper<Object, Object>> mappersRegistry;
    private Map<MapperKey, Mapper<Object, Object>> mappersCache;

    public MultipleMapperWrapper(Type<Object> typeA, Type<Object> typeB, List<Mapper<Object, Object>> mappers) {
        this.setAType(typeA);
        this.setBType(typeB);
        this.mappersRegistry = new SortedCollection<Mapper<Object, Object>>(mappers, Ordering.MAPPER);
        this.mappersCache = new WeakHashMap<MapperKey, Mapper<Object, Object>>();
    }

    @Override
    public void mapAtoB(Object a, Object b, MappingContext context) {
        this.getMapperFor(a, b).mapAtoB(a, b, context);
    }

    @Override
    public void mapBtoA(Object b, Object a, MappingContext context) {
        this.getMapperFor(a, b).mapBtoA(b, a, context);
    }

    private MapperKey createMapperKey(Object a, Object b) {
        Type<Object> aType = TypeFactory.valueOf(a.getClass());
        Type<Object> bType = TypeFactory.valueOf(b.getClass());
        if (((Class)aType.getRawType()).isAssignableFrom((Class<?>)this.getAType().getRawType())) {
            aType = this.getAType();
        }
        if (((Class)bType.getRawType()).isAssignableFrom((Class<?>)this.getBType().getRawType())) {
            bType = this.getBType();
        }
        return new MapperKey(aType, bType);
    }

    private Mapper<Object, Object> getMapperFor(Object a, Object b) {
        MapperKey mapperKey = this.createMapperKey(a, b);
        Mapper<Object, Object> mapper = this.mappersCache.get(mapperKey);
        if (mapper != null) {
            return mapper;
        }
        mapper = this.findMapperFor(mapperKey);
        if (mapper == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("No matching Mapper found for %s <-> %s", mapperKey.getAType(), mapperKey.getBType()));
            sb.append("\n");
            for (Mapper<Object, Object> mapper2 : this.mappersRegistry) {
                sb.append(String.format("\t Existing Mapper: %s <-> %s", mapper2.getAType(), mapper2.getBType()));
                sb.append("\n");
                sb.append("\t");
                sb.append(String.format("Matching-A: %s; Matching-B: %s", mapper2.getAType().isAssignableFrom(mapperKey.getAType()), mapper2.getBType().isAssignableFrom(mapperKey.getBType())));
                sb.append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
        this.mappersCache.put(mapperKey, mapper);
        return mapper;
    }

    public Mapper<Object, Object> findMapperFor(MapperKey mapperKey) {
        for (Mapper<Object, Object> mapper : this.mappersRegistry) {
            if (mapper.getAType().isAssignableFrom(mapperKey.getAType()) && mapper.getBType().isAssignableFrom(mapperKey.getBType())) {
                return mapper;
            }
            if (!mapper.getBType().isAssignableFrom(mapperKey.getAType()) || !mapper.getAType().isAssignableFrom(mapperKey.getBType())) continue;
            return ReversedMapper.reverse(mapper);
        }
        for (Mapper<Object, Object> mapper : this.mappersRegistry) {
            if (((Class)mapper.getAType().getRawType()).isAssignableFrom((Class<?>)mapperKey.getAType().getRawType()) && ((Class)mapper.getBType().getRawType()).isAssignableFrom((Class<?>)mapperKey.getBType().getRawType())) {
                return mapper;
            }
            if (!((Class)mapper.getBType().getRawType()).isAssignableFrom((Class<?>)mapperKey.getAType().getRawType()) || !((Class)mapper.getAType().getRawType()).isAssignableFrom((Class<?>)mapperKey.getBType().getRawType())) continue;
            return ReversedMapper.reverse(mapper);
        }
        return null;
    }

    @Override
    public void setUsedMappers(Mapper<Object, Object>[] usedMappers) {
        throw new IllegalStateException("Should not be called for a user MultipleMapperWrapper.");
    }

    @Override
    public Mapper<Object, Object>[] getUsedMappers() {
        HashSet<Mapper<Object, Object>> usedMappers = new HashSet<Mapper<Object, Object>>();
        for (Mapper<Object, Object> mapper : this.mappersRegistry) {
            if (!(mapper instanceof GeneratedMapperBase)) continue;
            GeneratedMapperBase generatedMapper = (GeneratedMapperBase)mapper;
            usedMappers.addAll(Arrays.asList(generatedMapper.getUsedMappers()));
        }
        return usedMappers.toArray(new Mapper[usedMappers.size()]);
    }

    public Collection<Mapper<Object, Object>> getMappersRegistry() {
        return Collections.unmodifiableCollection(this.mappersRegistry);
    }
}

