/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

class TypeKey {
    private static volatile WeakHashMap<Type, Integer> knownTypes = new WeakHashMap();
    private static AtomicInteger currentIndex = new AtomicInteger();
    private final byte[] bytes;
    private final int hashCode;

    static TypeKey valueOf(Class<?> rawType, Type[] typeArguments) {
        byte[] identityHashBytes = new byte[(typeArguments.length + 1) * 4];
        TypeKey.intToByteArray(TypeKey.getTypeIndex(rawType), identityHashBytes, 0);
        int len = typeArguments.length;
        for (int i = 0; i < len; ++i) {
            TypeKey.intToByteArray(TypeKey.getTypeIndex(typeArguments[i]), identityHashBytes, i + 1);
        }
        return new TypeKey(identityHashBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getTypeIndex(Type type) {
        Integer typeIndex = knownTypes.get(type);
        if (typeIndex == null) {
            Type type2 = type;
            synchronized (type2) {
                typeIndex = knownTypes.get(type);
                if (typeIndex == null) {
                    typeIndex = currentIndex.getAndAdd(1);
                    knownTypes.put(type, typeIndex);
                }
            }
        }
        return typeIndex;
    }

    private static void intToByteArray(int value, byte[] bytes, int startIndex) {
        int i = startIndex * 4;
        bytes[i] = (byte)(value >>> 24);
        bytes[i + 1] = (byte)(value >>> 16);
        bytes[i + 2] = (byte)(value >>> 8);
        bytes[i + 3] = (byte)value;
    }

    private TypeKey(byte[] bytes) {
        this.bytes = bytes;
        this.hashCode = Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        TypeKey otherKey = (TypeKey)other;
        return Arrays.equals(this.bytes, otherKey.bytes);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

