/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import ma.glasnost.orika.impl.generator.CompilerStrategy;
import ma.glasnost.orika.impl.generator.SourceCodeContext;

public class EclipseJdtCompilerStrategy
extends CompilerStrategy {
    private static final String WRITE_SOURCE_FILES_BY_DEFAULT = "true";
    private static final String WRITE_CLASS_FILES_BY_DEFAULT = "false";
    private static final String COMPILER_CLASS_NAME = "ma.glasnost.orika.impl.generator.EclipseJdtCompiler";
    private final Object compiler;
    private final Method formatSource;
    private final Method compile;
    private final Method assertTypeAccessible;
    private final Method load;

    public EclipseJdtCompilerStrategy() {
        super(WRITE_SOURCE_FILES_BY_DEFAULT, WRITE_CLASS_FILES_BY_DEFAULT);
        try {
            Class<?> compilerClass = Class.forName(COMPILER_CLASS_NAME, true, Thread.currentThread().getContextClassLoader());
            this.compiler = compilerClass.newInstance();
            this.formatSource = compilerClass.getMethod("formatSource", String.class);
            this.compile = compilerClass.getMethod("compile", String.class, String.class, String.class);
            this.assertTypeAccessible = compilerClass.getMethod("assertTypeAccessible", Class.class);
            this.load = compilerClass.getMethod("load", String.class, byte[].class);
        }
        catch (Exception e) {
            throw new IllegalStateException("ma.glasnost.orika.impl.generator.EclipseJdtCompiler or one of it's runtime dependencies was not available; is the 'orika-eclipse-tools' module included in your classpath?");
        }
    }

    private String formatSource(String rawSource) {
        try {
            return (String)this.formatSource.invoke(this.compiler, rawSource);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSourceFile(String sourceText, String packageName, String className) throws IOException {
        File parentDir = this.preparePackageOutputPath(this.pathToWriteSourceFiles, packageName);
        File outputSourceFile = new File(parentDir, className + ".java");
        if (!outputSourceFile.exists() && !outputSourceFile.createNewFile()) {
            throw new IOException("Could not write source file for " + packageName + "." + className);
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(outputSourceFile);
            fw.append(sourceText);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    protected void writeClassFile(String packageName, String simpleClassName, byte[] data) throws IOException {
        File parentDir = this.preparePackageOutputPath(this.pathToWriteClassFiles, packageName);
        File outputSourceFile = new File(parentDir, simpleClassName + ".class");
        if (!outputSourceFile.exists() && !outputSourceFile.createNewFile()) {
            throw new IOException("Could not write class file for " + packageName + "." + simpleClassName);
        }
        FileOutputStream fout = new FileOutputStream(outputSourceFile);
        fout.write(data);
        fout.close();
    }

    @Override
    public void assureTypeIsAccessible(Class<?> type) throws CompilerStrategy.SourceCodeGenerationException {
        try {
            if (!Modifier.isPublic(type.getModifiers())) {
                throw new CompilerStrategy.SourceCodeGenerationException(type + " is not accessible");
            }
            if (type.isMemberClass()) {
                for (Class<?> currentType = type; currentType != null; currentType = currentType.getEnclosingClass()) {
                    if (Modifier.isPublic(type.getModifiers())) continue;
                    throw new CompilerStrategy.SourceCodeGenerationException(type + " is not accessible");
                }
            }
            this.assertTypeAccessible.invoke(this.compiler, type);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new CompilerStrategy.SourceCodeGenerationException(e.getMessage(), e.getTargetException());
        }
    }

    private byte[] compile(String source, String packageName, String classSimpleName) throws CompilerStrategy.SourceCodeGenerationException {
        try {
            return (byte[])this.compile.invoke(this.compiler, source, packageName, classSimpleName);
        }
        catch (IllegalAccessException e) {
            throw this.classCompilationException(e, packageName, classSimpleName, source);
        }
        catch (IllegalArgumentException e) {
            throw this.classCompilationException(e, packageName, classSimpleName, source);
        }
        catch (InvocationTargetException e) {
            throw this.classCompilationException(e.getTargetException(), packageName, classSimpleName, source);
        }
    }

    private Class<?> load(String className, byte[] data) throws ClassNotFoundException {
        try {
            return (Class)this.load.invoke(this.compiler, className, data);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
    }

    private CompilerStrategy.SourceCodeGenerationException classCompilationException(Throwable cause, String packageName, String classSimpleName, String source) {
        return new CompilerStrategy.SourceCodeGenerationException("Error compiling " + packageName + "." + classSimpleName, cause);
    }

    @Override
    public Class<?> compileClass(SourceCodeContext sourceCode) throws CompilerStrategy.SourceCodeGenerationException {
        Class<?> compiledClass = null;
        String sourceText = sourceCode.toSourceFile();
        try {
            sourceText = this.formatSource(sourceCode.toSourceFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String packageName = sourceCode.getPackageName();
        String classSimpleName = sourceCode.getClassSimpleName();
        String className = sourceCode.getClassName();
        byte[] data = null;
        try {
            if (this.writeSourceFiles) {
                this.writeSourceFile(sourceText, packageName, classSimpleName);
            }
            data = this.compile(sourceText, packageName, classSimpleName);
            if (this.writeClassFiles) {
                this.writeClassFile(packageName, classSimpleName, data);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write files for " + className, e);
        }
        try {
            compiledClass = this.load(className, data);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return compiledClass;
    }
}

