/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter.builtin;

import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.converter.builtin.BuiltinCustomConverter;
import ma.glasnost.orika.impl.util.ClassUtil;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

public class ConstructorConverter
extends BuiltinCustomConverter<Object, Object> {
    @Override
    public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
        try {
            return ((Class)destinationType.getRawType()).getConstructor(new Class[]{sourceType.getRawType()}) != null;
        }
        catch (NoSuchMethodException e) {
            try {
                if (sourceType.isPrimitive()) {
                    return ((Class)destinationType.getRawType()).getConstructor(ClassUtil.getWrapperType(sourceType.getRawType())) != null;
                }
                if (sourceType.isPrimitiveWrapper()) {
                    return ((Class)destinationType.getRawType()).getConstructor(ClassUtil.getPrimitiveType(sourceType.getRawType())) != null;
                }
                return false;
            }
            catch (NoSuchMethodException e1) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Object convert(Object source, Type<?> destinationType, MappingContext context) {
        try {
            return ((Class)destinationType.getRawType()).getConstructor(source.getClass()).newInstance(source);
        }
        catch (NoSuchMethodException e) {
            Type<?> sourceType = TypeFactory.valueOf(source.getClass());
            try {
                if (sourceType.isPrimitive()) {
                    return ((Class)destinationType.getRawType()).getConstructor(ClassUtil.getWrapperType(sourceType.getRawType())).newInstance(source);
                }
                if (sourceType.isPrimitiveWrapper()) {
                    return ((Class)destinationType.getRawType()).getConstructor(ClassUtil.getPrimitiveType(sourceType.getRawType())).newInstance(source);
                }
                return false;
            }
            catch (Exception e1) {
                return false;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

