/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika;

import java.lang.reflect.ParameterizedType;
import ma.glasnost.orika.Filter;
import ma.glasnost.orika.MappedTypePair;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

public abstract class CustomFilter<A, B>
implements Filter<A, B> {
    private final Type<A> sourceType;
    private final Type<B> destinationType;

    public CustomFilter() {
        MappedTypePair<A, B> types = this.inferTypes();
        this.sourceType = types.getAType();
        this.destinationType = types.getBType();
    }

    protected MappedTypePair<A, B> inferTypes() {
        java.lang.reflect.Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (genericSuperclass != null && genericSuperclass instanceof ParameterizedType) {
            ParameterizedType superType = (ParameterizedType)genericSuperclass;
            return new MappedTypePairHolder(TypeFactory.valueOf(superType.getActualTypeArguments()[0]), TypeFactory.valueOf(superType.getActualTypeArguments()[1]));
        }
        throw new IllegalStateException("When you subclass the ConverterBase S and D type-parameters are required.");
    }

    @Override
    public Type<A> getAType() {
        return this.sourceType;
    }

    @Override
    public Type<B> getBType() {
        return this.destinationType;
    }

    @Override
    public boolean appliesTo(Property source, Property destination) {
        return this.sourceType.isAssignableFrom(CustomFilter.getObjectType(source.getType())) && this.destinationType.isAssignableFrom(CustomFilter.getObjectType(destination.getType()));
    }

    private static Type<?> getObjectType(Type<?> type) {
        return type.isPrimitive() ? type.getWrapperType() : type;
    }

    protected static class MappedTypePairHolder<A, B>
    implements MappedTypePair<A, B> {
        private final Type<A> aType;
        private final Type<B> bType;

        public MappedTypePairHolder(Type<A> aType, Type<B> bType) {
            this.aType = aType;
            this.bType = bType;
        }

        @Override
        public Type<A> getAType() {
            return this.aType;
        }

        @Override
        public Type<B> getBType() {
            return this.bType;
        }
    }
}

