/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyQuery;
import javax.money.CurrencyUnit;
import javax.money.DefaultMonetaryCurrenciesSingletonSpi;
import javax.money.DefaultMonetaryRoundingsSingletonSpi;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryAmountFactoryQuery;
import javax.money.MonetaryException;
import javax.money.MonetaryRounding;
import javax.money.RoundingQuery;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountsSingletonQuerySpi;
import javax.money.spi.MonetaryAmountsSingletonSpi;
import javax.money.spi.MonetaryCurrenciesSingletonSpi;
import javax.money.spi.MonetaryRoundingsSingletonSpi;

public final class Monetary {
    private static MonetaryCurrenciesSingletonSpi MONETARY_CURRENCIES_SINGLETON_SPI() {
        try {
            return Optional.ofNullable(Bootstrap.getService(MonetaryCurrenciesSingletonSpi.class)).orElseGet(DefaultMonetaryCurrenciesSingletonSpi::new);
        }
        catch (Exception e) {
            Logger.getLogger(Monetary.class.getName()).log(Level.INFO, "Failed to load MonetaryCurrenciesSingletonSpi, using default.", e);
            return new DefaultMonetaryCurrenciesSingletonSpi();
        }
    }

    private static MonetaryAmountsSingletonSpi monetaryAmountsSingletonSpi() {
        try {
            return Bootstrap.getService(MonetaryAmountsSingletonSpi.class);
        }
        catch (Exception e) {
            Logger.getLogger(Monetary.class.getName()).log(Level.SEVERE, "Failed to load MonetaryAmountsSingletonSpi.", e);
            return null;
        }
    }

    private static MonetaryAmountsSingletonQuerySpi monetaryAmountsSingletonQuerySpi() {
        try {
            return Bootstrap.getService(MonetaryAmountsSingletonQuerySpi.class);
        }
        catch (Exception e) {
            Logger.getLogger(Monetary.class.getName()).log(Level.SEVERE, "Failed to load MonetaryAmountsSingletonQuerySpi, query functionality will not be available.", e);
            return null;
        }
    }

    private static MonetaryRoundingsSingletonSpi monetaryRoundingsSingletonSpi() {
        try {
            return Optional.ofNullable(Bootstrap.getService(MonetaryRoundingsSingletonSpi.class)).orElseGet(DefaultMonetaryRoundingsSingletonSpi::new);
        }
        catch (Exception e) {
            Logger.getLogger(Monetary.class.getName()).log(Level.SEVERE, "Failed to load MonetaryCurrenciesSingletonSpi, using default.", e);
            return new DefaultMonetaryRoundingsSingletonSpi();
        }
    }

    private Monetary() {
    }

    public static Set<String> getRoundingProviderNames() {
        return Optional.ofNullable(Monetary.monetaryRoundingsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getProviderNames();
    }

    public static List<String> getDefaultRoundingProviderChain() {
        return Optional.ofNullable(Monetary.monetaryRoundingsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getDefaultProviderChain();
    }

    public static MonetaryRounding getDefaultRounding() {
        return Optional.ofNullable(Monetary.monetaryRoundingsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getDefaultRounding();
    }

    public static MonetaryRounding getRounding(CurrencyUnit currencyUnit, String ... providers) {
        return Optional.ofNullable(Monetary.monetaryRoundingsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getRounding(currencyUnit, providers);
    }

    public static MonetaryRounding getRounding(String roundingName, String ... providers) {
        return Optional.ofNullable(Monetary.monetaryRoundingsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getRounding(roundingName, providers);
    }

    public static MonetaryRounding getRounding(RoundingQuery roundingQuery) {
        return Optional.ofNullable(Monetary.monetaryRoundingsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getRounding(roundingQuery);
    }

    public static boolean isRoundingAvailable(String roundingName, String ... providers) {
        return Optional.ofNullable(Monetary.monetaryRoundingsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).isRoundingAvailable(roundingName, providers);
    }

    public static boolean isRoundingAvailable(CurrencyUnit currencyUnit, String ... providers) {
        return Optional.ofNullable(Monetary.monetaryRoundingsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).isRoundingAvailable(currencyUnit, providers);
    }

    public static boolean isRoundingAvailable(RoundingQuery roundingQuery) {
        return Optional.ofNullable(Monetary.monetaryRoundingsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).isRoundingAvailable(roundingQuery);
    }

    public static Collection<MonetaryRounding> getRoundings(RoundingQuery roundingQuery) {
        return Optional.ofNullable(Monetary.monetaryRoundingsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getRoundings(roundingQuery);
    }

    public static Set<String> getRoundingNames(String ... providers) {
        return Optional.ofNullable(Monetary.monetaryRoundingsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getRoundingNames(providers);
    }

    public static <T extends MonetaryAmount> MonetaryAmountFactory<T> getAmountFactory(Class<T> amountType) {
        MonetaryAmountsSingletonSpi spi = Optional.ofNullable(Monetary.monetaryAmountsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonSpi loaded."));
        MonetaryAmountFactory<T> factory = spi.getAmountFactory(amountType);
        return Optional.ofNullable(factory).orElseThrow(() -> new MonetaryException("No AmountFactory available for type: " + amountType.getName()));
    }

    public static MonetaryAmountFactory<?> getDefaultAmountFactory() {
        return Optional.ofNullable(Monetary.monetaryAmountsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonSpi loaded.")).getDefaultAmountFactory();
    }

    public static Collection<MonetaryAmountFactory<?>> getAmountFactories() {
        return Optional.ofNullable(Monetary.monetaryAmountsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonSpi loaded.")).getAmountFactories();
    }

    public static Collection<Class<? extends MonetaryAmount>> getAmountTypes() {
        return Optional.ofNullable(Monetary.monetaryAmountsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonSpi loaded.")).getAmountTypes();
    }

    public static Class<? extends MonetaryAmount> getDefaultAmountType() {
        return Optional.ofNullable(Monetary.monetaryAmountsSingletonSpi()).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonSpi loaded.")).getDefaultAmountType();
    }

    public static MonetaryAmountFactory getAmountFactory(MonetaryAmountFactoryQuery query) {
        return Optional.ofNullable(Monetary.monetaryAmountsSingletonQuerySpi()).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonQuerySpi loaded, query functionality is not available.")).getAmountFactory(query);
    }

    public static Collection<MonetaryAmountFactory<?>> getAmountFactories(MonetaryAmountFactoryQuery query) {
        return Optional.ofNullable(Monetary.monetaryAmountsSingletonQuerySpi()).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonQuerySpi loaded, query functionality is not available.")).getAmountFactories(query);
    }

    public static boolean isAvailable(MonetaryAmountFactoryQuery query) {
        return Optional.ofNullable(Monetary.monetaryAmountsSingletonQuerySpi()).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonQuerySpi loaded, query functionality is not available.")).isAvailable(query);
    }

    public static CurrencyUnit getCurrency(String currencyCode, String ... providers) {
        return Optional.ofNullable(Monetary.MONETARY_CURRENCIES_SINGLETON_SPI()).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getCurrency(currencyCode, providers);
    }

    public static CurrencyUnit getCurrency(Locale locale, String ... providers) {
        return Optional.ofNullable(Monetary.MONETARY_CURRENCIES_SINGLETON_SPI()).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getCurrency(locale, providers);
    }

    public static Set<CurrencyUnit> getCurrencies(Locale locale, String ... providers) {
        return Optional.ofNullable(Monetary.MONETARY_CURRENCIES_SINGLETON_SPI()).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getCurrencies(locale, providers);
    }

    public static boolean isCurrencyAvailable(String code, String ... providers) {
        return Objects.nonNull(Monetary.MONETARY_CURRENCIES_SINGLETON_SPI()) && Monetary.MONETARY_CURRENCIES_SINGLETON_SPI().isCurrencyAvailable(code, providers);
    }

    public static boolean isCurrencyAvailable(Locale locale, String ... providers) {
        return Objects.nonNull(Monetary.MONETARY_CURRENCIES_SINGLETON_SPI()) && Monetary.MONETARY_CURRENCIES_SINGLETON_SPI().isCurrencyAvailable(locale, providers);
    }

    public static Collection<CurrencyUnit> getCurrencies(String ... providers) {
        return Optional.ofNullable(Monetary.MONETARY_CURRENCIES_SINGLETON_SPI()).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getCurrencies(providers);
    }

    public static CurrencyUnit getCurrency(CurrencyQuery query) {
        return Optional.ofNullable(Monetary.MONETARY_CURRENCIES_SINGLETON_SPI()).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getCurrency(query);
    }

    public static Collection<CurrencyUnit> getCurrencies(CurrencyQuery query) {
        return Optional.ofNullable(Monetary.MONETARY_CURRENCIES_SINGLETON_SPI()).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getCurrencies(query);
    }

    public static Set<String> getCurrencyProviderNames() {
        return Optional.ofNullable(Monetary.MONETARY_CURRENCIES_SINGLETON_SPI()).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getProviderNames();
    }

    public static List<String> getDefaultCurrencyProviderChain() {
        return Optional.ofNullable(Monetary.MONETARY_CURRENCIES_SINGLETON_SPI()).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getDefaultProviderChain();
    }
}

