/*
 * Decompiled with CFR 0.152.
 */
package zipkin.maven;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

@Mojo(name="sync", defaultPhase=LifecyclePhase.DEPLOY)
public class CentralSyncMojo
extends AbstractMojo {
    final OkHttpClient client = new OkHttpClient.Builder().readTimeout(10L, TimeUnit.MINUTES).build();
    @Parameter(defaultValue="${project.version}", required=true)
    String version;
    @Parameter(defaultValue="${settings}", required=true)
    Settings settings;
    @Parameter(property="sync.dryRun")
    boolean dryRun = false;
    @Parameter
    String bintrayServerId = "bintray";
    @Parameter
    String sonatypeServerId = "sonatype";
    @Parameter
    String baseUrl = "https://api.bintray.com";
    @Parameter
    String subject = "openzipkin";
    @Parameter
    String repo = "maven";
    @Parameter(required=true)
    String packageName;

    public void execute() throws MojoExecutionException {
        Server bintray = this.verifyCredentialsPresent(this.bintrayServerId);
        Server sonatype = this.verifyCredentialsPresent(this.sonatypeServerId);
        HttpUrl url = HttpUrl.parse((String)this.baseUrl).newBuilder().addPathSegment("maven_central_sync").addPathSegment(this.subject).addPathSegment(this.repo).addPathSegment(this.packageName).addPathSegment("versions").addPathSegment(this.version).build();
        Request request = new Request.Builder().url(url).addHeader("Authorization", Credentials.basic((String)bintray.getUsername(), (String)bintray.getPassword())).addHeader("User-Agent", "openzipkin/zipkin-java release process, centralsync-maven-plugin").post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)("{\n  \"username\": \"" + sonatype.getUsername() + "\",\n" + "  \"password\": \"" + sonatype.getPassword() + "\"\n" + "}"))).build();
        if (this.dryRun) {
            this.getLog().info((CharSequence)("(Dry run) Would Sync to Maven Central via: POST " + request.url()));
            return;
        }
        try {
            Response response = this.client.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new MojoExecutionException(request.url() + " failed: " + response);
            }
            this.getLog().info((CharSequence)response.body().string());
        }
        catch (IOException e) {
            throw new MojoExecutionException(request.url() + " failed: " + e.getMessage(), (Exception)e);
        }
    }

    Server verifyCredentialsPresent(String id) {
        Server server = this.settings.getServer(id);
        if (server == null) {
            throw new IllegalStateException("settings/server/id " + id + " not found!");
        }
        if (server.getUsername() == null) {
            throw new IllegalStateException("settings/server/" + id + "/username not found!");
        }
        if (server.getPassword() == null) {
            throw new IllegalStateException("settings/server/" + id + "/password not found!");
        }
        return server;
    }
}

