/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.MySQLRowImpl;
import io.vertx.mysqlclient.impl.codec.ColumnDefinition;
import io.vertx.mysqlclient.impl.codec.DataFormat;
import io.vertx.mysqlclient.impl.codec.DataType;
import io.vertx.mysqlclient.impl.codec.DataTypeCodec;
import io.vertx.mysqlclient.impl.codec.MySQLRowDesc;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.impl.RowDecoder;
import java.nio.charset.Charset;
import java.util.function.BiConsumer;
import java.util.stream.Collector;

class RowResultDecoder<C, R>
implements RowDecoder {
    private static final int NULL = 251;
    private final Collector<Row, C, R> collector;
    private final boolean singleton;
    private final BiConsumer<C, Row> accumulator;
    MySQLRowDesc rowDesc;
    private int size;
    private C container;
    private Row row;

    RowResultDecoder(Collector<Row, C, R> collector, boolean singleton, MySQLRowDesc rowDesc) {
        this.collector = collector;
        this.singleton = singleton;
        this.accumulator = collector.accumulator();
        this.rowDesc = rowDesc;
    }

    public int size() {
        return this.size;
    }

    public void decodeRow(int len, ByteBuf in) {
        if (this.container == null) {
            this.container = this.collector.supplier().get();
        }
        if (this.singleton) {
            if (this.row == null) {
                this.row = new MySQLRowImpl(this.rowDesc);
            } else {
                this.row.clear();
            }
        } else {
            this.row = new MySQLRowImpl(this.rowDesc);
        }
        MySQLRowImpl row = new MySQLRowImpl(this.rowDesc);
        if (this.rowDesc.dataFormat() == DataFormat.BINARY) {
            int nullBitmapLength = len + 7 + 2 >> 3;
            int nullBitmapIdx = 1 + in.readerIndex();
            in.skipBytes(1 + nullBitmapLength);
            for (int c = 0; c < len; ++c) {
                int val = c + 2;
                int bytePos = val >> 3;
                int bitPos = val & 7;
                byte mask = (byte)(1 << bitPos);
                byte nullByte = (byte)(in.getByte(nullBitmapIdx + bytePos) & mask);
                Object decoded = null;
                if (nullByte == 0) {
                    ColumnDefinition columnDef = this.rowDesc.columnDefinitions()[c];
                    DataType dataType = columnDef.type();
                    int collationId = this.rowDesc.columnDefinitions()[c].characterSet();
                    Charset charset = Charset.forName(MySQLCollation.valueOfId(collationId).mappedJavaCharsetName());
                    int columnDefinitionFlags = columnDef.flags();
                    decoded = DataTypeCodec.decodeBinary(dataType, charset, columnDefinitionFlags, in);
                }
                row.addValue(decoded);
            }
        } else {
            for (int c = 0; c < len; ++c) {
                Object decoded = null;
                if (in.getUnsignedByte(in.readerIndex()) == 251) {
                    in.skipBytes(1);
                } else {
                    DataType dataType = this.rowDesc.columnDefinitions()[c].type();
                    int columnDefinitionFlags = this.rowDesc.columnDefinitions()[c].flags();
                    int collationId = this.rowDesc.columnDefinitions()[c].characterSet();
                    Charset charset = Charset.forName(MySQLCollation.valueOfId(collationId).mappedJavaCharsetName());
                    decoded = DataTypeCodec.decodeText(dataType, charset, columnDefinitionFlags, in);
                }
                row.addValue(decoded);
            }
        }
        this.accumulator.accept(this.container, (Row)row);
        ++this.size;
    }

    public R complete() {
        if (this.container == null) {
            this.container = this.collector.supplier().get();
        }
        return this.collector.finisher().apply(this.container);
    }

    public void reset() {
        this.container = null;
        this.size = 0;
    }
}

