/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.command.PingCommand;
import io.vertx.sqlclient.impl.command.CommandResponse;

class PingCommandCodec
extends CommandCodec<Void, PingCommand> {
    private static final int PAYLOAD_LENGTH = 1;

    PingCommandCodec(PingCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        this.sendPingCommand();
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength, int sequenceId) {
        this.completionHandler.handle((Object)CommandResponse.success(null));
    }

    private void sendPingCommand() {
        ByteBuf packet = this.allocateBuffer(5);
        packet.writeMediumLE(1);
        packet.writeByte(this.sequenceId);
        packet.writeByte(14);
        this.sendNonSplitPacket(packet);
    }
}

