/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.Handler;
import io.vertx.mysqlclient.MySQLException;
import io.vertx.mysqlclient.impl.codec.ColumnDefinition;
import io.vertx.mysqlclient.impl.codec.DataType;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.codec.Packets;
import io.vertx.mysqlclient.impl.util.BufferUtils;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

abstract class CommandCodec<R, C extends CommandBase<R>> {
    Handler<? super CommandResponse<R>> completionHandler;
    public Throwable failure;
    public R result;
    final C cmd;
    int sequenceId;
    MySQLEncoder encoder;

    CommandCodec(C cmd) {
        this.cmd = cmd;
    }

    abstract void decodePayload(ByteBuf var1, int var2, int var3);

    void encode(MySQLEncoder encoder) {
        this.encoder = encoder;
    }

    ByteBuf allocateBuffer() {
        return this.encoder.chctx.alloc().ioBuffer();
    }

    ByteBuf allocateBuffer(int capacity) {
        return this.encoder.chctx.alloc().ioBuffer(capacity);
    }

    void sendPacket(ByteBuf packet, int payloadLength) {
        if (payloadLength >= 0xFFFFFF) {
            this.sendSplitPacket(packet);
        } else {
            this.sendNonSplitPacket(packet);
        }
    }

    private void sendSplitPacket(ByteBuf packet) {
        ByteBuf packetHeader;
        ByteBuf payload = packet.skipBytes(4);
        while (payload.readableBytes() >= 0xFFFFFF) {
            packetHeader = this.allocateBuffer(4);
            packetHeader.writeMediumLE(0xFFFFFF);
            packetHeader.writeByte(this.sequenceId++);
            this.encoder.chctx.write((Object)packetHeader);
            this.encoder.chctx.write((Object)payload.readRetainedSlice(0xFFFFFF));
        }
        packetHeader = this.allocateBuffer(4);
        packetHeader.writeMediumLE(payload.readableBytes());
        packetHeader.writeByte(this.sequenceId++);
        this.encoder.chctx.write((Object)packetHeader);
        this.encoder.chctx.writeAndFlush((Object)payload);
    }

    void sendNonSplitPacket(ByteBuf packet) {
        ++this.sequenceId;
        this.encoder.chctx.writeAndFlush((Object)packet);
    }

    void handleOkPacketOrErrorPacketPayload(ByteBuf payload) {
        short header = payload.getUnsignedByte(payload.readerIndex());
        switch (header) {
            case 0: 
            case 254: {
                this.completionHandler.handle((Object)CommandResponse.success(null));
                break;
            }
            case 255: {
                this.handleErrorPacketPayload(payload);
            }
        }
    }

    void handleErrorPacketPayload(ByteBuf payload) {
        payload.skipBytes(1);
        int errorCode = payload.readUnsignedShortLE();
        String sqlState = null;
        if ((this.encoder.clientCapabilitiesFlag & 0x200) != 0) {
            payload.skipBytes(1);
            sqlState = BufferUtils.readFixedLengthString(payload, 5, StandardCharsets.UTF_8);
        }
        String errorMessage = this.readRestOfPacketString(payload, StandardCharsets.UTF_8);
        this.completionHandler.handle((Object)CommandResponse.failure((Throwable)new MySQLException(errorMessage, errorCode, sqlState)));
    }

    Packets.OkPacket decodeOkPacketPayload(ByteBuf payload, Charset charset) {
        String statusInfo;
        payload.skipBytes(1);
        long affectedRows = BufferUtils.readLengthEncodedInteger(payload);
        long lastInsertId = BufferUtils.readLengthEncodedInteger(payload);
        int serverStatusFlags = 0;
        int numberOfWarnings = 0;
        if ((this.encoder.clientCapabilitiesFlag & 0x200) != 0) {
            serverStatusFlags = payload.readUnsignedShortLE();
            numberOfWarnings = payload.readUnsignedShortLE();
        } else if ((this.encoder.clientCapabilitiesFlag & 0x2000) != 0) {
            serverStatusFlags = payload.readUnsignedShortLE();
        }
        String sessionStateInfo = null;
        if (payload.readableBytes() == 0) {
            statusInfo = null;
        } else if ((this.encoder.clientCapabilitiesFlag & 0x800000) != 0) {
            statusInfo = BufferUtils.readLengthEncodedString(payload, charset);
            if ((serverStatusFlags & 0x4000) != 0) {
                sessionStateInfo = BufferUtils.readLengthEncodedString(payload, charset);
            }
        } else {
            statusInfo = this.readRestOfPacketString(payload, charset);
        }
        return new Packets.OkPacket(affectedRows, lastInsertId, serverStatusFlags, numberOfWarnings, statusInfo, sessionStateInfo);
    }

    Packets.EofPacket decodeEofPacketPayload(ByteBuf payload) {
        payload.skipBytes(1);
        int numberOfWarnings = payload.readUnsignedShortLE();
        int serverStatusFlags = payload.readUnsignedShortLE();
        return new Packets.EofPacket(numberOfWarnings, serverStatusFlags);
    }

    String readRestOfPacketString(ByteBuf payload, Charset charset) {
        return BufferUtils.readFixedLengthString(payload, payload.readableBytes(), charset);
    }

    ColumnDefinition decodeColumnDefinitionPacketPayload(ByteBuf payload) {
        String catalog = BufferUtils.readLengthEncodedString(payload, StandardCharsets.UTF_8);
        String schema = BufferUtils.readLengthEncodedString(payload, StandardCharsets.UTF_8);
        String table = BufferUtils.readLengthEncodedString(payload, StandardCharsets.UTF_8);
        String orgTable = BufferUtils.readLengthEncodedString(payload, StandardCharsets.UTF_8);
        String name = BufferUtils.readLengthEncodedString(payload, StandardCharsets.UTF_8);
        String orgName = BufferUtils.readLengthEncodedString(payload, StandardCharsets.UTF_8);
        long lengthOfFixedLengthFields = BufferUtils.readLengthEncodedInteger(payload);
        int characterSet = payload.readUnsignedShortLE();
        long columnLength = payload.readUnsignedIntLE();
        DataType type = DataType.valueOf(payload.readUnsignedByte());
        int flags = payload.readUnsignedShortLE();
        byte decimals = payload.readByte();
        return new ColumnDefinition(catalog, schema, table, orgTable, name, orgName, characterSet, columnLength, type, flags, decimals);
    }

    void skipEofPacketIfNeeded(ByteBuf payload) {
        if (!this.isDeprecatingEofFlagEnabled()) {
            payload.skipBytes(5);
        }
    }

    boolean isDeprecatingEofFlagEnabled() {
        return (this.encoder.clientCapabilitiesFlag & 0x1000000) != 0;
    }
}

