/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.mysqlclient.impl.codec.MySQLCodec;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SocketConnectionBase;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.InitCommand;
import java.util.Map;

public class MySQLSocketConnection
extends SocketConnectionBase {
    private MySQLCodec codec;

    public MySQLSocketConnection(NetSocketInternal socket, boolean cachePreparedStatements, int preparedStatementCacheSize, int preparedStatementCacheSqlLimit, Context context) {
        super(socket, cachePreparedStatements, preparedStatementCacheSize, preparedStatementCacheSqlLimit, 1, context);
    }

    void sendStartupMessage(String username, String password, String database, Map<String, String> properties, Handler<? super CommandResponse<Connection>> completionHandler) {
        InitCommand cmd = new InitCommand((SocketConnectionBase)this, username, password, database, properties);
        cmd.handler = completionHandler;
        this.schedule((CommandBase)cmd);
    }

    public void init() {
        this.codec = new MySQLCodec(this);
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        pipeline.addBefore("handler", "codec", (ChannelHandler)this.codec);
        super.init();
    }
}

