/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.impl.MySQLPoolImpl;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import java.util.List;
import java.util.stream.Collector;

@VertxGen
public interface MySQLPool
extends Pool {
    public static MySQLPool pool(String connectionUri) {
        return MySQLPool.pool(connectionUri, new PoolOptions());
    }

    public static MySQLPool pool(String connectionUri, PoolOptions poolOptions) {
        return MySQLPool.pool(MySQLConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static MySQLPool pool(Vertx vertx, String connectionUri) {
        return MySQLPool.pool(vertx, MySQLConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static MySQLPool pool(Vertx vertx, String connectionUri, PoolOptions poolOptions) {
        return MySQLPool.pool(vertx, MySQLConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static MySQLPool pool(MySQLConnectOptions connectOptions, PoolOptions poolOptions) {
        if (Vertx.currentContext() != null) {
            throw new IllegalStateException("Running in a Vertx context => use MySQLPool#pool(Vertx, MySQLConnectOptions, PoolOptions) instead");
        }
        VertxOptions vertxOptions = new VertxOptions();
        Vertx vertx = Vertx.vertx((VertxOptions)vertxOptions);
        return new MySQLPoolImpl(vertx.getOrCreateContext(), true, connectOptions, poolOptions);
    }

    public static MySQLPool pool(Vertx vertx, MySQLConnectOptions connectOptions, PoolOptions poolOptions) {
        return new MySQLPoolImpl(vertx.getOrCreateContext(), false, connectOptions, poolOptions);
    }

    public MySQLPool preparedQuery(String var1, Handler<AsyncResult<RowSet>> var2);

    @GenIgnore
    public <R> MySQLPool preparedQuery(String var1, Collector<Row, ?, R> var2, Handler<AsyncResult<SqlResult<R>>> var3);

    public MySQLPool query(String var1, Handler<AsyncResult<RowSet>> var2);

    @GenIgnore
    public <R> MySQLPool query(String var1, Collector<Row, ?, R> var2, Handler<AsyncResult<SqlResult<R>>> var3);

    public MySQLPool preparedQuery(String var1, Tuple var2, Handler<AsyncResult<RowSet>> var3);

    @GenIgnore
    public <R> MySQLPool preparedQuery(String var1, Tuple var2, Collector<Row, ?, R> var3, Handler<AsyncResult<SqlResult<R>>> var4);

    public MySQLPool preparedBatch(String var1, List<Tuple> var2, Handler<AsyncResult<RowSet>> var3);

    @GenIgnore
    public <R> MySQLPool preparedBatch(String var1, List<Tuple> var2, Collector<Row, ?, R> var3, Handler<AsyncResult<SqlResult<R>>> var4);
}

