/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.Handler;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.PRNG;
import io.vertx.ext.mail.LoginOption;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.StatusCode;
import io.vertx.ext.mail.impl.Utils;
import io.vertx.ext.mail.impl.sasl.AuthOperation;
import io.vertx.ext.mail.impl.sasl.AuthOperationFactory;
import io.vertx.ext.mail.impl.sasl.CryptUtils;
import java.util.Set;

class SMTPAuthentication {
    private final SMTPConnection connection;
    private final MailConfig config;
    private final Handler<Void> finishedHandler;
    private final Handler<Throwable> errorHandler;
    private static final Logger log = LoggerFactory.getLogger(SMTPAuthentication.class);
    private final AuthOperationFactory authOperationFactory;

    public SMTPAuthentication(SMTPConnection connection, MailConfig config, PRNG prng, Handler<Void> finishedHandler, Handler<Throwable> errorHandler) {
        this.connection = connection;
        this.config = config;
        this.finishedHandler = finishedHandler;
        this.errorHandler = errorHandler;
        this.authOperationFactory = new AuthOperationFactory(prng);
    }

    public void start() {
        boolean foundAllowedMethods;
        boolean bl = foundAllowedMethods = !this.intersectAllowedMethods().isEmpty();
        if (this.config.getLogin() != LoginOption.DISABLED && this.config.getUsername() != null && this.config.getPassword() != null && foundAllowedMethods) {
            this.authCmd();
        } else if (this.config.getLogin() == LoginOption.REQUIRED) {
            if (!foundAllowedMethods) {
                this.handleError("login is required, but no allowed AUTH methods available. You may need to do STARTTLS");
            } else {
                this.handleError("login is required, but no credentials supplied");
            }
        } else {
            this.finished();
        }
    }

    private Set<String> intersectAllowedMethods() {
        Set<String> allowed;
        String authMethods = this.config.getAuthMethods();
        if (authMethods == null || authMethods.isEmpty()) {
            allowed = this.connection.getCapa().getCapaAuth();
        } else {
            allowed = Utils.parseCapaAuth(authMethods);
            allowed.retainAll(this.connection.getCapa().getCapaAuth());
        }
        return allowed;
    }

    private void authCmd() {
        AuthOperation authOperation;
        try {
            authOperation = this.authOperationFactory.createAuth(this.config.getUsername(), this.config.getPassword(), this.intersectAllowedMethods());
        }
        catch (IllegalArgumentException | SecurityException ex) {
            log.warn((Object)"authentication factory threw exception", (Throwable)ex);
            this.handleError(ex);
            return;
        }
        if (authOperation != null) {
            this.authCmdStep(authOperation, null);
        } else {
            log.warn((Object)"cannot find supported auth method");
            this.handleError("cannot find supported auth method");
        }
    }

    private void authCmdStep(AuthOperation authMethod, String message) {
        int blank;
        String nextLine;
        if (message == null) {
            String authParameter = authMethod.nextStep(null);
            if (!authParameter.isEmpty()) {
                nextLine = "AUTH " + authMethod.getName() + " " + CryptUtils.base64(authParameter);
                blank = authMethod.getName().length() + 6;
            } else {
                nextLine = "AUTH " + authMethod.getName();
                blank = -1;
            }
        } else {
            nextLine = CryptUtils.base64(authMethod.nextStep(CryptUtils.decodeb64(message.substring(4))));
            blank = 0;
        }
        this.connection.write(nextLine, blank, (Handler<String>)((Handler)message2 -> {
            log.debug((Object)("AUTH command result: " + message2));
            if (StatusCode.isStatusOk(message2)) {
                if (StatusCode.isStatusContinue(message2)) {
                    this.authCmdStep(authMethod, (String)message2);
                } else {
                    this.finished();
                }
            } else {
                this.handleError("AUTH " + authMethod.getName() + " failed " + message2);
            }
        }));
    }

    private void finished() {
        this.finishedHandler.handle(null);
    }

    private void handleError(String message) {
        this.errorHandler.handle((Object)new NoStackTraceThrowable(message));
    }

    private void handleError(Throwable th) {
        this.errorHandler.handle((Object)th);
    }
}

