require 'vertx/multi_map'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.eventbus.Message
module Vertx
  #  Represents a message that is received from the event bus in a handler.
  #  <p>
  #  Messages have a {::Vertx::Message#body}, which can be null, and also {::Vertx::Message#headers}, which can be empty.
  #  <p>
  #  If the message was sent specifying a reply handler, it can be replied to using {::Vertx::Message#reply}.
  #  <p>
  #  If you want to notify the sender that processing failed, then {::Vertx::Message#fail} can be called.
  class Message
    # @private
    # @param j_del [::Vertx::Message] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::Vertx::Message] the underlying java delegate
    def j_del
      @j_del
    end
    #  The address the message was sent to
    # @return [String]
    def address
      if !block_given?
        return @j_del.java_method(:address, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling address()"
    end
    #  Multi-map of message headers. Can be empty
    # @return [::Vertx::MultiMap] the headers
    def headers
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:headers, []).call(),::Vertx::MultiMap)
      end
      raise ArgumentError, "Invalid arguments when calling headers()"
    end
    #  The body of the message. Can be null.
    # @return [Object] the body, or null.
    def body
      if !block_given?
        if @cached_body != nil
          return @cached_body
        end
        return @cached_body = @j_arg_T.wrap(@j_del.java_method(:body, []).call())
      end
      raise ArgumentError, "Invalid arguments when calling body()"
    end
    #  The reply address. Can be null.
    # @return [String] the reply address, or null, if message was sent without a reply handler.
    def reply_address
      if !block_given?
        return @j_del.java_method(:replyAddress, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling reply_address()"
    end
    #  Signals if this message represents a send or publish event.
    # @return [true,false] true if this is a send.
    def send?
      if !block_given?
        return @j_del.java_method(:isSend, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling send?()"
    end
    #  The same as <code>reply(R message, DeliveryOptions)</code> but you can specify handler for the reply - i.e.
    #  to receive the reply to the reply.
    # @param [Object] message the reply message
    # @param [Hash] options the delivery options
    # @yield the reply handler for the reply.
    # @return [void]
    def reply(message=nil,options=nil)
      if ::Vertx::Util::unknown_type.accept?(message) && !block_given? && options == nil
        return @j_del.java_method(:reply, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(message))
      elsif ::Vertx::Util::unknown_type.accept?(message) && block_given? && options == nil
        return @j_del.java_method(:reply, [Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_object(message),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Message, nil) : nil) }))
      elsif ::Vertx::Util::unknown_type.accept?(message) && options.class == Hash && !block_given?
        return @j_del.java_method(:reply, [Java::java.lang.Object.java_class,Java::IoVertxCoreEventbus::DeliveryOptions.java_class]).call(::Vertx::Util::Utils.to_object(message),Java::IoVertxCoreEventbus::DeliveryOptions.new(::Vertx::Util::Utils.to_json_object(options)))
      elsif ::Vertx::Util::unknown_type.accept?(message) && options.class == Hash && block_given?
        return @j_del.java_method(:reply, [Java::java.lang.Object.java_class,Java::IoVertxCoreEventbus::DeliveryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_object(message),Java::IoVertxCoreEventbus::DeliveryOptions.new(::Vertx::Util::Utils.to_json_object(options)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Message, nil) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling reply(#{message},#{options})"
    end
    #  Like {::Vertx::Message#reply_and_request} but specifying <code>options</code> that can be used
    #  to configure the delivery.
    # @param [Object] message the message body, may be <code>null</code>
    # @param [Hash] options delivery options
    # @yield reply handler will be called when any reply from the recipient is received
    # @return [void]
    def reply_and_request(message=nil,options=nil)
      if ::Vertx::Util::unknown_type.accept?(message) && block_given? && options == nil
        return @j_del.java_method(:replyAndRequest, [Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_object(message),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Message, nil) : nil) }))
      elsif ::Vertx::Util::unknown_type.accept?(message) && options.class == Hash && block_given?
        return @j_del.java_method(:replyAndRequest, [Java::java.lang.Object.java_class,Java::IoVertxCoreEventbus::DeliveryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_object(message),Java::IoVertxCoreEventbus::DeliveryOptions.new(::Vertx::Util::Utils.to_json_object(options)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Message, nil) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling reply_and_request(#{message},#{options})"
    end
    #  Signal to the sender that processing of this message failed.
    #  <p>
    #  If the message was sent specifying a result handler
    #  the handler will be called with a failure corresponding to the failure code and message specified here.
    # @param [Fixnum] failureCode A failure code to pass back to the sender
    # @param [String] message A message to pass back to the sender
    # @return [void]
    def fail(failureCode=nil,message=nil)
      if failureCode.class == Fixnum && message.class == String && !block_given?
        return @j_del.java_method(:fail, [Java::int.java_class,Java::java.lang.String.java_class]).call(failureCode,message)
      end
      raise ArgumentError, "Invalid arguments when calling fail(#{failureCode},#{message})"
    end
  end
end
