require 'vertx/pipe'
require 'vertx/buffer'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx/json_event'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.parsetools.JsonParser
module Vertx
  #  A parser class which allows to incrementally parse json elements and emit json parse events instead of parsing a json
  #  element fully. This parser is convenient for parsing large json structures.
  #  <p/>
  #  The parser also parses concatenated json streams or line delimited json streams.
  #  <p/>
  #  The parser can also parse entire object or array when it is convenient, for instance a very large array
  #  of small objects can be parsed efficiently by handling array <i>start</i>/<i>end</i> and <i>object</i>
  #  events.
  #  <p/>
  #  Whenever the parser fails to parse or process the stream, the {::Vertx::JsonParser#exception_handler} is called with
  #  the cause of the failure and the current handling stops. After such event, the parser should not handle data
  #  anymore.
  class JsonParser
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::Vertx::JsonParser] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::JsonParser] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == JsonParser
    end
    def @@j_api_type.wrap(obj)
      JsonParser.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreParsetools::JsonParser.java_class
    end
    #  Something has happened, so handle it.
    # @param [::Vertx::Buffer] event the event to handle
    # @return [void]
    def handle(event=nil)
      if event.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(event.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling handle(#{event})"
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::Vertx::JsonEvent.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling pipe()"
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @param [::Vertx::WriteStream] dst the destination write stream
    # @yield 
    # @return [void]
    def pipe_to(dst=nil)
      if dst.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class]).call(dst.j_del)
      elsif dst.class.method_defined?(:j_del) && block_given?
        return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(dst.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling pipe_to(#{dst})"
    end
    #  Create a new <code>JsonParser</code> instance.
    # @param [::Vertx::ReadStream] stream 
    # @return [::Vertx::JsonParser]
    def self.new_parser(stream=nil)
      if !block_given? && stream == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::JsonParser.java_method(:newParser, []).call(),::Vertx::JsonParser)
      elsif stream.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::JsonParser.java_method(:newParser, [Java::IoVertxCoreStreams::ReadStream.java_class]).call(stream.j_del),::Vertx::JsonParser)
      end
      raise ArgumentError, "Invalid arguments when calling new_parser(#{stream})"
    end
    #  Handle a <code>Buffer</code>, pretty much like calling {Proc#handle}.
    # @param [::Vertx::Buffer] buffer 
    # @return [self]
    def write(buffer=nil)
      if buffer.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:write, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(buffer.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling write(#{buffer})"
    end
    #  End the stream, this must be called after all the json stream has been processed.
    # @return [void]
    def end
      if !block_given?
        return @j_del.java_method(:end, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling end()"
    end
    #  Flip the parser to emit a stream of events for each new json object.
    # @return [self]
    def object_event_mode
      if !block_given?
        @j_del.java_method(:objectEventMode, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling object_event_mode()"
    end
    #  Flip the parser to emit a single value event for each new json object.
    #  </p>
    #  Json object currently streamed won't be affected.
    # @return [self]
    def object_value_mode
      if !block_given?
        @j_del.java_method(:objectValueMode, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling object_value_mode()"
    end
    #  Flip the parser to emit a stream of events for each new json array.
    # @return [self]
    def array_event_mode
      if !block_given?
        @j_del.java_method(:arrayEventMode, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling array_event_mode()"
    end
    #  Flip the parser to emit a single value event for each new json array.
    #  </p>
    #  Json array currently streamed won't be affected.
    # @return [self]
    def array_value_mode
      if !block_given?
        @j_del.java_method(:arrayValueMode, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling array_value_mode()"
    end
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pause()"
    end
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling resume()"
    end
    # @param [Fixnum] amount 
    # @return [self]
    def fetch(amount=nil)
      if amount.class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(amount)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling fetch(#{amount})"
    end
    # @yield 
    # @return [self]
    def end_handler
      if block_given?
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling end_handler()"
    end
    # @yield 
    # @return [self]
    def handler
      if block_given?
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::JsonEvent)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling handler()"
    end
    # @yield 
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
  end
end
