require 'vertx/cookie'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.Cookie
module VertxWeb
  #  Represents an HTTP Cookie.
  #  <p>
  #  All cookies must have a name and a value and can optionally have other fields set such as path, domain, etc.
  #  <p>
  #  (Derived from io.netty.handler.codec.http.Cookie)
  class Cookie < ::Vertx::Cookie
    # @private
    # @param j_del [::VertxWeb::Cookie] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::Cookie] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Cookie
    end
    def @@j_api_type.wrap(obj)
      Cookie.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWeb::Cookie.java_class
    end
    # @return [String] the name of this cookie
    def get_name
      if !block_given?
        return @j_del.java_method(:getName, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_name()"
    end
    # @return [String] the value of this cookie
    def get_value
      if !block_given?
        return @j_del.java_method(:getValue, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_value()"
    end
    # @return [String] the domain for the cookie
    def get_domain
      if !block_given?
        return @j_del.java_method(:getDomain, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_domain()"
    end
    # @return [String] the path for this cookie
    def get_path
      if !block_given?
        return @j_del.java_method(:getPath, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_path()"
    end
    #  Encode the cookie to a string. This is what is used in the Set-Cookie header
    # @return [String] the encoded cookie
    def encode
      if !block_given?
        return @j_del.java_method(:encode, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling encode()"
    end
    #  Create a new cookie
    # @param [String] name the name of the cookie
    # @param [String] value the cookie value
    # @return [::VertxWeb::Cookie] the cookie
    def self.cookie(name=nil,value=nil)
      if name.class == String && value.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWeb::Cookie.java_method(:cookie, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(name,value),::VertxWeb::Cookie)
      end
      raise ArgumentError, "Invalid arguments when calling cookie(#{name},#{value})"
    end
    # @param [String] value 
    # @return [self]
    def set_value(value=nil)
      if value.class == String && !block_given?
        @j_del.java_method(:setValue, [Java::java.lang.String.java_class]).call(value)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_value(#{value})"
    end
    # @param [String] domain 
    # @return [self]
    def set_domain(domain=nil)
      if domain.class == String && !block_given?
        @j_del.java_method(:setDomain, [Java::java.lang.String.java_class]).call(domain)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_domain(#{domain})"
    end
    # @param [String] path 
    # @return [self]
    def set_path(path=nil)
      if path.class == String && !block_given?
        @j_del.java_method(:setPath, [Java::java.lang.String.java_class]).call(path)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_path(#{path})"
    end
    # @param [Fixnum] maxAge 
    # @return [self]
    def set_max_age(maxAge=nil)
      if maxAge.class == Fixnum && !block_given?
        @j_del.java_method(:setMaxAge, [Java::long.java_class]).call(maxAge)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_max_age(#{maxAge})"
    end
    # @param [true,false] secure 
    # @return [self]
    def set_secure(secure=nil)
      if (secure.class == TrueClass || secure.class == FalseClass) && !block_given?
        @j_del.java_method(:setSecure, [Java::boolean.java_class]).call(secure)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_secure(#{secure})"
    end
    # @param [true,false] httpOnly 
    # @return [self]
    def set_http_only(httpOnly=nil)
      if (httpOnly.class == TrueClass || httpOnly.class == FalseClass) && !block_given?
        @j_del.java_method(:setHttpOnly, [Java::boolean.java_class]).call(httpOnly)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_http_only(#{httpOnly})"
    end
    #  Has the cookie been changed? Changed cookieMap will be saved out in the response and sent to the browser.
    # @return [true,false] true if changed
    def changed?
      if !block_given?
        return @j_del.java_method(:isChanged, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling changed?()"
    end
    #  Set the cookie as being changed. Changed will be true for a cookie just created, false by default if just
    #  read from the request
    # @param [true,false] changed true if changed
    # @return [void]
    def set_changed(changed=nil)
      if (changed.class == TrueClass || changed.class == FalseClass) && !block_given?
        return @j_del.java_method(:setChanged, [Java::boolean.java_class]).call(changed)
      end
      raise ArgumentError, "Invalid arguments when calling set_changed(#{changed})"
    end
    #  Has this Cookie been sent from the User Agent (the browser)? or was created during the executing on the request.
    # @return [true,false] true if the cookie comes from the User Agent.
    def from_user_agent?
      if !block_given?
        return @j_del.java_method(:isFromUserAgent, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling from_user_agent?()"
    end
  end
end
