require 'vertx-redis/response'
require 'vertx-redis/redis'
require 'vertx/util/utils.rb'
# Generated from io.vertx.redis.client.RedisAPI
module VertxRedis
  #  <b>Auto generated</b> Redis API client wrapper.
  class RedisAPI
    # @private
    # @param j_del [::VertxRedis::RedisAPI] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxRedis::RedisAPI] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == RedisAPI
    end
    def @@j_api_type.wrap(obj)
      RedisAPI.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxRedisClient::RedisAPI.java_class
    end
    # @param [::VertxRedis::Redis] client 
    # @return [::VertxRedis::RedisAPI]
    def self.api(client=nil)
      if client.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::RedisAPI.java_method(:api, [Java::IoVertxRedisClient::Redis.java_class]).call(client.j_del),::VertxRedis::RedisAPI)
      end
      raise ArgumentError, "Invalid arguments when calling api(#{client})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def append(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:append, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling append(#{arg0},#{arg1})"
    end
    # @yield 
    # @return [self]
    def asking
      if block_given?
        @j_del.java_method(:asking, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling asking()"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def auth(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:auth, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling auth(#{arg0})"
    end
    # @yield 
    # @return [self]
    def bgrewriteaof
      if block_given?
        @j_del.java_method(:bgrewriteaof, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling bgrewriteaof()"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def bgsave(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:bgsave, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling bgsave(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def bitcount(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:bitcount, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling bitcount(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def bitfield(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:bitfield, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling bitfield(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def bitop(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:bitop, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling bitop(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def bitpos(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:bitpos, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling bitpos(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def blpop(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:blpop, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling blpop(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def brpop(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:brpop, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling brpop(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def brpoplpush(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:brpoplpush, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling brpoplpush(#{arg0},#{arg1},#{arg2})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def bzpopmax(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:bzpopmax, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling bzpopmax(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def bzpopmin(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:bzpopmin, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling bzpopmin(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def client(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:client, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling client(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def cluster(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:cluster, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling cluster(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def command(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:command, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling command(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def config(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:config, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling config(#{args})"
    end
    # @yield 
    # @return [self]
    def dbsize
      if block_given?
        @j_del.java_method(:dbsize, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling dbsize()"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def debug(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:debug, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling debug(#{args})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def decr(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:decr, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling decr(#{arg0})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def decrby(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:decrby, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling decrby(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def del(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:del, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling del(#{args})"
    end
    # @yield 
    # @return [self]
    def discard
      if block_given?
        @j_del.java_method(:discard, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling discard()"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def dump(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:dump, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling dump(#{arg0})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def echo(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:echo, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling echo(#{arg0})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def eval(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:eval, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling eval(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def evalsha(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:evalsha, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling evalsha(#{args})"
    end
    # @yield 
    # @return [self]
    def exec
      if block_given?
        @j_del.java_method(:exec, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exec()"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def exists(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:exists, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exists(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def expire(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:expire, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling expire(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def expireat(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:expireat, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling expireat(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def flushall(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:flushall, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling flushall(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def flushdb(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:flushdb, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling flushdb(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def geoadd(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:geoadd, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling geoadd(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def geodist(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:geodist, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling geodist(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def geohash(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:geohash, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling geohash(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def geopos(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:geopos, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling geopos(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def georadius(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:georadius, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling georadius(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def georadius_ro(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:georadiusRo, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling georadius_ro(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def georadiusbymember(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:georadiusbymember, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling georadiusbymember(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def georadiusbymember_ro(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:georadiusbymemberRo, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling georadiusbymember_ro(#{args})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def get(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:get, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling get(#{arg0})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def getbit(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:getbit, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling getbit(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def getrange(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:getrange, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling getrange(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def getset(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:getset, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling getset(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def hdel(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:hdel, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling hdel(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def hexists(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:hexists, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling hexists(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def hget(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:hget, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling hget(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def hgetall(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:hgetall, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling hgetall(#{arg0})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def hincrby(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:hincrby, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling hincrby(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def hincrbyfloat(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:hincrbyfloat, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling hincrbyfloat(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def hkeys(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:hkeys, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling hkeys(#{arg0})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def hlen(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:hlen, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling hlen(#{arg0})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def hmget(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:hmget, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling hmget(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def hmset(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:hmset, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling hmset(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def host(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:host, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling host(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def hscan(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:hscan, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling hscan(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def hset(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:hset, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling hset(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def hsetnx(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:hsetnx, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling hsetnx(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def hstrlen(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:hstrlen, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling hstrlen(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def hvals(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:hvals, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling hvals(#{arg0})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def incr(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:incr, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling incr(#{arg0})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def incrby(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:incrby, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling incrby(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def incrbyfloat(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:incrbyfloat, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling incrbyfloat(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def info(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:info, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling info(#{args})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def keys(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:keys, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling keys(#{arg0})"
    end
    # @yield 
    # @return [self]
    def lastsave
      if block_given?
        @j_del.java_method(:lastsave, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling lastsave()"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def latency(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:latency, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling latency(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def lindex(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:lindex, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling lindex(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @param [String] arg3 
    # @yield 
    # @return [self]
    def linsert(arg0=nil,arg1=nil,arg2=nil,arg3=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && arg3.class == String && block_given?
        @j_del.java_method(:linsert, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,arg3,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling linsert(#{arg0},#{arg1},#{arg2},#{arg3})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def llen(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:llen, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling llen(#{arg0})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def lolwut(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:lolwut, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling lolwut(#{args})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def lpop(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:lpop, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling lpop(#{arg0})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def lpush(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:lpush, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling lpush(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def lpushx(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:lpushx, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling lpushx(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def lrange(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:lrange, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling lrange(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def lrem(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:lrem, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling lrem(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def lset(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:lset, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling lset(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def ltrim(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:ltrim, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling ltrim(#{arg0},#{arg1},#{arg2})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def memory(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:memory, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling memory(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def mget(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:mget, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling mget(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def migrate(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:migrate, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling migrate(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def module(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:module, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling module(#{args})"
    end
    # @yield 
    # @return [self]
    def monitor
      if block_given?
        @j_del.java_method(:monitor, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling monitor()"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def move(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:move, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling move(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def mset(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:mset, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling mset(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def msetnx(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:msetnx, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling msetnx(#{args})"
    end
    # @yield 
    # @return [self]
    def multi
      if block_given?
        @j_del.java_method(:multi, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling multi()"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def object(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:object, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling object(#{args})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def persist(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:persist, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling persist(#{arg0})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def pexpire(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:pexpire, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pexpire(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def pexpireat(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:pexpireat, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pexpireat(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def pfadd(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:pfadd, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pfadd(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def pfcount(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:pfcount, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pfcount(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def pfdebug(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:pfdebug, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pfdebug(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def pfmerge(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:pfmerge, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pfmerge(#{args})"
    end
    # @yield 
    # @return [self]
    def pfselftest
      if block_given?
        @j_del.java_method(:pfselftest, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pfselftest()"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def ping(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:ping, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling ping(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def post(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:post, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling post(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def psetex(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:psetex, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling psetex(#{arg0},#{arg1},#{arg2})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def psubscribe(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:psubscribe, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling psubscribe(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def psync(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:psync, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling psync(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def pttl(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:pttl, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pttl(#{arg0})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def publish(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:publish, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling publish(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def pubsub(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:pubsub, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pubsub(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def punsubscribe(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:punsubscribe, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling punsubscribe(#{args})"
    end
    # @yield 
    # @return [self]
    def randomkey
      if block_given?
        @j_del.java_method(:randomkey, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling randomkey()"
    end
    # @yield 
    # @return [self]
    def readonly
      if block_given?
        @j_del.java_method(:readonly, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling readonly()"
    end
    # @yield 
    # @return [self]
    def readwrite
      if block_given?
        @j_del.java_method(:readwrite, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling readwrite()"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def rename(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:rename, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling rename(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def renamenx(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:renamenx, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling renamenx(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def replconf(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:replconf, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling replconf(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def replicaof(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:replicaof, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling replicaof(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def restore(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:restore, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling restore(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def restore_asking(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:restoreAsking, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling restore_asking(#{args})"
    end
    # @yield 
    # @return [self]
    def role
      if block_given?
        @j_del.java_method(:role, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling role()"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def rpop(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:rpop, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling rpop(#{arg0})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def rpoplpush(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:rpoplpush, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling rpoplpush(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def rpush(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:rpush, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling rpush(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def rpushx(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:rpushx, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling rpushx(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def sadd(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:sadd, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling sadd(#{args})"
    end
    # @yield 
    # @return [self]
    def save
      if block_given?
        @j_del.java_method(:save, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling save()"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def scan(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:scan, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling scan(#{args})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def scard(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:scard, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling scard(#{arg0})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def script(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:script, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling script(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def sdiff(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:sdiff, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling sdiff(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def sdiffstore(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:sdiffstore, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling sdiffstore(#{args})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def select(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:select, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling select(#{arg0})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def set(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:set, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def setbit(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:setbit, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling setbit(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def setex(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:setex, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling setex(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def setnx(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:setnx, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling setnx(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def setrange(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:setrange, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling setrange(#{arg0},#{arg1},#{arg2})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def shutdown(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:shutdown, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling shutdown(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def sinter(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:sinter, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling sinter(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def sinterstore(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:sinterstore, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling sinterstore(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def sismember(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:sismember, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling sismember(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def slaveof(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:slaveof, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling slaveof(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def slowlog(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:slowlog, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling slowlog(#{args})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def smembers(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:smembers, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling smembers(#{arg0})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def smove(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:smove, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling smove(#{arg0},#{arg1},#{arg2})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def sort(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:sort, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling sort(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def spop(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:spop, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling spop(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def srandmember(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:srandmember, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling srandmember(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def srem(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:srem, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling srem(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def sscan(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:sscan, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling sscan(#{args})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def strlen(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:strlen, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling strlen(#{arg0})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def subscribe(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:subscribe, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling subscribe(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def substr(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:substr, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling substr(#{arg0},#{arg1},#{arg2})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def sunion(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:sunion, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling sunion(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def sunionstore(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:sunionstore, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling sunionstore(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def swapdb(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:swapdb, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling swapdb(#{arg0},#{arg1})"
    end
    # @yield 
    # @return [self]
    def sync
      if block_given?
        @j_del.java_method(:sync, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling sync()"
    end
    # @yield 
    # @return [self]
    def time
      if block_given?
        @j_del.java_method(:time, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling time()"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def touch(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:touch, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling touch(#{args})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def ttl(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:ttl, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling ttl(#{arg0})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def type(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:type, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling type(#{arg0})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def unlink(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:unlink, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling unlink(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def unsubscribe(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:unsubscribe, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling unsubscribe(#{args})"
    end
    # @yield 
    # @return [self]
    def unwatch
      if block_given?
        @j_del.java_method(:unwatch, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling unwatch()"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def wait(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:wait, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling wait(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def watch(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:watch, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling watch(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def xack(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:xack, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling xack(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def xadd(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:xadd, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling xadd(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def xclaim(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:xclaim, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling xclaim(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def xdel(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:xdel, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling xdel(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def xgroup(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:xgroup, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling xgroup(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def xinfo(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:xinfo, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling xinfo(#{args})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def xlen(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:xlen, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling xlen(#{arg0})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def xpending(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:xpending, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling xpending(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def xrange(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:xrange, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling xrange(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def xread(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:xread, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling xread(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def xreadgroup(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:xreadgroup, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling xreadgroup(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def xrevrange(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:xrevrange, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling xrevrange(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def xsetid(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:xsetid, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling xsetid(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def xtrim(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:xtrim, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling xtrim(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def zadd(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:zadd, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zadd(#{args})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def zcard(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:zcard, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zcard(#{arg0})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def zcount(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:zcount, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zcount(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def zincrby(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:zincrby, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zincrby(#{arg0},#{arg1},#{arg2})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def zinterstore(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:zinterstore, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zinterstore(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def zlexcount(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:zlexcount, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zlexcount(#{arg0},#{arg1},#{arg2})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def zpopmax(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:zpopmax, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zpopmax(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def zpopmin(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:zpopmin, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zpopmin(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def zrange(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:zrange, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zrange(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def zrangebylex(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:zrangebylex, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zrangebylex(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def zrangebyscore(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:zrangebyscore, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zrangebyscore(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def zrank(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:zrank, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zrank(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def zrem(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:zrem, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zrem(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def zremrangebylex(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:zremrangebylex, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zremrangebylex(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def zremrangebyrank(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:zremrangebyrank, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zremrangebyrank(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def zremrangebyscore(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:zremrangebyscore, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zremrangebyscore(#{arg0},#{arg1},#{arg2})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def zrevrange(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:zrevrange, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zrevrange(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def zrevrangebylex(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:zrevrangebylex, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zrevrangebylex(#{args})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def zrevrangebyscore(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:zrevrangebyscore, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zrevrangebyscore(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def zrevrank(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:zrevrank, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zrevrank(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def zscan(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:zscan, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zscan(#{args})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def zscore(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:zscore, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zscore(#{arg0},#{arg1})"
    end
    # @param [Array<String>] args 
    # @yield 
    # @return [self]
    def zunionstore(args=nil)
      if args.class == Array && block_given?
        @j_del.java_method(:zunionstore, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling zunionstore(#{args})"
    end
  end
end
