require 'vertx/vertx'
require 'vertx-sql-client/pool'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/tuple'
require 'vertx/util/utils.rb'
# Generated from io.vertx.pgclient.PgPool
module VertxPgClient
  #  A pool of PostgreSQL connections.
  class PgPool < ::VertxSqlClient::Pool
    # @private
    # @param j_del [::VertxPgClient::PgPool] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxPgClient::PgPool] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PgPool
    end
    def @@j_api_type.wrap(obj)
      PgPool.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxPgclient::PgPool.java_class
    end
    #  Get a connection from the pool.
    # @yield the handler that will get the connection result
    # @return [void]
    def get_connection
      if block_given?
        return @j_del.java_method(:getConnection, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::SqlConnection) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling get_connection()"
    end
    #  Borrow a connection from the pool and begin a transaction, the underlying connection will be returned
    #  to the pool when the transaction ends.
    # @yield 
    # @return [void]
    def begin
      if block_given?
        return @j_del.java_method(:begin, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::Transaction) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling begin()"
    end
    #  Close the pool and release the associated resources.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
    #  Like {::VertxPgClient::PgPool#pool} with a specific  instance.
    # @overload pool()
    # @overload pool(poolOptions)
    #   @param [Hash] poolOptions 
    # @overload pool(connectionUri)
    #   @param [String] connectionUri 
    # @overload pool(connectionUri,poolOptions)
    #   @param [String] connectionUri 
    #   @param [Hash] poolOptions 
    # @overload pool(vertx,connectionUri)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] connectionUri 
    # @overload pool(vertx,poolOptions)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [Hash] poolOptions 
    # @overload pool(connectOptions,poolOptions)
    #   @param [Hash] connectOptions 
    #   @param [Hash] poolOptions the options for creating the pool
    # @overload pool(vertx,connectionUri,poolOptions)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] connectionUri 
    #   @param [Hash] poolOptions 
    # @overload pool(vertx,connectOptions,poolOptions)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [Hash] connectOptions 
    #   @param [Hash] poolOptions 
    # @return [::VertxPgClient::PgPool]
    def self.pool(param_1=nil,param_2=nil,param_3=nil)
      if !block_given? && param_1 == nil && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, []).call(),::VertxPgClient::PgPool)
      elsif param_1.class == Hash && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::IoVertxSqlclient::PoolOptions.java_class]).call(Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(param_1))),::VertxPgClient::PgPool)
      elsif param_1.class == String && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::java.lang.String.java_class]).call(param_1),::VertxPgClient::PgPool)
      elsif param_1.class == String && param_2.class == Hash && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::PoolOptions.java_class]).call(param_1,Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(param_2))),::VertxPgClient::PgPool)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(param_1.j_del,param_2),::VertxPgClient::PgPool)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == Hash && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxSqlclient::PoolOptions.java_class]).call(param_1.j_del,Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(param_2))),::VertxPgClient::PgPool)
      elsif param_1.class == Hash && param_2.class == Hash && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::IoVertxPgclient::PgConnectOptions.java_class,Java::IoVertxSqlclient::PoolOptions.java_class]).call(Java::IoVertxPgclient::PgConnectOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(param_2))),::VertxPgClient::PgPool)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && param_3.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::IoVertxSqlclient::PoolOptions.java_class]).call(param_1.j_del,param_2,Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(param_3))),::VertxPgClient::PgPool)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == Hash && param_3.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxPgclient::PgConnectOptions.java_class,Java::IoVertxSqlclient::PoolOptions.java_class]).call(param_1.j_del,Java::IoVertxPgclient::PgConnectOptions.new(::Vertx::Util::Utils.to_json_object(param_2)),Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(param_3))),::VertxPgClient::PgPool)
      end
      raise ArgumentError, "Invalid arguments when calling pool(#{param_1},#{param_2},#{param_3})"
    end
    # @param [String] sql 
    # @param [::VertxSqlClient::Tuple] arguments 
    # @yield 
    # @return [self]
    def prepared_query(sql=nil,arguments=nil)
      if sql.class == String && block_given? && arguments == nil
        @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      elsif sql.class == String && arguments.class.method_defined?(:j_del) && block_given?
        @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,arguments.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepared_query(#{sql},#{arguments})"
    end
    # @param [String] sql 
    # @yield 
    # @return [self]
    def query(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query(#{sql})"
    end
    # @param [String] sql 
    # @param [Array<::VertxSqlClient::Tuple>] batch 
    # @yield 
    # @return [self]
    def prepared_batch(sql=nil,batch=nil)
      if sql.class == String && batch.class == Array && block_given?
        @j_del.java_method(:preparedBatch, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,batch.map { |element| element.j_del },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepared_batch(#{sql},#{batch})"
    end
  end
end
