require 'vertx-mqtt/mqtt_conn_ack_message'
require 'vertx/buffer'
require 'vertx/vertx'
require 'vertx-mqtt/mqtt_publish_message'
require 'vertx-mqtt/mqtt_sub_ack_message'
require 'vertx/util/utils.rb'
# Generated from io.vertx.mqtt.MqttClient
module VertxMqtt
  #  An MQTT client
  class MqttClient
    # @private
    # @param j_del [::VertxMqtt::MqttClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMqtt::MqttClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MqttClient
    end
    def @@j_api_type.wrap(obj)
      MqttClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxMqtt::MqttClient.java_class
    end
    #  Return an MQTT client instance
    # @param [::Vertx::Vertx] vertx Vert.x instance
    # @param [Hash] options MQTT client options
    # @return [::VertxMqtt::MqttClient] MQTT client instance
    def self.create(vertx=nil,options=nil)
      if vertx.class.method_defined?(:j_del) && !block_given? && options == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxMqtt::MqttClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(vertx.j_del),::VertxMqtt::MqttClient)
      elsif vertx.class.method_defined?(:j_del) && options.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxMqtt::MqttClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxMqtt::MqttClientOptions.java_class]).call(vertx.j_del,Java::IoVertxMqtt::MqttClientOptions.new(::Vertx::Util::Utils.to_json_object(options))),::VertxMqtt::MqttClient)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{vertx},#{options})"
    end
    #  Connects to an MQTT server calling connectHandler after connection
    # @param [Fixnum] port port of the MQTT server
    # @param [String] host hostname/ip address of the MQTT server
    # @param [String] serverName the SNI server name
    # @yield handler called when the asynchronous connect call ends
    # @return [self]
    def connect(port=nil,host=nil,serverName=nil)
      if port.class == Fixnum && host.class == String && block_given? && serverName == nil
        @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(port,host,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMqtt::MqttConnAckMessage) : nil) }))
        return self
      elsif port.class == Fixnum && host.class == String && serverName.class == String && block_given?
        @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(port,host,serverName,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMqtt::MqttConnAckMessage) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling connect(#{port},#{host},#{serverName})"
    end
    #  Disconnects from the MQTT server calling disconnectHandler after disconnection
    # @yield handler called when asynchronous disconnect call ends
    # @return [self]
    def disconnect
      if !block_given?
        @j_del.java_method(:disconnect, []).call()
        return self
      elsif block_given?
        @j_del.java_method(:disconnect, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling disconnect()"
    end
    #  Sends the PUBLISH message to the remote MQTT server
    # @param [String] topic topic on which the message is published
    # @param [::Vertx::Buffer] payload message payload
    # @param [:AT_MOST_ONCE,:AT_LEAST_ONCE,:EXACTLY_ONCE,:FAILURE] qosLevel QoS level
    # @param [true,false] isDup if the message is a duplicate
    # @param [true,false] isRetain if the message needs to be retained
    # @yield handler called after PUBLISH packet sent with packetid (not when QoS 0)
    # @return [self]
    def publish(topic=nil,payload=nil,qosLevel=nil,isDup=nil,isRetain=nil)
      if topic.class == String && payload.class.method_defined?(:j_del) && qosLevel.class == Symbol && (isDup.class == TrueClass || isDup.class == FalseClass) && (isRetain.class == TrueClass || isRetain.class == FalseClass) && !block_given?
        @j_del.java_method(:publish, [Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoNettyHandlerCodecMqtt::MqttQoS.java_class,Java::boolean.java_class,Java::boolean.java_class]).call(topic,payload.j_del,Java::IoNettyHandlerCodecMqtt::MqttQoS.valueOf(qosLevel.to_s),isDup,isRetain)
        return self
      elsif topic.class == String && payload.class.method_defined?(:j_del) && qosLevel.class == Symbol && (isDup.class == TrueClass || isDup.class == FalseClass) && (isRetain.class == TrueClass || isRetain.class == FalseClass) && block_given?
        @j_del.java_method(:publish, [Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoNettyHandlerCodecMqtt::MqttQoS.java_class,Java::boolean.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(topic,payload.j_del,Java::IoNettyHandlerCodecMqtt::MqttQoS.valueOf(qosLevel.to_s),isDup,isRetain,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling publish(#{topic},#{payload},#{qosLevel},#{isDup},#{isRetain})"
    end
    #  Sets handler which will be called each time publish is completed
    # @yield handler called with the packetId
    # @return [self]
    def publish_completion_handler
      if block_given?
        @j_del.java_method(:publishCompletionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling publish_completion_handler()"
    end
    #  Sets handler which will be called each time server publish something to client
    # @yield handler to call
    # @return [self]
    def publish_handler
      if block_given?
        @j_del.java_method(:publishHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxMqtt::MqttPublishMessage)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling publish_handler()"
    end
    #  Sets handler which will be called after SUBACK packet receiving
    # @yield handler to call. List inside is a granted QoS array
    # @return [self]
    def subscribe_completion_handler
      if block_given?
        @j_del.java_method(:subscribeCompletionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxMqtt::MqttSubAckMessage)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling subscribe_completion_handler()"
    end
    #  Subscribes to the topic with a specified QoS level
    # @overload subscribe(topics)
    #   @param [Hash{String => Fixnum}] topics topics and related QoS levels to subscribe to
    # @overload subscribe(topic,qos)
    #   @param [String] topic topic you subscribe on
    #   @param [Fixnum] qos QoS level
    # @overload subscribe(topics,subscribeSentHandler)
    #   @param [Hash{String => Fixnum}] topics topics you subscribe on
    #   @yield handler called after SUBSCRIBE packet sent with packetid
    # @overload subscribe(topic,qos,subscribeSentHandler)
    #   @param [String] topic topic you subscribe on
    #   @param [Fixnum] qos QoS level
    #   @yield handler called after SUBSCRIBE packet sent with packetid
    # @return [self]
    def subscribe(param_1=nil,param_2=nil)
      if param_1.class == Hash && !block_given? && param_2 == nil
        @j_del.java_method(:subscribe, [Java::JavaUtil::Map.java_class]).call(Hash[param_1.map { |k,v| [k,::Vertx::Util::Utils.to_integer(v)] }])
        return self
      elsif param_1.class == String && param_2.class == Fixnum && !block_given?
        @j_del.java_method(:subscribe, [Java::java.lang.String.java_class,Java::int.java_class]).call(param_1,param_2)
        return self
      elsif param_1.class == Hash && block_given? && param_2 == nil
        @j_del.java_method(:subscribe, [Java::JavaUtil::Map.java_class,Java::IoVertxCore::Handler.java_class]).call(Hash[param_1.map { |k,v| [k,::Vertx::Util::Utils.to_integer(v)] }],(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
        return self
      elsif param_1.class == String && param_2.class == Fixnum && block_given?
        @j_del.java_method(:subscribe, [Java::java.lang.String.java_class,Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling subscribe(#{param_1},#{param_2})"
    end
    #  Sets handler which will be called after UNSUBACK packet receiving
    # @yield handler to call with the packetid
    # @return [self]
    def unsubscribe_completion_handler
      if block_given?
        @j_del.java_method(:unsubscribeCompletionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling unsubscribe_completion_handler()"
    end
    #  Unsubscribe from receiving messages on given topic
    # @param [String] topic Topic you want to unsubscribe from
    # @yield handler called after UNSUBSCRIBE packet sent
    # @return [self]
    def unsubscribe(topic=nil)
      if topic.class == String && !block_given?
        @j_del.java_method(:unsubscribe, [Java::java.lang.String.java_class]).call(topic)
        return self
      elsif topic.class == String && block_given?
        @j_del.java_method(:unsubscribe, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(topic,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling unsubscribe(#{topic})"
    end
    #  Sets handler which will be called after PINGRESP packet receiving
    # @yield handler to call
    # @return [self]
    def ping_response_handler
      if block_given?
        @j_del.java_method(:pingResponseHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling ping_response_handler()"
    end
    #  Set an exception handler for the client, that will be called when an error happens
    #  in internal netty structures.
    # 
    #  <code>io.netty.handler.codec.DecoderException</code> can be one of the cause
    # @yield the exception handler
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    #  Set a handler that will be called when the connection with server is closed
    # @yield handler to call
    # @return [self]
    def close_handler
      if block_given?
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling close_handler()"
    end
    #  This method is needed by the client in order to avoid server closes the
    #  connection due to the keep alive timeout if client has no messages to send
    # @return [self]
    def ping
      if !block_given?
        @j_del.java_method(:ping, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling ping()"
    end
    # @return [String] the client identifier
    def client_id
      if !block_given?
        return @j_del.java_method(:clientId, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling client_id()"
    end
    # @return [true,false] if the connection between client and remote server is established/open
    def connected?
      if !block_given?
        return @j_del.java_method(:isConnected, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling connected?()"
    end
  end
end
