require 'vertx/vertx'
require 'vertx/util/utils.rb'
# Generated from io.vertx.kafka.admin.AdminUtils
module VertxKafkaClient
  #  Provides a wrapper around important methods in Kafka's AdminUtils, namely
  class AdminUtils
    # @private
    # @param j_del [::VertxKafkaClient::AdminUtils] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxKafkaClient::AdminUtils] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AdminUtils
    end
    def @@j_api_type.wrap(obj)
      AdminUtils.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxKafkaAdmin::AdminUtils.java_class
    end
    #  Create a new AdminUtils instance
    # @overload create(vertx,zookeeperHosts)
    #   @param [::Vertx::Vertx] vertx Vert.x instance to use
    #   @param [String] zookeeperHosts comma-separated list of Zookeeper server, e.g. localhost:2181,localhost:2182
    # @overload create(vertx,zookeeperHosts,autoClose)
    #   @param [::Vertx::Vertx] vertx Vert.x instance to use
    #   @param [String] zookeeperHosts comma-separated list of Zookeeper server, e.g. localhost:2181,localhost:2182
    #   @param [true,false] autoClose If set to true, the client will auto-close the connection after a command
    # @overload create(vertx,zookeeperHosts,connectionTimeoutMs,isSecure,autoClose)
    #   @param [::Vertx::Vertx] vertx Vert.x instance to use
    #   @param [String] zookeeperHosts comma-separated list of Zookeeper server, e.g. localhost:2181,localhost:2182
    #   @param [Fixnum] connectionTimeoutMs Maximum time in ms to wait for the client to connect to Zookeeper
    #   @param [true,false] isSecure If set to true, ZkUtils will perform security checks, i.e. ACL checks
    #   @param [true,false] autoClose If set to true, the client will auto-close the connection after a command
    # @return [::VertxKafkaClient::AdminUtils] an instance of the AdminUtilWrapper
    def self.create(param_1=nil,param_2=nil,param_3=nil,param_4=nil,param_5=nil)
      if param_1.class.method_defined?(:j_del) && param_2.class == String && !block_given? && param_3 == nil && param_4 == nil && param_5 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaAdmin::AdminUtils.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(param_1.j_del,param_2),::VertxKafkaClient::AdminUtils)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && (param_3.class == TrueClass || param_3.class == FalseClass) && !block_given? && param_4 == nil && param_5 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaAdmin::AdminUtils.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::boolean.java_class]).call(param_1.j_del,param_2,param_3),::VertxKafkaClient::AdminUtils)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && param_3.class == Fixnum && (param_4.class == TrueClass || param_4.class == FalseClass) && (param_5.class == TrueClass || param_5.class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaAdmin::AdminUtils.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::int.java_class,Java::boolean.java_class,Java::boolean.java_class]).call(param_1.j_del,param_2,param_3,param_4,param_5),::VertxKafkaClient::AdminUtils)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{param_1},#{param_2},#{param_3},#{param_4},#{param_5})"
    end
    #  Creates a new Kafka topic on all Brokers managed by the given Zookeeper instance(s). In contrast
    #  to @see {::VertxKafkaClient::AdminUtils#create_topic}, one can pass in additional configuration
    #  parameters as a map (String -> String).
    # @param [String] topicName Name of the to-be-created topic
    # @param [Fixnum] partitionCount Number of partitions
    # @param [Fixnum] replicationFactor Number of replicates. Must be lower or equal to the number of available Brokers
    # @param [Hash{String => String}] topicConfig map with additional topic configuration parameters
    # @yield vert.x callback
    # @return [void]
    def create_topic(topicName=nil,partitionCount=nil,replicationFactor=nil,topicConfig=nil)
      if topicName.class == String && partitionCount.class == Fixnum && replicationFactor.class == Fixnum && block_given? && topicConfig == nil
        return @j_del.java_method(:createTopic, [Java::java.lang.String.java_class,Java::int.java_class,Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(topicName,partitionCount,replicationFactor,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      elsif topicName.class == String && partitionCount.class == Fixnum && replicationFactor.class == Fixnum && topicConfig.class == Hash && block_given?
        return @j_del.java_method(:createTopic, [Java::java.lang.String.java_class,Java::int.java_class,Java::int.java_class,Java::JavaUtil::Map.java_class,Java::IoVertxCore::Handler.java_class]).call(topicName,partitionCount,replicationFactor,Hash[topicConfig.map { |k,v| [k,v] }],(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling create_topic(#{topicName},#{partitionCount},#{replicationFactor},#{topicConfig})"
    end
    #  Delete the Kafka topic given by the topicName.
    # @param [String] topicName Name of the topic to be deleted
    # @yield vert.x callback
    # @return [void]
    def delete_topic(topicName=nil)
      if topicName.class == String && block_given?
        return @j_del.java_method(:deleteTopic, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(topicName,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling delete_topic(#{topicName})"
    end
    #  Checks if the Kafka topic given by topicName does exist.
    # @param [String] topicName Name of the topic
    # @yield vert.x callback
    # @return [void]
    def topic_exists(topicName=nil)
      if topicName.class == String && block_given?
        return @j_del.java_method(:topicExists, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(topicName,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling topic_exists(#{topicName})"
    end
    #  Updates the configuration of the topic given by topicName. Configuration parameters
    #  are passed in as a Map (Key -> Value) of Strings.
    # @param [String] topicName topic to be configured
    # @param [Hash{String => String}] topicConfig Map with configuration items
    # @yield vert.x callback
    # @return [void]
    def change_topic_config(topicName=nil,topicConfig=nil)
      if topicName.class == String && topicConfig.class == Hash && block_given?
        return @j_del.java_method(:changeTopicConfig, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::IoVertxCore::Handler.java_class]).call(topicName,Hash[topicConfig.map { |k,v| [k,v] }],(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling change_topic_config(#{topicName},#{topicConfig})"
    end
    #  Closes the underlying connection to Zookeeper. It is required to call the method for cleanup
    #  purposes if AdminUtils was not created with autoClose set to true.
    # @yield vert.x callback
    # @return [void]
    def close
      if block_given?
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
