require 'vertx/vertx'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.jdbc.JDBCHashStrategy
module VertxAuthJdbc
  #  Determines how the hashing is computed in the implementation
  # 
  #  You can implement this to provide a different hashing strategy to the default.
  class JDBCHashStrategy
    # @private
    # @param j_del [::VertxAuthJdbc::JDBCHashStrategy] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthJdbc::JDBCHashStrategy] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == JDBCHashStrategy
    end
    def @@j_api_type.wrap(obj)
      JDBCHashStrategy.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthJdbc::JDBCHashStrategy.java_class
    end
    #  This is the current backwards compatible hashing implementation, new applications should prefer the
    #  PBKDF2 implementation, unless the tradeoff between security and CPU usage is an option.
    # @param [::Vertx::Vertx] vertx the vert.x instance
    # @return [::VertxAuthJdbc::JDBCHashStrategy] the implementation.
    def self.create_sha512(vertx=nil)
      if vertx.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthJdbc::JDBCHashStrategy.java_method(:createSHA512, [Java::IoVertxCore::Vertx.java_class]).call(vertx.j_del),::VertxAuthJdbc::JDBCHashStrategy)
      end
      raise ArgumentError, "Invalid arguments when calling create_sha512(#{vertx})"
    end
    #  Implements a Hashing Strategy as per https://www.owasp.org/index.php/Password_Storage_Cheat_Sheet (2018-01-17).
    # 
    #  New deployments should use this strategy instead of the default one (which was the previous OWASP recommendation).
    # 
    #  The work factor can be updated by using the nonces json array.
    # @param [::Vertx::Vertx] vertx the vert.x instance
    # @return [::VertxAuthJdbc::JDBCHashStrategy] the implementation.
    def self.create_pbkdf2(vertx=nil)
      if vertx.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthJdbc::JDBCHashStrategy.java_method(:createPBKDF2, [Java::IoVertxCore::Vertx.java_class]).call(vertx.j_del),::VertxAuthJdbc::JDBCHashStrategy)
      end
      raise ArgumentError, "Invalid arguments when calling create_pbkdf2(#{vertx})"
    end
    #  Compute a random salt.
    # @return [String] a non null salt value
    def generate_salt
      if !block_given?
        return @j_del.java_method(:generateSalt, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling generate_salt()"
    end
    #  Compute the hashed password given the unhashed password and the salt
    # @param [String] password the unhashed password
    # @param [String] salt the salt
    # @param [Fixnum] version the nonce version to use
    # @return [String] the hashed password
    def compute_hash(password=nil,salt=nil,version=nil)
      if password.class == String && salt.class == String && version.class == Fixnum && !block_given?
        return @j_del.java_method(:computeHash, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::int.java_class]).call(password,salt,version)
      end
      raise ArgumentError, "Invalid arguments when calling compute_hash(#{password},#{salt},#{version})"
    end
    #  Retrieve the hashed password from the result of the authentication query
    # @param [Array<String,Object>] row the row
    # @return [String] the hashed password
    def get_hashed_stored_pwd(row=nil)
      if row.class == Array && !block_given?
        return @j_del.java_method(:getHashedStoredPwd, [Java::IoVertxCoreJson::JsonArray.java_class]).call(::Vertx::Util::Utils.to_json_array(row))
      end
      raise ArgumentError, "Invalid arguments when calling get_hashed_stored_pwd(#{row})"
    end
    #  Retrieve the salt from the result of the authentication query
    # @param [Array<String,Object>] row the row
    # @return [String] the salt
    def get_salt(row=nil)
      if row.class == Array && !block_given?
        return @j_del.java_method(:getSalt, [Java::IoVertxCoreJson::JsonArray.java_class]).call(::Vertx::Util::Utils.to_json_array(row))
      end
      raise ArgumentError, "Invalid arguments when calling get_salt(#{row})"
    end
    #  Sets a ordered list of nonces where each position corresponds to a version.
    # 
    #  The nonces are supposed not to be stored in the underlying jdbc storage but to
    #  be provided as a application configuration. The idea is to add one extra variable
    #  to the hash function in order to make breaking the passwords using rainbow tables
    #  or precomputed hashes harder. Leaving the attacker only with the brute force
    #  approach.
    # 
    #  Nonces are dependent on the implementation. E.g.: for the SHA512 they are extra salt
    #  used during the hashing, for the PBKDF2 they map the number of iterations the algorithm
    #  should take
    # @param [Array<String,Object>] nonces a json array.
    # @return [void]
    def set_nonces(nonces=nil)
      if nonces.class == Array && !block_given?
        return @j_del.java_method(:setNonces, [Java::IoVertxCoreJson::JsonArray.java_class]).call(::Vertx::Util::Utils.to_json_array(nonces))
      end
      raise ArgumentError, "Invalid arguments when calling set_nonces(#{nonces})"
    end
    #  Time constant string comparision to avoid timming attacks.
    # @param [String] hasha hash a to compare
    # @param [String] hashb hash b to compare
    # @return [true,false] true if equal
    def self.equal?(hasha=nil,hashb=nil)
      if hasha.class == String && hashb.class == String && !block_given?
        return Java::IoVertxExtAuthJdbc::JDBCHashStrategy.java_method(:isEqual, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(hasha,hashb)
      end
      raise ArgumentError, "Invalid arguments when calling equal?(#{hasha},#{hashb})"
    end
  end
end
