/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.Context;
import io.vertx.core.eventbus.impl.HandlerRegistration;
import io.vertx.core.spi.metrics.EventBusMetrics;

public class HandlerHolder<T> {
    private final EventBusMetrics metrics;
    private final Context context;
    private final HandlerRegistration<T> handler;
    private final boolean replyHandler;
    private final boolean localOnly;
    private boolean removed;

    public HandlerHolder(EventBusMetrics metrics, HandlerRegistration<T> handler, boolean replyHandler, boolean localOnly, Context context) {
        this.metrics = metrics;
        this.context = context;
        this.handler = handler;
        this.replyHandler = replyHandler;
        this.localOnly = localOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRemoved() {
        boolean unregistered = false;
        HandlerHolder handlerHolder = this;
        synchronized (handlerHolder) {
            if (!this.removed) {
                this.removed = true;
                unregistered = true;
            }
        }
        if (this.metrics != null && unregistered) {
            this.metrics.handlerUnregistered(this.handler.getMetric());
        }
        return unregistered;
    }

    public synchronized boolean isRemoved() {
        return this.removed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandlerHolder that = (HandlerHolder)o;
        return !(this.handler != null ? !this.handler.equals(that.handler) : that.handler != null);
    }

    public int hashCode() {
        return this.handler != null ? this.handler.hashCode() : 0;
    }

    public Context getContext() {
        return this.context;
    }

    public HandlerRegistration<T> getHandler() {
        return this.handler;
    }

    public boolean isReplyHandler() {
        return this.replyHandler;
    }

    public boolean isLocalOnly() {
        return this.localOnly;
    }
}

