/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra.impl;

import com.datastax.driver.mapping.MappingManager;
import io.vertx.cassandra.Mapper;
import io.vertx.cassandra.impl.MappingManagerImpl;
import io.vertx.cassandra.impl.Util;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import java.util.List;
import java.util.Objects;

public class MapperImpl<T>
implements Mapper<T> {
    private final MappingManagerImpl mappingManager;
    private final Class<T> mappedClass;
    private com.datastax.driver.mapping.Mapper<T> mapper;

    MapperImpl(MappingManagerImpl mappingManager, Class<T> mappedClass) {
        Objects.requireNonNull(mappingManager, "mappingManager");
        Objects.requireNonNull(mappedClass, "mappedClass");
        this.mappingManager = mappingManager;
        this.mappedClass = mappedClass;
    }

    @Override
    public void save(T entity, Handler<AsyncResult<Void>> handler) {
        ContextInternal context = this.mappingManager.client.vertx.getOrCreateContext();
        this.getMapper(context, (Handler<AsyncResult<com.datastax.driver.mapping.Mapper>>)((Handler)ar -> {
            if (ar.succeeded()) {
                Util.handleOnContext(this.mapper.saveAsync(entity), (Context)context, handler);
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }

    @Override
    public void delete(List<Object> primaryKey, Handler<AsyncResult<Void>> handler) {
        ContextInternal context = this.mappingManager.client.vertx.getOrCreateContext();
        this.getMapper(context, (Handler<AsyncResult<com.datastax.driver.mapping.Mapper>>)((Handler)ar -> {
            if (ar.succeeded()) {
                Util.handleOnContext(this.mapper.deleteAsync(primaryKey.toArray()), (Context)context, handler);
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }

    @Override
    public void get(List<Object> primaryKey, Handler<AsyncResult<T>> handler) {
        ContextInternal context = this.mappingManager.client.vertx.getOrCreateContext();
        this.getMapper(context, (Handler<AsyncResult<com.datastax.driver.mapping.Mapper>>)((Handler)ar -> {
            if (ar.succeeded()) {
                Util.handleOnContext(this.mapper.getAsync(primaryKey.toArray()), (Context)context, handler);
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }

    synchronized void getMapper(ContextInternal context, Handler<AsyncResult<com.datastax.driver.mapping.Mapper>> handler) {
        if (this.mapper != null) {
            handler.handle((Object)Future.succeededFuture(this.mapper));
        } else {
            this.mappingManager.getMappingManager(context, (Handler<AsyncResult<MappingManager>>)((Handler)ar -> {
                if (ar.succeeded()) {
                    com.datastax.driver.mapping.Mapper<T> m;
                    try {
                        MapperImpl mapperImpl = this;
                        synchronized (mapperImpl) {
                            if (this.mapper == null) {
                                this.mapper = ((MappingManager)ar.result()).mapper(this.mappedClass);
                            }
                            m = this.mapper;
                        }
                    }
                    catch (Exception e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                    handler.handle((Object)Future.succeededFuture(m));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }));
        }
    }
}

