/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.tty;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ReadBuffer
implements Consumer<int[]> {
    private final Queue<int[]> queue = new ArrayDeque<int[]>(10);
    private final Executor executor;
    private volatile Consumer<int[]> readHandler;

    public ReadBuffer(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void accept(int[] data) {
        this.queue.add(data);
        while (this.readHandler != null && this.queue.size() > 0) {
            data = this.queue.poll();
            if (data == null) continue;
            this.readHandler.accept(data);
        }
    }

    public Consumer<int[]> getReadHandler() {
        return this.readHandler;
    }

    public void setReadHandler(Consumer<int[]> readHandler) {
        if (readHandler != null) {
            if (this.readHandler != null) {
                this.readHandler = readHandler;
            } else {
                this.readHandler = readHandler;
                this.drainQueue();
            }
        } else {
            this.readHandler = null;
        }
    }

    private void drainQueue() {
        if (this.queue.size() > 0 && this.readHandler != null) {
            this.executor.execute(() -> {
                int[] data;
                if (this.readHandler != null && (data = this.queue.poll()) != null) {
                    this.readHandler.accept(data);
                    this.drainQueue();
                }
            });
        }
    }
}

