/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.pty;

import io.termd.core.io.BinaryDecoder;
import io.termd.core.pty.Status;
import io.termd.core.util.Helper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtyMaster
extends Thread {
    Logger log = LoggerFactory.getLogger(PtyMaster.class);
    private int bufferSize = 512;
    private final String line;
    private BiConsumer<Status, Status> changeHandler;
    private final Consumer<Void> doneHandler;
    private final Consumer<int[]> stdout;
    private Status status;
    private Process process;
    private boolean interrupted;

    public PtyMaster(String line, Consumer<int[]> stdout, Consumer<Void> doneHandler) {
        this.line = line;
        this.doneHandler = doneHandler;
        this.stdout = stdout;
        this.status = Status.NEW;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize < 2) {
            throw new IllegalStateException("Buffer size is too small");
        }
        this.bufferSize = bufferSize;
    }

    public BiConsumer<Status, Status> getChangeHandler() {
        return this.changeHandler;
    }

    public void setChangeHandler(BiConsumer<Status, Status> changeHandler) {
        this.changeHandler = changeHandler;
    }

    public Process getProcess() {
        return this.process;
    }

    public Status getStatus() {
        return this.status;
    }

    public void interruptProcess() {
        if (!this.interrupted) {
            this.interrupted = true;
            this.process.destroy();
        }
    }

    @Override
    public void run() {
        block9: {
            ProcessBuilder builder = new ProcessBuilder(this.line.split("\\s+"));
            try {
                this.process = builder.start();
                this.setStatus(Status.RUNNING);
                Pipe stdout = new Pipe(this.process.getInputStream());
                Pipe stderr = new Pipe(this.process.getErrorStream());
                stdout.start();
                stderr.start();
                try {
                    this.log.debug("Waiting stdout to complete...");
                    stdout.join();
                    this.log.debug("Stdout completed.");
                }
                catch (InterruptedException e) {
                    this.setStatus(Status.INTERRUPTED);
                    Thread.currentThread().interrupt();
                }
                try {
                    this.log.debug("Waiting stderr to complete...");
                    stderr.join();
                    this.log.debug("Stderr completed.");
                }
                catch (InterruptedException e) {
                    this.setStatus(Status.INTERRUPTED);
                    Thread.currentThread().interrupt();
                }
                try {
                    int exitValue = this.process.waitFor();
                    if (exitValue == 0) {
                        this.setStatus(Status.COMPLETED);
                        break block9;
                    }
                    this.setStatus(Status.FAILED);
                }
                catch (InterruptedException e) {
                    this.setStatus(Status.INTERRUPTED);
                    Thread.currentThread().interrupt();
                }
            }
            catch (IOException e) {
                this.stdout.accept(Helper.toCodePoints(e.getMessage() + "\r\n"));
            }
        }
        this.doneHandler.accept(null);
    }

    private void setStatus(Status next) {
        Status prev = this.status;
        this.status = next;
        if (this.changeHandler != null) {
            this.changeHandler.accept(prev, next);
        }
    }

    static /* synthetic */ int access$000(PtyMaster x0) {
        return x0.bufferSize;
    }

    static /* synthetic */ Consumer access$100(PtyMaster x0) {
        return x0.stdout;
    }

    private class Pipe
    extends Thread {
        private final Charset charset = StandardCharsets.UTF_8;
        private final InputStream in;
        private final BinaryDecoder decoder = new BinaryDecoder(PtyMaster.access$000(PtyMaster.this), this.charset, PtyMaster.access$100(PtyMaster.this)::accept);

        public Pipe(InputStream in) {
            this.in = in;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[512];
            try {
                int l;
                while ((l = this.in.read(buffer)) != -1) {
                    this.decoder.write(buffer, 0, l);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

