/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.http.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.termd.core.http.netty.HttpRequestHandler;
import io.termd.core.http.netty.TtyWebSocketFrameHandler;
import io.termd.core.tty.TtyConnection;
import java.util.function.Consumer;

public class TtyServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final ChannelGroup group;
    private final Consumer<TtyConnection> handler;

    public TtyServerInitializer(ChannelGroup group, Consumer<TtyConnection> handler) {
        this.group = group;
        this.handler = handler;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        pipeline.addLast(new ChannelHandler[]{new HttpRequestHandler("/ws")});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/ws")});
        pipeline.addLast(new ChannelHandler[]{new TtyWebSocketFrameHandler(this.group, this.handler)});
    }
}

