/*
 * Decompiled with CFR 0.152.
 */
package examples.telnet;

import io.termd.core.telnet.Option;
import io.termd.core.telnet.TelnetConnection;
import io.termd.core.telnet.TelnetHandler;
import io.termd.core.telnet.netty.NettyTelnetBootstrap;
import java.util.concurrent.TimeUnit;

public class TelnetExample {
    public static synchronized void main(String[] args) throws Exception {
        NettyTelnetBootstrap bootstrap = new NettyTelnetBootstrap().setHost("localhost").setPort(4000);
        bootstrap.start(() -> new TelnetHandler(){

            @Override
            protected void onOpen(TelnetConnection conn) {
                System.out.println("Client connected");
                conn.writeDoOption(Option.TERMINAL_TYPE);
                conn.writeDoOption(Option.NAWS);
            }

            @Override
            protected void onNAWS(boolean naws) {
                if (naws) {
                    System.out.println("Client will send window size changes");
                } else {
                    System.out.println("Client won't send window size changes");
                }
            }

            @Override
            protected void onData(byte[] data) {
                System.out.println("Client sent " + new String(data));
            }

            @Override
            protected void onSize(int width, int height) {
                System.out.println("Window resized " + width + height);
            }

            @Override
            protected void onTerminalType(String terminalType) {
                System.out.println("Client declared its terminal as " + terminalType);
            }

            @Override
            protected void onClose() {
                System.out.println("Disconnected");
            }
        }).get(10L, TimeUnit.SECONDS);
        System.out.println("Telnet server started on localhost:4000");
        TelnetExample.class.wait();
    }
}

