/*
 * Decompiled with CFR 0.152.
 */
package examples.plasma;

import io.termd.core.tty.TtyConnection;
import io.termd.core.tty.TtyEvent;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class Plasma
implements Consumer<TtyConnection> {
    private volatile boolean interrupted = false;

    @Override
    public void accept(TtyConnection conn) {
        conn.setEventHandler((event, key) -> {
            if (event == TtyEvent.INTR) {
                this.interrupted = true;
            }
        });
        if (conn.size() != null) {
            this.run(conn);
        } else {
            conn.setSizeHandler(size -> this.run(conn));
        }
    }

    public void run(TtyConnection conn) {
        int width = conn.size().x();
        int height = conn.size().y();
        long t = System.currentTimeMillis();
        double a = 12.8 / (double)width;
        double b = 0.0015;
        double c = 0.07;
        double d = 10.24 / (double)width;
        double e = 0.002;
        double f = 0.01;
        double g = 2.56 / (double)height;
        double h = 0.003;
        double i = 0.01;
        double j = 3.2 / (double)height;
        double k = 0.001;
        double l = 0.06;
        double[][] abc = new double[width][height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                abc[x][y] = 32.0 * (Math.cos(a * (double)x + b * (double)t + c) + Math.cos(d * (double)x + e * (double)t + f) + Math.cos(g * (double)y + h * (double)t + i) + Math.cos(j * (double)y + k * (double)t + l) + 4.0);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int y = 0; y < height; ++y) {
            sb.append("\u001b[").append(y + 1).append(";1H");
            for (int x = 0; x < width; ++x) {
                double val = abc[x][y];
                if (val < 51.0) {
                    sb.append('\u2588');
                    continue;
                }
                if (val < 102.0) {
                    sb.append('\u2593');
                    continue;
                }
                if (val < 153.0) {
                    sb.append('\u2592');
                    continue;
                }
                if (val < 204.0) {
                    sb.append('\u2591');
                    continue;
                }
                sb.append(' ');
            }
        }
        conn.write(sb.toString());
        if (!this.interrupted) {
            conn.schedule(() -> this.run(conn), 50L, TimeUnit.MILLISECONDS);
        } else {
            conn.close();
        }
    }
}

