/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.filter;

import io.swagger.v3.core.filter.OpenAPISpecFilter;
import io.swagger.v3.core.model.ApiDescription;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.RefUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SpecFilter {
    public OpenAPI filter(OpenAPI openAPI, OpenAPISpecFilter filter, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        OpenAPI filteredOpenAPI = this.filterOpenAPI(filter, openAPI, params, cookies, headers);
        if (filteredOpenAPI == null) {
            return filteredOpenAPI;
        }
        OpenAPI clone = new OpenAPI();
        clone.info(filteredOpenAPI.getInfo());
        clone.openapi(filteredOpenAPI.getOpenapi());
        clone.setExtensions(openAPI.getExtensions());
        clone.setExternalDocs(openAPI.getExternalDocs());
        clone.setSecurity(openAPI.getSecurity());
        clone.setServers(openAPI.getServers());
        clone.tags((List)(filteredOpenAPI.getTags() == null ? null : new ArrayList(openAPI.getTags())));
        HashSet allowedTags = new HashSet();
        HashSet filteredTags = new HashSet();
        Paths clonedPaths = new Paths();
        for (String resourcePath : openAPI.getPaths().keySet()) {
            PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)resourcePath);
            PathItem filteredPathItem = this.filterPathItem(filter, pathItem, resourcePath, params, cookies, headers);
            if (filteredPathItem == null) continue;
            PathItem clonedPathItem = new PathItem();
            clonedPathItem.set$ref(filteredPathItem.get$ref());
            clonedPathItem.setDescription(filteredPathItem.getDescription());
            clonedPathItem.setSummary(filteredPathItem.getSummary());
            clonedPathItem.setExtensions(filteredPathItem.getExtensions());
            clonedPathItem.setParameters(filteredPathItem.getParameters());
            clonedPathItem.setServers(filteredPathItem.getServers());
            Map ops = filteredPathItem.readOperationsMap();
            for (PathItem.HttpMethod key : ops.keySet()) {
                Operation op = (Operation)ops.get(key);
                ArrayList opTagsBeforeFilter = null;
                opTagsBeforeFilter = op.getTags() != null ? new ArrayList(op.getTags()) : new ArrayList();
                op = this.filterOperation(filter, op, resourcePath, key.toString(), params, cookies, headers);
                clonedPathItem.operation(key, op);
                if (op == null) {
                    filteredTags.addAll(opTagsBeforeFilter);
                    continue;
                }
                if (op.getTags() != null) {
                    opTagsBeforeFilter.removeAll(op.getTags());
                    allowedTags.addAll(op.getTags());
                }
                filteredTags.addAll(opTagsBeforeFilter);
            }
            if (clonedPathItem.readOperations().isEmpty()) continue;
            clonedPaths.addPathItem(resourcePath, clonedPathItem);
        }
        clone.paths(clonedPaths);
        filteredTags.removeAll(allowedTags);
        List tags = clone.getTags();
        if (tags != null && !filteredTags.isEmpty()) {
            Iterator it = tags.iterator();
            while (it.hasNext()) {
                if (!filteredTags.contains(((Tag)it.next()).getName())) continue;
                it.remove();
            }
            if (clone.getTags().isEmpty()) {
                clone.setTags(null);
            }
        }
        if (filteredOpenAPI.getComponents() != null) {
            clone.components(new Components());
            clone.getComponents().setSchemas(this.filterComponentsSchema(filter, filteredOpenAPI.getComponents().getSchemas(), params, cookies, headers));
            clone.getComponents().setSecuritySchemes(filteredOpenAPI.getComponents().getSecuritySchemes());
            clone.getComponents().setCallbacks(filteredOpenAPI.getComponents().getCallbacks());
            clone.getComponents().setExamples(filteredOpenAPI.getComponents().getExamples());
            clone.getComponents().setExtensions(filteredOpenAPI.getComponents().getExtensions());
            clone.getComponents().setHeaders(filteredOpenAPI.getComponents().getHeaders());
            clone.getComponents().setLinks(filteredOpenAPI.getComponents().getLinks());
            clone.getComponents().setParameters(filteredOpenAPI.getComponents().getParameters());
            clone.getComponents().setRequestBodies(filteredOpenAPI.getComponents().getRequestBodies());
            clone.getComponents().setResponses(filteredOpenAPI.getComponents().getResponses());
        }
        if (filter.isRemovingUnreferencedDefinitions()) {
            clone = this.removeBrokenReferenceDefinitions(clone);
        }
        return clone;
    }

    protected OpenAPI filterOpenAPI(OpenAPISpecFilter filter, OpenAPI openAPI, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        Optional<OpenAPI> filteredOpenAPI;
        if (openAPI != null && (filteredOpenAPI = filter.filterOpenAPI(openAPI, params, cookies, headers)).isPresent()) {
            return filteredOpenAPI.get();
        }
        return null;
    }

    protected Operation filterOperation(OpenAPISpecFilter filter, Operation operation, String resourcePath, String key, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        ApiDescription description;
        Optional<Operation> filteredOperation;
        if (operation != null && (filteredOperation = filter.filterOperation(operation, description = new ApiDescription(resourcePath, key), params, cookies, headers)).isPresent()) {
            ApiResponses responses;
            ArrayList<Parameter> filteredParameters = new ArrayList<Parameter>();
            Operation filteredOperationGet = filteredOperation.get();
            List parameters = filteredOperationGet.getParameters();
            if (parameters != null) {
                for (Parameter parameter : parameters) {
                    Parameter filteredParameter = this.filterParameter(filter, operation, parameter, resourcePath, key, params, cookies, headers);
                    if (filteredParameter == null) continue;
                    filteredParameters.add(filteredParameter);
                }
            }
            filteredOperationGet.setParameters(filteredParameters);
            RequestBody requestBody = filteredOperation.get().getRequestBody();
            if (requestBody != null) {
                RequestBody filteredRequestBody = this.filterRequestBody(filter, operation, requestBody, resourcePath, key, params, cookies, headers);
                filteredOperationGet.setRequestBody(filteredRequestBody);
            }
            ApiResponses clonedResponses = responses = filteredOperation.get().getResponses();
            if (responses != null) {
                responses.forEach((responseKey, response) -> {
                    ApiResponse filteredResponse = this.filterResponse(filter, operation, (ApiResponse)response, resourcePath, key, params, cookies, headers);
                    if (filteredResponse != null) {
                        clonedResponses.addApiResponse(responseKey, filteredResponse);
                    }
                });
                filteredOperationGet.setResponses(clonedResponses);
            }
            return filteredOperationGet;
        }
        return null;
    }

    protected PathItem filterPathItem(OpenAPISpecFilter filter, PathItem pathItem, String resourcePath, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        ApiDescription description = new ApiDescription(resourcePath, null);
        Optional<PathItem> filteredPathItem = filter.filterPathItem(pathItem, description, params, cookies, headers);
        if (filteredPathItem.isPresent()) {
            return filteredPathItem.get();
        }
        return null;
    }

    protected Parameter filterParameter(OpenAPISpecFilter filter, Operation operation, Parameter parameter, String resourcePath, String key, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        ApiDescription description;
        Optional<Parameter> filteredParameter;
        if (parameter != null && (filteredParameter = filter.filterParameter(parameter, operation, description = new ApiDescription(resourcePath, key), params, cookies, headers)).isPresent()) {
            return filteredParameter.get();
        }
        return null;
    }

    protected RequestBody filterRequestBody(OpenAPISpecFilter filter, Operation operation, RequestBody requestBody, String resourcePath, String key, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        ApiDescription description;
        Optional<RequestBody> filteredRequestBody;
        if (requestBody != null && (filteredRequestBody = filter.filterRequestBody(requestBody, operation, description = new ApiDescription(resourcePath, key), params, cookies, headers)).isPresent()) {
            return filteredRequestBody.get();
        }
        return null;
    }

    protected ApiResponse filterResponse(OpenAPISpecFilter filter, Operation operation, ApiResponse response, String resourcePath, String key, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        ApiDescription description;
        Optional<ApiResponse> filteredResponse;
        if (response != null && (filteredResponse = filter.filterResponse(response, operation, description = new ApiDescription(resourcePath, key), params, cookies, headers)).isPresent()) {
            return filteredResponse.get();
        }
        return null;
    }

    protected Map<String, Schema> filterComponentsSchema(OpenAPISpecFilter filter, Map<String, Schema> schemasMap, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        if (schemasMap == null) {
            return null;
        }
        LinkedHashMap<String, Schema> clonedComponentsSchema = new LinkedHashMap<String, Schema>();
        for (String key : schemasMap.keySet()) {
            Schema definition = schemasMap.get(key);
            Optional<Schema> filteredDefinition = filter.filterSchema(definition, params, cookies, headers);
            if (!filteredDefinition.isPresent()) continue;
            LinkedHashMap<String, Schema> clonedProperties = new LinkedHashMap<String, Schema>();
            if (filteredDefinition.get().getProperties() != null) {
                for (Object propName : filteredDefinition.get().getProperties().keySet()) {
                    Optional<Schema> filteredProperty;
                    Schema property = (Schema)filteredDefinition.get().getProperties().get((String)propName);
                    if (property == null || !(filteredProperty = filter.filterSchemaProperty(property, definition, (String)propName, params, cookies, headers)).isPresent()) continue;
                    clonedProperties.put((String)propName, filteredProperty.get());
                }
            }
            try {
                Schema clonedModel = (Schema)Json.mapper().readValue(Json.pretty(definition), Schema.class);
                if (clonedModel.getProperties() != null) {
                    clonedModel.getProperties().clear();
                }
                if (!clonedProperties.isEmpty()) {
                    clonedModel.setProperties(clonedProperties);
                }
                clonedComponentsSchema.put(key, clonedModel);
            }
            catch (IOException e) {}
        }
        return clonedComponentsSchema;
    }

    private void addSchemaRef(Schema schema, Set<String> referencedDefinitions) {
        if (schema == null) {
            return;
        }
        if (!StringUtils.isBlank((CharSequence)schema.get$ref())) {
            referencedDefinitions.add(schema.get$ref());
            return;
        }
        if (schema.getProperties() != null) {
            for (Object propName : schema.getProperties().keySet()) {
                Schema property = (Schema)schema.getProperties().get((String)propName);
                this.addSchemaRef(property, referencedDefinitions);
            }
        }
        if (schema.getAdditionalProperties() != null && schema.getAdditionalProperties() instanceof Schema) {
            this.addSchemaRef((Schema)schema.getAdditionalProperties(), referencedDefinitions);
        }
        if (schema instanceof ArraySchema && ((ArraySchema)schema).getItems() != null) {
            this.addSchemaRef(((ArraySchema)schema).getItems(), referencedDefinitions);
        } else if (schema instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)schema;
            if (composedSchema.getAllOf() != null) {
                for (Schema ref : composedSchema.getAllOf()) {
                    this.addSchemaRef(ref, referencedDefinitions);
                }
            }
            if (composedSchema.getAnyOf() != null) {
                for (Schema ref : composedSchema.getAnyOf()) {
                    this.addSchemaRef(ref, referencedDefinitions);
                }
            }
            if (composedSchema.getOneOf() != null) {
                for (Schema ref : composedSchema.getOneOf()) {
                    this.addSchemaRef(ref, referencedDefinitions);
                }
            }
        }
    }

    private void addContentSchemaRef(Content content, Set<String> referencedDefinitions) {
        if (content != null) {
            for (String keyBodyContent : content.keySet()) {
                MediaType mediaType = (MediaType)content.get((Object)keyBodyContent);
                this.addSchemaRef(mediaType.getSchema(), referencedDefinitions);
            }
        }
    }

    private void addPathItemSchemaRef(PathItem pathItem, Set<String> referencedDefinitions) {
        if (pathItem.getParameters() != null) {
            for (Parameter parameter : pathItem.getParameters()) {
                this.addSchemaRef(parameter.getSchema(), referencedDefinitions);
                this.addContentSchemaRef(parameter.getContent(), referencedDefinitions);
            }
        }
        Map ops = pathItem.readOperationsMap();
        for (PathItem.HttpMethod key : ops.keySet()) {
            Operation op = (Operation)ops.get(key);
            if (op.getRequestBody() != null) {
                this.addContentSchemaRef(op.getRequestBody().getContent(), referencedDefinitions);
            }
            if (op.getResponses() != null) {
                for (String keyResponses : op.getResponses().keySet()) {
                    ApiResponse response = (ApiResponse)op.getResponses().get((Object)keyResponses);
                    if (response.getHeaders() != null) {
                        for (String keyHeaders : response.getHeaders().keySet()) {
                            Header header = (Header)response.getHeaders().get(keyHeaders);
                            this.addSchemaRef(header.getSchema(), referencedDefinitions);
                            this.addContentSchemaRef(header.getContent(), referencedDefinitions);
                        }
                    }
                    this.addContentSchemaRef(response.getContent(), referencedDefinitions);
                }
            }
            if (op.getParameters() != null) {
                for (Parameter parameter : op.getParameters()) {
                    this.addSchemaRef(parameter.getSchema(), referencedDefinitions);
                    this.addContentSchemaRef(parameter.getContent(), referencedDefinitions);
                }
            }
            if (op.getCallbacks() == null) continue;
            for (String keyCallback : op.getCallbacks().keySet()) {
                Callback callback = (Callback)op.getCallbacks().get(keyCallback);
                for (String keyCallbackPathItem : callback.keySet()) {
                    PathItem callbackPathItem = (PathItem)callback.get((Object)keyCallbackPathItem);
                    this.addPathItemSchemaRef(callbackPathItem, referencedDefinitions);
                }
            }
        }
    }

    protected OpenAPI removeBrokenReferenceDefinitions(OpenAPI openApi) {
        if (openApi == null || openApi.getComponents() == null || openApi.getComponents().getSchemas() == null) {
            return openApi;
        }
        TreeSet<String> referencedDefinitions = new TreeSet<String>();
        if (openApi.getPaths() != null) {
            for (String resourcePath : openApi.getPaths().keySet()) {
                PathItem pathItem = (PathItem)openApi.getPaths().get((Object)resourcePath);
                this.addPathItemSchemaRef(pathItem, referencedDefinitions);
            }
        }
        TreeSet<String> nestedReferencedDefinitions = new TreeSet<String>();
        for (String ref : referencedDefinitions) {
            this.locateReferencedDefinitions(ref, nestedReferencedDefinitions, openApi);
        }
        referencedDefinitions.addAll(nestedReferencedDefinitions);
        openApi.getComponents().getSchemas().keySet().retainAll(referencedDefinitions.stream().map(s -> (String)RefUtils.extractSimpleName(s).getLeft()).collect(Collectors.toSet()));
        return openApi;
    }

    protected void locateReferencedDefinitions(String ref, Set<String> nestedReferencedDefinitions, OpenAPI openAPI) {
        if (!nestedReferencedDefinitions.contains(ref)) {
            nestedReferencedDefinitions.add(ref);
            String simpleName = (String)RefUtils.extractSimpleName(ref).getLeft();
            Schema model = (Schema)openAPI.getComponents().getSchemas().get(simpleName);
            if (model != null) {
                this.addSchemaRef(model, nestedReferencedDefinitions);
            }
        }
    }
}

