/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.util;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.introspect.Annotated;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.links.LinkParameter;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnnotationsUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(AnnotationsUtils.class);
    public static final String COMPONENTS_REF = "#/components/schemas/";

    public static boolean hasSchemaAnnotation(io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema == null) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)schema.type()) || !StringUtils.isBlank((CharSequence)schema.format()) || !StringUtils.isBlank((CharSequence)schema.title()) || !StringUtils.isBlank((CharSequence)schema.description()) || !StringUtils.isBlank((CharSequence)schema.ref()) || !StringUtils.isBlank((CharSequence)schema.name()) || schema.multipleOf() != 0.0 || !StringUtils.isBlank((CharSequence)schema.maximum()) || !StringUtils.isBlank((CharSequence)schema.minimum()) || schema.exclusiveMinimum() || schema.exclusiveMaximum() || schema.maxLength() != Integer.MAX_VALUE || schema.minLength() != 0 || schema.minProperties() != 0 || schema.maxProperties() != 0 || schema.requiredProperties().length != 0 || schema.required() || schema.nullable() || schema.readOnly() || schema.writeOnly() || !schema.accessMode().equals((Object)Schema.AccessMode.AUTO) || schema.deprecated() || schema.allowableValues().length != 0 || !StringUtils.isBlank((CharSequence)schema.defaultValue()) || !schema.implementation().equals(Void.class) || !StringUtils.isBlank((CharSequence)schema.example()) || !StringUtils.isBlank((CharSequence)schema.pattern()) || !schema.not().equals(Void.class) || schema.allOf().length != 0 || schema.oneOf().length != 0 || schema.anyOf().length != 0 || schema.subTypes().length != 0 || AnnotationsUtils.getExternalDocumentation(schema.externalDocs()).isPresent() || !StringUtils.isBlank((CharSequence)schema.discriminatorProperty()) || schema.discriminatorMapping().length != 0 || schema.extensions().length != 0 || schema.hidden();
    }

    public static boolean equals(Annotation thisAnnotation, Annotation thatAnnotation) {
        if (thisAnnotation == null && thatAnnotation == null) {
            return true;
        }
        if (thisAnnotation == null || thatAnnotation == null) {
            return false;
        }
        if (!thisAnnotation.annotationType().equals(thatAnnotation.annotationType())) {
            return false;
        }
        if (thisAnnotation instanceof io.swagger.v3.oas.annotations.media.Schema) {
            return AnnotationsUtils.equals((io.swagger.v3.oas.annotations.media.Schema)thisAnnotation, (io.swagger.v3.oas.annotations.media.Schema)thatAnnotation);
        }
        if (thisAnnotation instanceof io.swagger.v3.oas.annotations.media.ArraySchema) {
            return AnnotationsUtils.equals((io.swagger.v3.oas.annotations.media.ArraySchema)thisAnnotation, (io.swagger.v3.oas.annotations.media.ArraySchema)thatAnnotation);
        }
        return true;
    }

    public static boolean equals(io.swagger.v3.oas.annotations.media.ArraySchema thisArraySchema, io.swagger.v3.oas.annotations.media.ArraySchema thatArraySchema) {
        if (thisArraySchema == null && thatArraySchema == null) {
            return true;
        }
        if (thisArraySchema == null || thatArraySchema == null) {
            return false;
        }
        if (thisArraySchema.maxItems() != thatArraySchema.maxItems()) {
            return false;
        }
        if (thisArraySchema.minItems() != thatArraySchema.minItems()) {
            return false;
        }
        if (thisArraySchema.uniqueItems() != thatArraySchema.uniqueItems()) {
            return false;
        }
        if (!Arrays.equals(thisArraySchema.extensions(), thatArraySchema.extensions())) {
            return false;
        }
        return AnnotationsUtils.equals(thisArraySchema.schema(), thatArraySchema.schema());
    }

    public static boolean equals(io.swagger.v3.oas.annotations.media.Schema thisSchema, io.swagger.v3.oas.annotations.media.Schema thatSchema) {
        if (thisSchema == null && thatSchema == null) {
            return true;
        }
        if (thisSchema == null || thatSchema == null) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)thisSchema.type(), (CharSequence)thatSchema.type())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)thisSchema.format(), (CharSequence)thatSchema.format())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)thisSchema.title(), (CharSequence)thatSchema.title())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)thisSchema.description(), (CharSequence)thatSchema.description())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)thisSchema.ref(), (CharSequence)thatSchema.ref())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)thisSchema.name(), (CharSequence)thatSchema.name())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)thisSchema.defaultValue(), (CharSequence)thatSchema.defaultValue())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)thisSchema.maximum(), (CharSequence)thatSchema.maximum())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)thisSchema.minimum(), (CharSequence)thatSchema.minimum())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)thisSchema.example(), (CharSequence)thatSchema.example())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)thisSchema.pattern(), (CharSequence)thatSchema.pattern())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)thisSchema.discriminatorProperty(), (CharSequence)thatSchema.discriminatorProperty())) {
            return false;
        }
        if (thisSchema.multipleOf() != thatSchema.multipleOf()) {
            return false;
        }
        if (thisSchema.minLength() != thatSchema.minLength()) {
            return false;
        }
        if (thisSchema.minProperties() != thatSchema.minProperties()) {
            return false;
        }
        if (thisSchema.maxProperties() != thatSchema.maxProperties()) {
            return false;
        }
        if (thisSchema.maxLength() != thatSchema.maxLength()) {
            return false;
        }
        if (!Arrays.equals(thisSchema.allOf(), thatSchema.allOf())) {
            return false;
        }
        if (!Arrays.equals(thisSchema.oneOf(), thatSchema.oneOf())) {
            return false;
        }
        if (!Arrays.equals(thisSchema.anyOf(), thatSchema.anyOf())) {
            return false;
        }
        if (!Arrays.equals(thisSchema.subTypes(), thatSchema.subTypes())) {
            return false;
        }
        if (!Arrays.equals(thisSchema.discriminatorMapping(), thatSchema.discriminatorMapping())) {
            return false;
        }
        if (!Arrays.equals(thisSchema.extensions(), thatSchema.extensions())) {
            return false;
        }
        if (!Arrays.equals(thisSchema.allowableValues(), thatSchema.allowableValues())) {
            return false;
        }
        if (!Arrays.equals(thisSchema.requiredProperties(), thatSchema.requiredProperties())) {
            return false;
        }
        if (thisSchema.exclusiveMinimum() != thatSchema.exclusiveMinimum()) {
            return false;
        }
        if (thisSchema.exclusiveMaximum() != thatSchema.exclusiveMaximum()) {
            return false;
        }
        if (thisSchema.required() != thatSchema.required()) {
            return false;
        }
        if (thisSchema.nullable() != thatSchema.nullable()) {
            return false;
        }
        if (thisSchema.readOnly() != thatSchema.readOnly()) {
            return false;
        }
        if (thisSchema.writeOnly() != thatSchema.writeOnly()) {
            return false;
        }
        if (!thisSchema.accessMode().equals((Object)thatSchema.accessMode())) {
            return false;
        }
        if (thisSchema.deprecated() != thatSchema.deprecated()) {
            return false;
        }
        if (thisSchema.hidden() != thatSchema.hidden()) {
            return false;
        }
        if (!thisSchema.implementation().equals(thatSchema.implementation())) {
            return false;
        }
        if (!thisSchema.not().equals(thatSchema.not())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)thisSchema.externalDocs().description(), (CharSequence)thatSchema.externalDocs().description())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)thisSchema.externalDocs().url(), (CharSequence)thatSchema.externalDocs().url())) {
            return false;
        }
        if (thisSchema.externalDocs().extensions().length != thatSchema.externalDocs().extensions().length) {
            return false;
        }
        return Arrays.equals(thisSchema.extensions(), thatSchema.extensions());
    }

    public static boolean hasArrayAnnotation(io.swagger.v3.oas.annotations.media.ArraySchema array) {
        if (array == null) {
            return false;
        }
        return array.uniqueItems() || array.maxItems() != Integer.MIN_VALUE || array.minItems() != Integer.MAX_VALUE || AnnotationsUtils.hasSchemaAnnotation(array.schema()) || AnnotationsUtils.hasSchemaAnnotation(array.arraySchema());
    }

    public static Optional<Example> getExample(ExampleObject example) {
        if (example == null) {
            return Optional.empty();
        }
        if (StringUtils.isNotBlank((CharSequence)example.name())) {
            Map<String, Object> extensions;
            Example exampleObject = new Example();
            if (StringUtils.isNotBlank((CharSequence)example.name())) {
                exampleObject.setDescription(example.name());
            }
            if (StringUtils.isNotBlank((CharSequence)example.summary())) {
                exampleObject.setSummary(example.summary());
            }
            if (StringUtils.isNotBlank((CharSequence)example.externalValue())) {
                exampleObject.setExternalValue(example.externalValue());
            }
            if (StringUtils.isNotBlank((CharSequence)example.value())) {
                try {
                    exampleObject.setValue((Object)Json.mapper().readTree(example.value()));
                }
                catch (IOException e) {
                    exampleObject.setValue((Object)example.value());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)example.ref())) {
                exampleObject.set$ref(example.ref());
            }
            if (example.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(example.extensions())) != null) {
                for (String ext : extensions.keySet()) {
                    exampleObject.addExtension(ext, extensions.get(ext));
                }
            }
            return Optional.of(exampleObject);
        }
        return Optional.empty();
    }

    public static Optional<ArraySchema> getArraySchema(io.swagger.v3.oas.annotations.media.ArraySchema arraySchema, JsonView jsonViewAnnotation) {
        return AnnotationsUtils.getArraySchema(arraySchema, null, jsonViewAnnotation);
    }

    public static Optional<ArraySchema> getArraySchema(io.swagger.v3.oas.annotations.media.ArraySchema arraySchema, Components components, JsonView jsonViewAnnotation) {
        Map<String, Object> extensions;
        if (arraySchema == null || !AnnotationsUtils.hasArrayAnnotation(arraySchema)) {
            return Optional.empty();
        }
        ArraySchema arraySchemaObject = new ArraySchema();
        if (arraySchema.uniqueItems()) {
            arraySchemaObject.setUniqueItems(Boolean.valueOf(arraySchema.uniqueItems()));
        }
        if (arraySchema.maxItems() > 0) {
            arraySchemaObject.setMaxItems(Integer.valueOf(arraySchema.maxItems()));
        }
        if (arraySchema.minItems() < Integer.MAX_VALUE) {
            arraySchemaObject.setMinItems(Integer.valueOf(arraySchema.minItems()));
        }
        if (arraySchema.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(arraySchema.extensions())) != null) {
            for (String ext : extensions.keySet()) {
                arraySchemaObject.addExtension(ext, extensions.get(ext));
            }
        }
        if (arraySchema.schema() != null && arraySchema.schema().implementation().equals(Void.class)) {
            AnnotationsUtils.getSchemaFromAnnotation(arraySchema.schema(), components, jsonViewAnnotation).ifPresent(schema -> {
                if (StringUtils.isNotBlank((CharSequence)schema.getType()) || StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
                    arraySchemaObject.setItems(schema);
                }
            });
        }
        return Optional.of(arraySchemaObject);
    }

    public static Optional<Schema> getSchemaFromAnnotation(io.swagger.v3.oas.annotations.media.Schema schema, JsonView jsonViewAnnotation) {
        return AnnotationsUtils.getSchemaFromAnnotation(schema, null, jsonViewAnnotation);
    }

    public static Optional<Schema> getSchemaFromAnnotation(io.swagger.v3.oas.annotations.media.Schema schema, Components components, JsonView jsonViewAnnotation) {
        Class[] schemaImplementations;
        Map<String, Object> extensions;
        if (schema == null || !AnnotationsUtils.hasSchemaAnnotation(schema)) {
            return Optional.empty();
        }
        Object schemaObject = null;
        schemaObject = schema.oneOf().length > 0 || schema.allOf().length > 0 || schema.anyOf().length > 0 ? new ComposedSchema() : new Schema();
        if (StringUtils.isNotBlank((CharSequence)schema.description())) {
            schemaObject.setDescription(schema.description());
        }
        if (StringUtils.isNotBlank((CharSequence)schema.ref())) {
            schemaObject.set$ref(schema.ref());
        }
        if (StringUtils.isNotBlank((CharSequence)schema.type())) {
            schemaObject.setType(schema.type());
        }
        if (StringUtils.isNotBlank((CharSequence)schema.defaultValue())) {
            schemaObject.setDefault((Object)schema.defaultValue());
        }
        if (StringUtils.isNotBlank((CharSequence)schema.example())) {
            try {
                schemaObject.setExample((Object)Json.mapper().readTree(schema.example()));
            }
            catch (IOException e) {
                schemaObject.setExample((Object)schema.example());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)schema.format())) {
            schemaObject.setFormat(schema.format());
        }
        if (StringUtils.isNotBlank((CharSequence)schema.pattern())) {
            schemaObject.setPattern(schema.pattern());
        }
        if (schema.readOnly()) {
            schemaObject.setReadOnly(Boolean.valueOf(schema.readOnly()));
        }
        if (schema.deprecated()) {
            schemaObject.setDeprecated(Boolean.valueOf(schema.deprecated()));
        }
        if (schema.exclusiveMaximum()) {
            schemaObject.setExclusiveMaximum(Boolean.valueOf(schema.exclusiveMaximum()));
        }
        if (schema.exclusiveMinimum()) {
            schemaObject.setExclusiveMinimum(Boolean.valueOf(schema.exclusiveMinimum()));
        }
        if (schema.maxProperties() > 0) {
            schemaObject.setMaxProperties(Integer.valueOf(schema.maxProperties()));
        }
        if (schema.maxLength() != Integer.MAX_VALUE && schema.maxLength() > 0) {
            schemaObject.setMaxLength(Integer.valueOf(schema.maxLength()));
        }
        if (schema.minProperties() > 0) {
            schemaObject.setMinProperties(Integer.valueOf(schema.minProperties()));
        }
        if (schema.minLength() > 0) {
            schemaObject.setMinLength(Integer.valueOf(schema.minLength()));
        }
        if (schema.multipleOf() != 0.0) {
            schemaObject.setMultipleOf(new BigDecimal(schema.multipleOf()));
        }
        if (NumberUtils.isNumber((String)schema.maximum())) {
            String filteredMaximum = schema.maximum().replaceAll(",", "");
            schemaObject.setMaximum(new BigDecimal(filteredMaximum));
        }
        if (NumberUtils.isNumber((String)schema.minimum())) {
            String filteredMinimum = schema.minimum().replaceAll(",", "");
            schemaObject.setMinimum(new BigDecimal(filteredMinimum));
        }
        if (schema.nullable()) {
            schemaObject.setNullable(Boolean.valueOf(schema.nullable()));
        }
        if (StringUtils.isNotBlank((CharSequence)schema.title())) {
            schemaObject.setTitle(schema.title());
        }
        if (schema.writeOnly()) {
            schemaObject.setWriteOnly(Boolean.valueOf(schema.writeOnly()));
        }
        if (schema.accessMode().equals((Object)Schema.AccessMode.READ_ONLY)) {
            schemaObject.setReadOnly(Boolean.valueOf(true));
            schemaObject.setWriteOnly(null);
        } else if (schema.accessMode().equals((Object)Schema.AccessMode.WRITE_ONLY)) {
            schemaObject.setReadOnly(Boolean.valueOf(false));
            schemaObject.setWriteOnly(null);
        } else if (schema.accessMode().equals((Object)Schema.AccessMode.READ_WRITE)) {
            schemaObject.setReadOnly(null);
            schemaObject.setWriteOnly(null);
        }
        if (schema.requiredProperties().length > 0) {
            schemaObject.setRequired(Arrays.asList(schema.requiredProperties()));
        }
        if (schema.allowableValues().length > 0) {
            schemaObject.setEnum(Arrays.asList(schema.allowableValues()));
        }
        if (schema.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(schema.extensions())) != null) {
            for (String ext : extensions.keySet()) {
                schemaObject.addExtension(ext, extensions.get(ext));
            }
        }
        AnnotationsUtils.getExternalDocumentation(schema.externalDocs()).ifPresent(arg_0 -> ((Schema)schemaObject).setExternalDocs(arg_0));
        if (!schema.not().equals(Void.class)) {
            Class schemaImplementation = schema.not();
            Schema notSchemaObject = AnnotationsUtils.resolveSchemaFromType(schemaImplementation, components, jsonViewAnnotation);
            schemaObject.setNot(notSchemaObject);
        }
        if (schema.oneOf().length > 0) {
            for (Class schemaImplementation : schemaImplementations = schema.oneOf()) {
                Schema oneOfSchemaObject = AnnotationsUtils.resolveSchemaFromType(schemaImplementation, components, jsonViewAnnotation);
                schemaObject.addOneOfItem(oneOfSchemaObject);
            }
        }
        if (schema.anyOf().length > 0) {
            for (Class schemaImplementation : schemaImplementations = schema.anyOf()) {
                Schema anyOfSchemaObject = AnnotationsUtils.resolveSchemaFromType(schemaImplementation, components, jsonViewAnnotation);
                schemaObject.addAnyOfItem(anyOfSchemaObject);
            }
        }
        if (schema.allOf().length > 0) {
            for (Class schemaImplementation : schemaImplementations = schema.allOf()) {
                Schema allOfSchemaObject = AnnotationsUtils.resolveSchemaFromType(schemaImplementation, components, jsonViewAnnotation);
                schemaObject.addAllOfItem(allOfSchemaObject);
            }
        }
        return Optional.of(schemaObject);
    }

    public static Schema resolveSchemaFromType(Class<?> schemaImplementation, Components components, JsonView jsonViewAnnotation) {
        Schema schemaObject = new Schema();
        if (schemaImplementation.getName().startsWith("java.lang")) {
            schemaObject.setType(schemaImplementation.getSimpleName().toLowerCase());
        } else {
            ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(new AnnotatedType().type(schemaImplementation).jsonViewAnnotation(jsonViewAnnotation));
            if (resolvedSchema != null) {
                Map<String, Schema> schemaMap = resolvedSchema.referencedSchemas;
                schemaMap.forEach((key, referencedSchema) -> {
                    if (components != null) {
                        components.addSchemas(key, referencedSchema);
                    }
                });
                schemaObject.set$ref(COMPONENTS_REF + resolvedSchema.schema.getName());
            }
        }
        if (StringUtils.isBlank((CharSequence)schemaObject.get$ref()) && StringUtils.isBlank((CharSequence)schemaObject.getType())) {
            schemaObject.setType("string");
        }
        return schemaObject;
    }

    public static Optional<Set<io.swagger.v3.oas.models.tags.Tag>> getTags(Tag[] tags, boolean skipOnlyName) {
        if (tags == null) {
            return Optional.empty();
        }
        LinkedHashSet<io.swagger.v3.oas.models.tags.Tag> tagsList = new LinkedHashSet<io.swagger.v3.oas.models.tags.Tag>();
        for (Tag tag : tags) {
            Map<String, Object> extensions;
            if (StringUtils.isBlank((CharSequence)tag.name()) || skipOnlyName && StringUtils.isBlank((CharSequence)tag.description()) && StringUtils.isBlank((CharSequence)tag.externalDocs().description()) && StringUtils.isBlank((CharSequence)tag.externalDocs().url())) continue;
            io.swagger.v3.oas.models.tags.Tag tagObject = new io.swagger.v3.oas.models.tags.Tag();
            if (StringUtils.isNotBlank((CharSequence)tag.description())) {
                tagObject.setDescription(tag.description());
            }
            tagObject.setName(tag.name());
            AnnotationsUtils.getExternalDocumentation(tag.externalDocs()).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.tags.Tag)tagObject).setExternalDocs(arg_0));
            if (tag.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(tag.extensions())) != null) {
                for (String ext : extensions.keySet()) {
                    tagObject.addExtension(ext, extensions.get(ext));
                }
            }
            tagsList.add(tagObject);
        }
        if (tagsList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(tagsList);
    }

    public static Optional<List<io.swagger.v3.oas.models.servers.Server>> getServers(Server[] servers) {
        if (servers == null) {
            return Optional.empty();
        }
        ArrayList serverObjects = new ArrayList();
        for (Server server : servers) {
            AnnotationsUtils.getServer(server).ifPresent(serverObjects::add);
        }
        if (serverObjects.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(serverObjects);
    }

    public static Optional<io.swagger.v3.oas.models.servers.Server> getServer(Server server) {
        if (server == null) {
            return Optional.empty();
        }
        io.swagger.v3.oas.models.servers.Server serverObject = new io.swagger.v3.oas.models.servers.Server();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)server.url())) {
            serverObject.setUrl(server.url());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)server.description())) {
            serverObject.setDescription(server.description());
            isEmpty = false;
        }
        if (server.extensions().length > 0) {
            Map<String, Object> extensions = AnnotationsUtils.getExtensions(server.extensions());
            if (extensions != null) {
                for (String ext : extensions.keySet()) {
                    serverObject.addExtension(ext, extensions.get(ext));
                }
            }
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        io.swagger.v3.oas.annotations.servers.ServerVariable[] serverVariables = server.variables();
        ServerVariables serverVariablesObject = new ServerVariables();
        for (io.swagger.v3.oas.annotations.servers.ServerVariable serverVariable : serverVariables) {
            Map<String, Object> extensions;
            ServerVariable serverVariableObject = new ServerVariable();
            if (StringUtils.isNotBlank((CharSequence)serverVariable.description())) {
                serverVariableObject.setDescription(serverVariable.description());
            }
            if (StringUtils.isNotBlank((CharSequence)serverVariable.defaultValue())) {
                serverVariableObject.setDefault(serverVariable.defaultValue());
            }
            if (serverVariable.allowableValues() != null && serverVariable.allowableValues().length > 0) {
                serverVariableObject.setEnum(Arrays.asList(serverVariable.allowableValues()));
            }
            if (serverVariable.extensions() != null && serverVariable.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(serverVariable.extensions())) != null) {
                for (String ext : extensions.keySet()) {
                    serverVariableObject.addExtension(ext, extensions.get(ext));
                }
            }
            serverVariablesObject.addServerVariable(serverVariable.name(), serverVariableObject);
        }
        serverObject.setVariables(serverVariablesObject);
        return Optional.of(serverObject);
    }

    public static Optional<ExternalDocumentation> getExternalDocumentation(io.swagger.v3.oas.annotations.ExternalDocumentation externalDocumentation) {
        Map<String, Object> extensions;
        if (externalDocumentation == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        ExternalDocumentation external = new ExternalDocumentation();
        if (StringUtils.isNotBlank((CharSequence)externalDocumentation.description())) {
            isEmpty = false;
            external.setDescription(externalDocumentation.description());
        }
        if (StringUtils.isNotBlank((CharSequence)externalDocumentation.url())) {
            isEmpty = false;
            external.setUrl(externalDocumentation.url());
        }
        if (externalDocumentation.extensions() != null && externalDocumentation.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(externalDocumentation.extensions())) != null) {
            for (String ext : extensions.keySet()) {
                external.addExtension(ext, extensions.get(ext));
            }
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(external);
    }

    public static Optional<io.swagger.v3.oas.models.info.Info> getInfo(Info info) {
        Map<String, Object> extensions;
        if (info == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        io.swagger.v3.oas.models.info.Info infoObject = new io.swagger.v3.oas.models.info.Info();
        if (StringUtils.isNotBlank((CharSequence)info.description())) {
            infoObject.setDescription(info.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)info.termsOfService())) {
            infoObject.setTermsOfService(info.termsOfService());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)info.title())) {
            infoObject.setTitle(info.title());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)info.version())) {
            infoObject.setVersion(info.version());
            isEmpty = false;
        }
        if (info.extensions() != null && info.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(info.extensions())) != null) {
            for (String ext : extensions.keySet()) {
                infoObject.addExtension(ext, extensions.get(ext));
            }
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        AnnotationsUtils.getContact(info.contact()).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.info.Info)infoObject).setContact(arg_0));
        AnnotationsUtils.getLicense(info.license()).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.info.Info)infoObject).setLicense(arg_0));
        return Optional.of(infoObject);
    }

    public static Optional<io.swagger.v3.oas.models.info.Contact> getContact(Contact contact) {
        Map<String, Object> extensions;
        if (contact == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        io.swagger.v3.oas.models.info.Contact contactObject = new io.swagger.v3.oas.models.info.Contact();
        if (StringUtils.isNotBlank((CharSequence)contact.email())) {
            contactObject.setEmail(contact.email());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)contact.name())) {
            contactObject.setName(contact.name());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)contact.url())) {
            contactObject.setUrl(contact.url());
            isEmpty = false;
        }
        if (contact.extensions() != null && contact.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(contact.extensions())) != null) {
            for (String ext : extensions.keySet()) {
                contactObject.addExtension(ext, extensions.get(ext));
            }
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(contactObject);
    }

    public static Optional<License> getLicense(io.swagger.v3.oas.annotations.info.License license) {
        Map<String, Object> extensions;
        if (license == null) {
            return Optional.empty();
        }
        License licenseObject = new License();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)license.name())) {
            licenseObject.setName(license.name());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)license.url())) {
            licenseObject.setUrl(license.url());
            isEmpty = false;
        }
        if (license.extensions() != null && license.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(license.extensions())) != null) {
            for (String ext : extensions.keySet()) {
                licenseObject.addExtension(ext, extensions.get(ext));
            }
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(licenseObject);
    }

    public static Map<String, Link> getLinks(io.swagger.v3.oas.annotations.links.Link[] links) {
        HashMap<String, Link> linkMap = new HashMap<String, Link>();
        if (links == null) {
            return linkMap;
        }
        for (io.swagger.v3.oas.annotations.links.Link link : links) {
            AnnotationsUtils.getLink(link).ifPresent(linkResult -> linkMap.put(link.name(), (Link)linkResult));
        }
        return linkMap;
    }

    public static Optional<Link> getLink(io.swagger.v3.oas.annotations.links.Link link) {
        Map<String, Object> extensions;
        if (link == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        Link linkObject = new Link();
        if (StringUtils.isNotBlank((CharSequence)link.description())) {
            linkObject.setDescription(link.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)link.operationId())) {
            linkObject.setOperationId(link.operationId());
            isEmpty = false;
            if (StringUtils.isNotBlank((CharSequence)link.operationRef())) {
                LOGGER.debug("OperationId and OperatonRef are mutually exclusive, there must be only one setted");
            }
        } else if (StringUtils.isNotBlank((CharSequence)link.operationRef())) {
            linkObject.setOperationRef(link.operationRef());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)link.ref())) {
            linkObject.set$ref(link.ref());
            isEmpty = false;
        }
        if (link.extensions() != null && link.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(link.extensions())) != null) {
            for (String ext : extensions.keySet()) {
                linkObject.addExtension(ext, extensions.get(ext));
            }
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        Map<String, String> linkParameters = AnnotationsUtils.getLinkParameters(link.parameters());
        if (linkParameters.size() > 0) {
            linkObject.setParameters(linkParameters);
        }
        if (StringUtils.isNotBlank((CharSequence)link.requestBody())) {
            JsonNode processedValue = null;
            try {
                processedValue = Json.mapper().readTree(link.requestBody());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (processedValue == null) {
                linkObject.requestBody((Object)link.requestBody());
            } else {
                linkObject.requestBody((Object)processedValue);
            }
        }
        return Optional.of(linkObject);
    }

    public static Map<String, String> getLinkParameters(LinkParameter[] linkParameter) {
        HashMap<String, String> linkParametersMap = new HashMap<String, String>();
        if (linkParameter == null) {
            return linkParametersMap;
        }
        for (LinkParameter parameter : linkParameter) {
            if (!StringUtils.isNotBlank((CharSequence)parameter.name())) continue;
            linkParametersMap.put(parameter.name(), parameter.expression());
        }
        return linkParametersMap;
    }

    public static Optional<Map<String, Header>> getHeaders(io.swagger.v3.oas.annotations.headers.Header[] annotationHeaders, JsonView jsonViewAnnotation) {
        if (annotationHeaders == null) {
            return Optional.empty();
        }
        HashMap headers = new HashMap();
        for (io.swagger.v3.oas.annotations.headers.Header header : annotationHeaders) {
            AnnotationsUtils.getHeader(header, jsonViewAnnotation).ifPresent(headerResult -> headers.put(header.name(), headerResult));
        }
        if (headers.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(headers);
    }

    public static Optional<Header> getHeader(io.swagger.v3.oas.annotations.headers.Header header, JsonView jsonViewAnnotation) {
        if (header == null) {
            return Optional.empty();
        }
        Header headerObject = new Header();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)header.description())) {
            headerObject.setDescription(header.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)header.ref())) {
            headerObject.set$ref(header.ref());
            isEmpty = false;
        }
        if (header.deprecated()) {
            headerObject.setDeprecated(Boolean.valueOf(header.deprecated()));
        }
        if (header.required()) {
            headerObject.setRequired(Boolean.valueOf(header.required()));
            isEmpty = false;
        }
        headerObject.setStyle(Header.StyleEnum.SIMPLE);
        if (header.schema() != null && header.schema().implementation().equals(Void.class)) {
            AnnotationsUtils.getSchemaFromAnnotation(header.schema(), jsonViewAnnotation).ifPresent(schema -> {
                if (StringUtils.isNotBlank((CharSequence)schema.getType())) {
                    headerObject.setSchema(schema);
                }
            });
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(headerObject);
    }

    public static void addEncodingToMediaType(MediaType mediaType, io.swagger.v3.oas.annotations.media.Encoding encoding, JsonView jsonViewAnnotation) {
        if (encoding == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)encoding.name())) {
            Map<String, Object> extensions;
            Encoding encodingObject = new Encoding();
            if (StringUtils.isNotBlank((CharSequence)encoding.contentType())) {
                encodingObject.setContentType(encoding.contentType());
            }
            if (StringUtils.isNotBlank((CharSequence)encoding.style())) {
                encodingObject.setStyle(Encoding.StyleEnum.valueOf((String)encoding.style()));
            }
            if (encoding.explode()) {
                encodingObject.setExplode(Boolean.valueOf(encoding.explode()));
            }
            if (encoding.allowReserved()) {
                encodingObject.setAllowReserved(Boolean.valueOf(encoding.allowReserved()));
            }
            if (encoding.headers() != null) {
                AnnotationsUtils.getHeaders(encoding.headers(), jsonViewAnnotation).ifPresent(arg_0 -> ((Encoding)encodingObject).headers(arg_0));
            }
            if (encoding.extensions() != null && encoding.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(encoding.extensions())) != null) {
                for (String ext : extensions.keySet()) {
                    encodingObject.addExtension(ext, extensions.get(ext));
                }
            }
            mediaType.addEncoding(encoding.name(), encodingObject);
        }
    }

    public static Type getSchemaType(io.swagger.v3.oas.annotations.media.Schema schema) {
        return AnnotationsUtils.getSchemaType(schema, false);
    }

    public static Type getSchemaType(io.swagger.v3.oas.annotations.media.Schema schema, boolean nullIfNotFound) {
        if (schema == null) {
            if (nullIfNotFound) {
                return null;
            }
            return String.class;
        }
        String schemaType = schema.type();
        String schemaFormat = schema.format();
        Class schemaImplementation = schema.implementation();
        if (!schemaImplementation.equals(Void.class)) {
            return schemaImplementation;
        }
        if (StringUtils.isBlank((CharSequence)schemaType)) {
            if (nullIfNotFound) {
                return null;
            }
            return String.class;
        }
        switch (schemaType) {
            case "number": {
                if ("float".equals(schemaFormat)) {
                    return Float.class;
                }
                if ("double".equals(schemaFormat)) {
                    return Double.class;
                }
                return BigDecimal.class;
            }
            case "integer": {
                if ("int32".equals(schemaFormat)) {
                    return Integer.class;
                }
                return Long.class;
            }
            case "boolean": {
                return Boolean.class;
            }
            case "string": {
                return String.class;
            }
        }
        if (nullIfNotFound) {
            return null;
        }
        return String.class;
    }

    public static Optional<Content> getContent(io.swagger.v3.oas.annotations.media.Content[] annotationContents, String[] classTypes, String[] methodTypes, Schema schema, Components components, JsonView jsonViewAnnotation) {
        if (annotationContents == null || annotationContents.length == 0) {
            return Optional.empty();
        }
        Content content = new Content();
        for (io.swagger.v3.oas.annotations.media.Content annotationContent : annotationContents) {
            io.swagger.v3.oas.annotations.media.Encoding[] encodings;
            Map<String, Object> extensions;
            ExampleObject[] examples;
            MediaType mediaType = new MediaType();
            if (components != null) {
                AnnotationsUtils.getSchema(annotationContent, components, jsonViewAnnotation).ifPresent(arg_0 -> ((MediaType)mediaType).setSchema(arg_0));
            } else {
                mediaType.setSchema(schema);
            }
            for (ExampleObject example : examples = annotationContent.examples()) {
                AnnotationsUtils.getExample(example).ifPresent(exampleObject -> mediaType.addExamples(example.name(), exampleObject));
            }
            if (annotationContent.extensions() != null && annotationContent.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(annotationContent.extensions())) != null) {
                for (String ext : extensions.keySet()) {
                    mediaType.addExtension(ext, extensions.get(ext));
                }
            }
            for (io.swagger.v3.oas.annotations.media.Encoding encoding : encodings = annotationContent.encoding()) {
                AnnotationsUtils.addEncodingToMediaType(mediaType, encoding, jsonViewAnnotation);
            }
            if (StringUtils.isNotBlank((CharSequence)annotationContent.mediaType())) {
                content.addMediaType(annotationContent.mediaType(), mediaType);
                continue;
            }
            AnnotationsUtils.applyTypes(classTypes, methodTypes, content, mediaType);
        }
        if (content.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(content);
    }

    public static Optional<? extends Schema> getSchema(io.swagger.v3.oas.annotations.media.Content annotationContent, Components components, JsonView jsonViewAnnotation) {
        Class schemaImplementation = annotationContent.schema().implementation();
        boolean isArray = false;
        if (schemaImplementation == Void.class && (schemaImplementation = annotationContent.array().schema().implementation()) != Void.class) {
            isArray = true;
        }
        return AnnotationsUtils.getSchema(annotationContent.schema(), annotationContent.array(), isArray, schemaImplementation, components, jsonViewAnnotation);
    }

    public static Optional<? extends Schema> getSchema(io.swagger.v3.oas.annotations.media.Schema schemaAnnotation, io.swagger.v3.oas.annotations.media.ArraySchema arrayAnnotation, boolean isArray, Class<?> schemaImplementation, Components components, JsonView jsonViewAnnotation) {
        if (schemaImplementation != Void.class) {
            Schema schemaObject = new Schema();
            if (schemaImplementation.getName().startsWith("java.lang")) {
                schemaObject.setType(schemaImplementation.getSimpleName().toLowerCase());
            } else {
                ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(new AnnotatedType().type(schemaImplementation).jsonViewAnnotation(jsonViewAnnotation));
                if (resolvedSchema != null) {
                    Map<String, Schema> schemaMap = resolvedSchema.referencedSchemas;
                    schemaMap.forEach((key, schema) -> components.addSchemas(key, schema));
                    if (resolvedSchema.schema != null) {
                        schemaObject.set$ref(COMPONENTS_REF + resolvedSchema.schema.getName());
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)schemaObject.get$ref()) && StringUtils.isBlank((CharSequence)schemaObject.getType())) {
                schemaObject.setType("string");
            }
            if (isArray) {
                Optional<ArraySchema> arraySchema = AnnotationsUtils.getArraySchema(arrayAnnotation, components, jsonViewAnnotation);
                if (arraySchema.isPresent()) {
                    arraySchema.get().setItems(schemaObject);
                    return arraySchema;
                }
                return Optional.empty();
            }
            return Optional.of(schemaObject);
        }
        Optional<Schema> schemaFromAnnotation = AnnotationsUtils.getSchemaFromAnnotation(schemaAnnotation, components, jsonViewAnnotation);
        if (schemaFromAnnotation.isPresent()) {
            if (StringUtils.isBlank((CharSequence)schemaFromAnnotation.get().get$ref()) && StringUtils.isBlank((CharSequence)schemaFromAnnotation.get().getType())) {
                schemaFromAnnotation.get().setType("string");
            }
            return Optional.of(schemaFromAnnotation.get());
        }
        Optional<ArraySchema> arraySchemaFromAnnotation = AnnotationsUtils.getArraySchema(arrayAnnotation, components, jsonViewAnnotation);
        if (arraySchemaFromAnnotation.isPresent()) {
            if (arraySchemaFromAnnotation.get().getItems() != null && StringUtils.isBlank((CharSequence)arraySchemaFromAnnotation.get().getItems().get$ref()) && StringUtils.isBlank((CharSequence)arraySchemaFromAnnotation.get().getItems().getType())) {
                arraySchemaFromAnnotation.get().getItems().setType("string");
            }
            return Optional.of(arraySchemaFromAnnotation.get());
        }
        return Optional.empty();
    }

    public static void applyTypes(String[] classTypes, String[] methodTypes, Content content, MediaType mediaType) {
        if (methodTypes != null && methodTypes.length > 0) {
            for (String value : methodTypes) {
                content.addMediaType(value, mediaType);
            }
        } else if (classTypes != null && classTypes.length > 0) {
            for (String value : classTypes) {
                content.addMediaType(value, mediaType);
            }
        } else {
            content.addMediaType("*/*", mediaType);
        }
    }

    public static io.swagger.v3.oas.annotations.media.Schema getSchemaAnnotation(Annotated a) {
        if (a == null) {
            return null;
        }
        io.swagger.v3.oas.annotations.media.ArraySchema arraySchema = (io.swagger.v3.oas.annotations.media.ArraySchema)a.getAnnotation(io.swagger.v3.oas.annotations.media.ArraySchema.class);
        if (arraySchema != null) {
            return arraySchema.schema();
        }
        return (io.swagger.v3.oas.annotations.media.Schema)a.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
    }

    public static io.swagger.v3.oas.annotations.media.Schema getSchemaDeclaredAnnotation(Annotated a) {
        if (a == null) {
            return null;
        }
        io.swagger.v3.oas.annotations.media.ArraySchema arraySchema = a.getRawType().getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.ArraySchema.class);
        if (arraySchema != null) {
            return arraySchema.schema();
        }
        return a.getRawType().getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
    }

    public static io.swagger.v3.oas.annotations.media.Schema getSchemaAnnotation(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        io.swagger.v3.oas.annotations.media.Schema mp = null;
        io.swagger.v3.oas.annotations.media.ArraySchema as = cls.getAnnotation(io.swagger.v3.oas.annotations.media.ArraySchema.class);
        mp = as != null ? as.schema() : cls.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        return mp;
    }

    public static io.swagger.v3.oas.annotations.media.Schema getSchemaDeclaredAnnotation(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        io.swagger.v3.oas.annotations.media.Schema mp = null;
        io.swagger.v3.oas.annotations.media.ArraySchema as = cls.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.ArraySchema.class);
        mp = as != null ? as.schema() : cls.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        return mp;
    }

    public static Map<String, Object> getExtensions(Extension ... extensions) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Extension extension : extensions) {
            String name = extension.name();
            String key = name.length() > 0 ? StringUtils.prependIfMissing((String)name, (CharSequence)"x-", (CharSequence[])new CharSequence[0]) : name;
            for (ExtensionProperty property : extension.properties()) {
                String propertyName = property.name();
                String propertyValue = property.value();
                JsonNode processedValue = null;
                boolean propertyAsJson = property.parseValue();
                if (!StringUtils.isNotBlank((CharSequence)propertyName) || !StringUtils.isNotBlank((CharSequence)propertyValue)) continue;
                if (key.isEmpty()) {
                    if (propertyAsJson) {
                        try {
                            processedValue = Json.mapper().readTree(propertyValue);
                            map.put(StringUtils.prependIfMissing((String)propertyName, (CharSequence)"x-", (CharSequence[])new CharSequence[0]), processedValue);
                        }
                        catch (Exception e) {
                            map.put(StringUtils.prependIfMissing((String)propertyName, (CharSequence)"x-", (CharSequence[])new CharSequence[0]), propertyValue);
                        }
                        continue;
                    }
                    map.put(StringUtils.prependIfMissing((String)propertyName, (CharSequence)"x-", (CharSequence[])new CharSequence[0]), propertyValue);
                    continue;
                }
                Object value = map.get(key);
                if (value == null || !(value instanceof Map)) {
                    value = new HashMap();
                    map.put(key, value);
                }
                Map mapValue = (Map)value;
                if (propertyAsJson) {
                    try {
                        processedValue = Json.mapper().readTree(propertyValue);
                        mapValue.put(propertyName, processedValue);
                    }
                    catch (Exception e) {
                        mapValue.put(propertyName, propertyValue);
                    }
                    continue;
                }
                mapValue.put(propertyName, propertyValue);
            }
        }
        return map;
    }

    public static io.swagger.v3.oas.annotations.media.Schema getSchemaAnnotation(Annotation ... annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof io.swagger.v3.oas.annotations.media.Schema)) continue;
            return (io.swagger.v3.oas.annotations.media.Schema)annotation;
        }
        return null;
    }

    public static io.swagger.v3.oas.annotations.media.ArraySchema getArraySchemaAnnotation(Annotation ... annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof io.swagger.v3.oas.annotations.media.ArraySchema)) continue;
            return (io.swagger.v3.oas.annotations.media.ArraySchema)annotation;
        }
        return null;
    }

    public static <T> T getAnnotation(Class<T> cls, Annotation ... annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!cls.isAssignableFrom(annotation.getClass())) continue;
            return (T)annotation;
        }
        return null;
    }

    public static Annotation[] removeAnnotations(Annotation[] annotations, Class ... classes) {
        if (annotations == null) {
            return null;
        }
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            boolean found = false;
            for (Class cls : classes) {
                if (!cls.isAssignableFrom(annotation.getClass())) continue;
                found = true;
            }
            if (found) continue;
            result.add(annotation);
        }
        return result.toArray(new Annotation[result.size()]);
    }

    public static void updateAnnotation(Class<?> clazz, io.swagger.v3.oas.annotations.media.Schema newAnnotation) {
        try {
            Field field = Class.class.getDeclaredField("annotations");
            field.setAccessible(true);
            Map annotations = (Map)field.get(clazz);
            annotations.put(io.swagger.v3.oas.annotations.media.Schema.class, newAnnotation);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static Annotation mergeSchemaAnnotations(Annotation[] ctxAnnotations, JavaType type) {
        io.swagger.v3.oas.annotations.media.Schema cAs;
        io.swagger.v3.oas.annotations.media.ArraySchema cA;
        io.swagger.v3.oas.annotations.media.Schema cS;
        io.swagger.v3.oas.annotations.media.Schema tAs;
        io.swagger.v3.oas.annotations.media.ArraySchema tA;
        io.swagger.v3.oas.annotations.media.Schema tS = type.getRawClass().getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        if (!AnnotationsUtils.hasSchemaAnnotation(tS)) {
            tS = null;
        }
        if (!AnnotationsUtils.hasArrayAnnotation(tA = type.getRawClass().getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.ArraySchema.class))) {
            tA = null;
        }
        io.swagger.v3.oas.annotations.media.Schema schema = tAs = tA == null ? null : tA.schema();
        if (!AnnotationsUtils.hasSchemaAnnotation(tAs)) {
            tAs = null;
        }
        if (!AnnotationsUtils.hasSchemaAnnotation(cS = AnnotationsUtils.getSchemaAnnotation(ctxAnnotations))) {
            cS = null;
        }
        if (!AnnotationsUtils.hasArrayAnnotation(cA = AnnotationsUtils.getArraySchemaAnnotation(ctxAnnotations))) {
            cA = null;
        }
        io.swagger.v3.oas.annotations.media.Schema schema2 = cAs = cA == null ? null : cA.schema();
        if (!AnnotationsUtils.hasSchemaAnnotation(cAs)) {
            cAs = null;
        }
        if (tS == null && tA == null && cS == null && cA == null) {
            return null;
        }
        if (tS == null && tA == null && cS != null) {
            return cS;
        }
        if (tS == null && tA == null && cS == null && cA != null) {
            return cA;
        }
        if (tS == null && tA != null && cS == null && cA == null) {
            return tA;
        }
        if (tS == null && tA != null && cS != null && cA == null) {
            if (tAs != null) {
                return tA;
            }
            return AnnotationsUtils.mergeArrayWithSchemaAnnotation(tA, cS);
        }
        if (tS != null && tA == null && cS == null && cA != null) {
            if (cAs != null) {
                return cA;
            }
            return AnnotationsUtils.mergeArrayWithSchemaAnnotation(cA, tS);
        }
        if (tA != null && cA != null) {
            return AnnotationsUtils.mergeArraySchemaAnnotations(cA, tA);
        }
        if (tS != null && cS == null && cA == null) {
            return tS;
        }
        if (tS != null && cS != null) {
            return AnnotationsUtils.mergeSchemaAnnotations(tS, cS);
        }
        return tS;
    }

    public static io.swagger.v3.oas.annotations.media.Schema mergeSchemaAnnotations(final io.swagger.v3.oas.annotations.media.Schema master, final io.swagger.v3.oas.annotations.media.Schema patch) {
        if (master == null) {
            return patch;
        }
        if (patch == null) {
            return master;
        }
        if (!AnnotationsUtils.hasSchemaAnnotation(patch)) {
            return master;
        }
        io.swagger.v3.oas.annotations.media.Schema schema = new io.swagger.v3.oas.annotations.media.Schema(){

            public Class<?> implementation() {
                if (!master.implementation().equals(Void.class) || patch.implementation().equals(Void.class)) {
                    return master.implementation();
                }
                return patch.implementation();
            }

            public Class<?> not() {
                if (!master.not().equals(Void.class) || patch.not().equals(Void.class)) {
                    return master.not();
                }
                return patch.not();
            }

            public Class<?>[] oneOf() {
                if (master.oneOf().length > 0 || patch.oneOf().length == 0) {
                    return master.oneOf();
                }
                return patch.oneOf();
            }

            public Class<?>[] anyOf() {
                if (master.anyOf().length > 0 || patch.anyOf().length == 0) {
                    return master.anyOf();
                }
                return patch.anyOf();
            }

            public Class<?>[] allOf() {
                if (master.allOf().length > 0 || patch.allOf().length == 0) {
                    return master.allOf();
                }
                return patch.allOf();
            }

            public String name() {
                if (StringUtils.isNotBlank((CharSequence)master.name()) || StringUtils.isBlank((CharSequence)patch.name())) {
                    return master.name();
                }
                return patch.name();
            }

            public String title() {
                if (StringUtils.isNotBlank((CharSequence)master.title()) || StringUtils.isBlank((CharSequence)patch.title())) {
                    return master.title();
                }
                return patch.title();
            }

            public double multipleOf() {
                if (master.multipleOf() != 0.0 || patch.multipleOf() == 0.0) {
                    return master.multipleOf();
                }
                return patch.multipleOf();
            }

            public String maximum() {
                if (StringUtils.isNotBlank((CharSequence)master.maximum()) || StringUtils.isBlank((CharSequence)patch.maximum())) {
                    return master.maximum();
                }
                return patch.maximum();
            }

            public boolean exclusiveMaximum() {
                if (master.exclusiveMaximum() || !patch.exclusiveMaximum()) {
                    return master.exclusiveMaximum();
                }
                return patch.exclusiveMaximum();
            }

            public String minimum() {
                if (StringUtils.isNotBlank((CharSequence)master.minimum()) || StringUtils.isBlank((CharSequence)patch.minimum())) {
                    return master.minimum();
                }
                return patch.minimum();
            }

            public boolean exclusiveMinimum() {
                if (master.exclusiveMinimum() || !patch.exclusiveMinimum()) {
                    return master.exclusiveMinimum();
                }
                return patch.exclusiveMinimum();
            }

            public int maxLength() {
                if (master.maxLength() != Integer.MAX_VALUE && master.maxLength() > 0 || patch.maxLength() == Integer.MAX_VALUE || patch.maxLength() == 0) {
                    return master.maxLength();
                }
                return patch.maxLength();
            }

            public int minLength() {
                if (master.minLength() != 0 || patch.minLength() == 0) {
                    return master.minLength();
                }
                return patch.minLength();
            }

            public String pattern() {
                if (StringUtils.isNotBlank((CharSequence)master.pattern()) || StringUtils.isBlank((CharSequence)patch.pattern())) {
                    return master.pattern();
                }
                return patch.pattern();
            }

            public int maxProperties() {
                if (master.maxProperties() != 0 || patch.maxProperties() == 0) {
                    return master.maxProperties();
                }
                return patch.maxProperties();
            }

            public int minProperties() {
                if (master.minProperties() != 0 || patch.minProperties() == 0) {
                    return master.minProperties();
                }
                return patch.minProperties();
            }

            public String[] requiredProperties() {
                if (master.requiredProperties().length > 0 || patch.requiredProperties().length == 0) {
                    return master.requiredProperties();
                }
                return patch.requiredProperties();
            }

            public boolean required() {
                if (master.required() || !patch.required()) {
                    return master.required();
                }
                return patch.required();
            }

            public String description() {
                if (StringUtils.isNotBlank((CharSequence)master.description()) || StringUtils.isBlank((CharSequence)patch.description())) {
                    return master.description();
                }
                return patch.description();
            }

            public String format() {
                if (StringUtils.isNotBlank((CharSequence)master.format()) || StringUtils.isBlank((CharSequence)patch.format())) {
                    return master.format();
                }
                return patch.format();
            }

            public String ref() {
                if (StringUtils.isNotBlank((CharSequence)master.ref()) || StringUtils.isBlank((CharSequence)patch.ref())) {
                    return master.ref();
                }
                return patch.ref();
            }

            public boolean nullable() {
                if (master.nullable() || !patch.nullable()) {
                    return master.nullable();
                }
                return patch.nullable();
            }

            public boolean readOnly() {
                if (master.readOnly() || !patch.readOnly()) {
                    return master.readOnly();
                }
                return patch.readOnly();
            }

            public boolean writeOnly() {
                if (master.writeOnly() || !patch.writeOnly()) {
                    return master.writeOnly();
                }
                return patch.writeOnly();
            }

            public Schema.AccessMode accessMode() {
                if (!master.accessMode().equals((Object)Schema.AccessMode.AUTO) || patch.accessMode().equals((Object)Schema.AccessMode.AUTO)) {
                    return master.accessMode();
                }
                return patch.accessMode();
            }

            public String example() {
                if (StringUtils.isNotBlank((CharSequence)master.example()) || StringUtils.isBlank((CharSequence)patch.example())) {
                    return master.example();
                }
                return patch.example();
            }

            public io.swagger.v3.oas.annotations.ExternalDocumentation externalDocs() {
                if (AnnotationsUtils.getExternalDocumentation(master.externalDocs()).isPresent() || !AnnotationsUtils.getExternalDocumentation(patch.externalDocs()).isPresent()) {
                    return master.externalDocs();
                }
                return patch.externalDocs();
            }

            public boolean deprecated() {
                if (master.deprecated() || !patch.deprecated()) {
                    return master.deprecated();
                }
                return patch.deprecated();
            }

            public String type() {
                if (StringUtils.isNotBlank((CharSequence)master.type()) || StringUtils.isBlank((CharSequence)patch.type())) {
                    return master.type();
                }
                return patch.type();
            }

            public String[] allowableValues() {
                if (master.requiredProperties().length > 0 || patch.requiredProperties().length == 0) {
                    return master.requiredProperties();
                }
                return patch.requiredProperties();
            }

            public String defaultValue() {
                if (StringUtils.isNotBlank((CharSequence)master.defaultValue()) || StringUtils.isBlank((CharSequence)patch.defaultValue())) {
                    return master.defaultValue();
                }
                return patch.defaultValue();
            }

            public String discriminatorProperty() {
                if (StringUtils.isNotBlank((CharSequence)master.defaultValue()) || StringUtils.isBlank((CharSequence)patch.defaultValue())) {
                    return master.defaultValue();
                }
                return patch.defaultValue();
            }

            public DiscriminatorMapping[] discriminatorMapping() {
                if (master.discriminatorMapping().length > 0 || patch.discriminatorMapping().length == 0) {
                    return master.discriminatorMapping();
                }
                return patch.discriminatorMapping();
            }

            public boolean hidden() {
                if (master.hidden() || !patch.hidden()) {
                    return master.hidden();
                }
                return patch.hidden();
            }

            public Class<?>[] subTypes() {
                if (master.subTypes().length > 0 || patch.subTypes().length == 0) {
                    return master.subTypes();
                }
                return patch.subTypes();
            }

            public Extension[] extensions() {
                if (master.extensions().length > 0 || patch.extensions().length == 0) {
                    return master.extensions();
                }
                return patch.extensions();
            }

            public Class<? extends Annotation> annotationType() {
                return io.swagger.v3.oas.annotations.media.Schema.class;
            }
        };
        return schema;
    }

    public static io.swagger.v3.oas.annotations.media.ArraySchema mergeArraySchemaAnnotations(final io.swagger.v3.oas.annotations.media.ArraySchema master, final io.swagger.v3.oas.annotations.media.ArraySchema patch) {
        if (master == null) {
            return patch;
        }
        if (patch == null) {
            return master;
        }
        if (!AnnotationsUtils.hasArrayAnnotation(patch)) {
            return master;
        }
        io.swagger.v3.oas.annotations.media.ArraySchema newArraySchema = new io.swagger.v3.oas.annotations.media.ArraySchema(){

            public Class<? extends Annotation> annotationType() {
                return io.swagger.v3.oas.annotations.media.ArraySchema.class;
            }

            public io.swagger.v3.oas.annotations.media.Schema schema() {
                io.swagger.v3.oas.annotations.media.Schema patchSchema = patch.schema();
                if (!AnnotationsUtils.hasSchemaAnnotation(patchSchema)) {
                    patchSchema = null;
                }
                if (patchSchema == null) {
                    return master.schema();
                }
                return AnnotationsUtils.mergeSchemaAnnotations(master.schema(), patch.schema());
            }

            public io.swagger.v3.oas.annotations.media.Schema arraySchema() {
                io.swagger.v3.oas.annotations.media.Schema patchSchema = patch.arraySchema();
                if (!AnnotationsUtils.hasSchemaAnnotation(patchSchema)) {
                    patchSchema = null;
                }
                if (patchSchema == null) {
                    return master.arraySchema();
                }
                return AnnotationsUtils.mergeSchemaAnnotations(master.arraySchema(), patch.arraySchema());
            }

            public int maxItems() {
                if (master.maxItems() != 0 || patch.maxItems() == 0) {
                    return master.maxItems();
                }
                return patch.maxItems();
            }

            public int minItems() {
                if (master.maxItems() != 0 || patch.maxItems() == 0) {
                    return master.maxItems();
                }
                return patch.maxItems();
            }

            public boolean uniqueItems() {
                if (master.uniqueItems() || !patch.uniqueItems()) {
                    return master.uniqueItems();
                }
                return patch.uniqueItems();
            }

            public Extension[] extensions() {
                if (master.extensions().length > 0 || patch.extensions().length == 0) {
                    return master.extensions();
                }
                return patch.extensions();
            }
        };
        return newArraySchema;
    }

    public static io.swagger.v3.oas.annotations.media.ArraySchema mergeArrayWithSchemaAnnotation(final io.swagger.v3.oas.annotations.media.ArraySchema arraySchema, final io.swagger.v3.oas.annotations.media.Schema schema) {
        if (arraySchema == null || schema == null) {
            return arraySchema;
        }
        if (!AnnotationsUtils.hasSchemaAnnotation(schema)) {
            return arraySchema;
        }
        io.swagger.v3.oas.annotations.media.ArraySchema newArraySchema = new io.swagger.v3.oas.annotations.media.ArraySchema(){

            public Class<? extends Annotation> annotationType() {
                return io.swagger.v3.oas.annotations.media.ArraySchema.class;
            }

            public io.swagger.v3.oas.annotations.media.Schema schema() {
                return schema;
            }

            public io.swagger.v3.oas.annotations.media.Schema arraySchema() {
                return arraySchema.arraySchema();
            }

            public int maxItems() {
                return arraySchema.maxItems();
            }

            public int minItems() {
                return arraySchema.minItems();
            }

            public boolean uniqueItems() {
                return arraySchema.uniqueItems();
            }

            public Extension[] extensions() {
                return arraySchema.extensions();
            }
        };
        return newArraySchema;
    }
}

