/*
 * Decompiled with CFR 0.152.
 */
package test.java;

import java.io.File;
import java.util.HashMap;
import main.java.com.upyun.FormUploader;
import main.java.com.upyun.Result;
import main.java.com.upyun.SignatureListener;
import main.java.com.upyun.UpYunUtils;
import org.junit.Assert;
import org.junit.Test;

public class FormUploaderTest {
    private static final String BUCKET_NAME = "formtest";
    private static final String APIKEY = "GqSu2v26RI+Xu3yLdsWfynTS/LM=";
    private static final String SAMPLE_PIC_FILE = System.getProperty("user.dir") + "/sample.jpeg";

    @Test
    public void testUploadFile() {
        File file = new File(SAMPLE_PIC_FILE);
        String savePath = "/uploads/{year}{mon}{day}/{random32}{.suffix}";
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("save-key", savePath);
        FormUploader uploader = new FormUploader(BUCKET_NAME, APIKEY, null);
        Result result = uploader.upload(paramsMap, file);
        Assert.assertTrue((boolean)result.isSucceed());
        SignatureListener signatureListener = new SignatureListener(){

            public String getSignature(String raw) {
                return UpYunUtils.md5(raw + FormUploaderTest.APIKEY);
            }
        };
        FormUploader uploader2 = new FormUploader(BUCKET_NAME, null, signatureListener);
        Result result2 = uploader2.upload(paramsMap, file);
        Assert.assertTrue((boolean)result2.isSucceed());
    }

    @Test
    public void testUploadByte() {
        String savePath = "/uploads/{year}{mon}{day}/{random32}{.suffix}";
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("save-key", savePath);
        FormUploader uploader = new FormUploader(BUCKET_NAME, APIKEY, null);
        Result result = uploader.upload(paramsMap, "test1".getBytes());
        Assert.assertTrue((boolean)result.isSucceed());
        SignatureListener signatureListener = new SignatureListener(){

            public String getSignature(String raw) {
                return UpYunUtils.md5(raw + FormUploaderTest.APIKEY);
            }
        };
        FormUploader uploader2 = new FormUploader(BUCKET_NAME, null, signatureListener);
        Result result2 = uploader2.upload(paramsMap, "test2".getBytes());
        Assert.assertTrue((boolean)result2.isSucceed());
    }
}

