/*
 * Decompiled with CFR 0.152.
 */
package main.java.demo;

import java.io.File;
import java.util.HashMap;
import main.java.com.upyun.FormUploader;
import main.java.com.upyun.Result;
import main.java.com.upyun.SignatureListener;
import main.java.com.upyun.UpYunUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class FormUploadDemo {
    private static final String BUCKET_NAME = "\u7a7a\u95f4\u540d";
    private static final String APIKEY = "\u8868\u5355\u5bc6\u5319";
    private static final String SAMPLE_PIC_FILE = System.getProperty("user.dir") + "/sample.jpeg";
    private static File file = new File(SAMPLE_PIC_FILE);
    private static String savePath = "/uploads/{year}{mon}{day}/{random32}{.suffix}";

    public static void main(String[] args) {
        FormUploadDemo.testWriteFile();
        FormUploadDemo.testWatermark();
        FormUploadDemo.testSync();
        FormUploadDemo.testAsync();
    }

    private static void testWriteFile() {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("save-key", savePath);
        FormUploader uploader = new FormUploader(BUCKET_NAME, APIKEY, null);
        Result result = uploader.upload(paramsMap, file);
        System.out.println(result);
        SignatureListener signatureListener = new SignatureListener(){

            public String getSignature(String raw) {
                return UpYunUtils.md5(raw + FormUploadDemo.APIKEY);
            }
        };
        FormUploader uploader2 = new FormUploader(BUCKET_NAME, null, signatureListener);
        Result result2 = uploader2.upload(paramsMap, file);
        System.out.println(result2);
        System.out.println(uploader.upload(paramsMap, "test1".getBytes()));
    }

    private static void testWatermark() {
        FormUploader uploader = new FormUploader(BUCKET_NAME, APIKEY, null);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("save-key", savePath);
        paramsMap.put("x-gmkerl-thumb", "/watermark/text/5L2g5aW977yB");
        System.out.println(uploader.upload(paramsMap, file));
    }

    private static void testSync() {
        FormUploader uploader = new FormUploader(BUCKET_NAME, APIKEY, null);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("save-key", savePath);
        paramsMap.put("x-gmkerl-thumb", "/fw/300/unsharp/true/quality/80/format/png");
        System.out.println(uploader.upload(paramsMap, file));
    }

    private static void testAsync() {
        FormUploader uploader = new FormUploader(BUCKET_NAME, APIKEY, null);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("save-key", savePath);
        JSONArray array = new JSONArray();
        JSONObject json = new JSONObject();
        json.put("name", (Object)"thumb");
        json.put("x-gmkerl-thumb", (Object)"/fw/300/unsharp/true/quality/80/format/png");
        json.put("save_as", (Object)"/path/to/fw_100.jpg");
        json.put("notify_url", (Object)"http://httpbin.org/post");
        array.put((Object)json);
        paramsMap.put("apps", array);
        System.out.println(uploader.upload(paramsMap, file));
    }
}

