/*
 * Decompiled with CFR 0.152.
 */
package main.java.com.upyun;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import main.java.com.upyun.Base64Coder;
import main.java.com.upyun.Result;
import main.java.com.upyun.UpYunUtils;
import org.json.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncProcessHandler {
    public static String HOST = "http://p0.api.upyun.com/";
    protected final String AUTHORIZATION = "Authorization";
    protected final String DATE = "Date";
    protected String bucketName = null;
    protected String userName = null;
    protected String password = null;
    protected int timeout = 30000;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected Result process(Map<String, Object> params) throws IOException {
        params.put("tasks", Base64Coder.encodeString(params.get("tasks").toString()));
        InputStream is = null;
        URL url = new URL(HOST + "pretreatment/");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(this.timeout);
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("User-Agent", "upyun-java-sdk/3.8");
        conn.setRequestProperty("Date", this.getGMTDate());
        conn.setRequestProperty("Authorization", this.sign(params));
        conn.connect();
        OutputStream os = conn.getOutputStream();
        for (Map.Entry<String, Object> mapping : params.entrySet()) {
            os.write((mapping.getKey() + "=" + mapping.getValue().toString() + "&").getBytes("UTF-8"));
        }
        Result result = this.getResp(conn);
        if (os != null) {
            os.close();
        }
        if (is != null) {
            is.close();
        }
        if (conn != null) {
            conn.disconnect();
        }
        return result;
    }

    public AsyncProcessHandler(String bucketName, String userName, String password) {
        this.bucketName = bucketName;
        this.userName = userName;
        this.password = UpYunUtils.md5(password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result getResp(HttpURLConnection conn) throws IOException {
        Result result = new Result();
        StringBuilder text = new StringBuilder();
        InputStream is = null;
        InputStreamReader sr = null;
        BufferedReader br = null;
        int code = conn.getResponseCode();
        result.setCode(code);
        try {
            is = code >= 400 ? conn.getErrorStream() : conn.getInputStream();
            sr = new InputStreamReader(is);
            br = new BufferedReader(sr);
            char[] chars = new char[4096];
            int length = 0;
            while ((length = br.read(chars)) != -1) {
                text.append(chars, 0, length);
            }
        }
        finally {
            if (br != null) {
                br.close();
                br = null;
            }
            if (sr != null) {
                sr.close();
                sr = null;
            }
            if (is != null) {
                is.close();
                is = null;
            }
        }
        if (code == 200) {
            result.setSucceed(true);
        } else {
            result.setSucceed(false);
        }
        result.setMsg(text.toString());
        return result;
    }

    protected String sign(Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Map.Entry<String, Object>> list = new ArrayList<Map.Entry<String, Object>>(params.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry entry : list) {
            sb.append((String)entry.getKey() + entry.getValue());
        }
        String sign = this.userName + sb.toString() + this.password;
        return "UpYun " + this.userName + ":" + UpYunUtils.md5(sign);
    }

    protected String getGMTDate() {
        SimpleDateFormat formater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        formater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formater.format(new Date());
    }

    public String[] getTaskId(String raw) {
        JSONArray array = new JSONArray(raw);
        String[] ids = new String[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            ids[i] = (String)array.get(i);
        }
        return ids;
    }
}

