/*
 * Decompiled with CFR 0.152.
 */
package main.java.com;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpYun {
    private static final String UTF8 = "UTF-8";
    private final String VERSION = "2.0";
    private final String SEPARATOR = "/";
    private final String AUTHORIZATION = "Authorization";
    private final String DATE = "Date";
    private final String CONTENT_LENGTH = "Content-Length";
    private final String CONTENT_MD5 = "Content-MD5";
    private final String CONTENT_SECRET = "Content-Secret";
    private final String MKDIR = "mkdir";
    private final String X_UPYUN_WIDTH = "x-upyun-width";
    private final String X_UPYUN_HEIGHT = "x-upyun-height";
    private final String X_UPYUN_FRAMES = "x-upyun-frames";
    private final String X_UPYUN_FILE_TYPE = "x-upyun-file-type";
    private final String X_UPYUN_FILE_SIZE = "x-upyun-file-size";
    private final String X_UPYUN_FILE_DATE = "x-upyun-file-date";
    private final String METHOD_HEAD = "HEAD";
    private final String METHOD_GET = "GET";
    private final String METHOD_PUT = "PUT";
    private final String METHOD_DELETE = "DELETE";
    public static final String ED_AUTO = "v0.api.upyun.com";
    public static final String ED_TELECOM = "v1.api.upyun.com";
    public static final String ED_CNC = "v2.api.upyun.com";
    public static final String ED_CTT = "v3.api.upyun.com";
    public boolean debug = false;
    private int timeout = 30000;
    private String apiDomain = "v0.api.upyun.com";
    private String contentMD5 = null;
    private String fileSecret = null;
    protected String bucketName = null;
    protected String userName = null;
    protected String password = null;
    protected String picWidth = null;
    protected String picHeight = null;
    protected String picFrames = null;
    protected String picType = null;
    protected String fileType = null;
    protected String fileSize = null;
    protected String fileDate = null;

    public UpYun(String bucketName, String userName, String password) {
        this.bucketName = bucketName;
        this.userName = userName;
        this.password = UpYun.md5(password);
    }

    public void setApiDomain(String domain) {
        this.apiDomain = domain;
    }

    public String getApiDomain() {
        return this.apiDomain;
    }

    public void setTimeout(int second) {
        this.timeout = second * 1000;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setContentMD5(String md5Value) {
        this.contentMD5 = md5Value;
    }

    public void setFileSecret(String secret) {
        this.fileSecret = secret;
    }

    public String getPicWidth() {
        return this.picWidth;
    }

    public String getPicHeight() {
        return this.picHeight;
    }

    public String getPicFrames() {
        return this.picFrames;
    }

    public String getPicType() {
        return this.picType;
    }

    public String version() {
        return "2.0";
    }

    public long getBucketUsage() {
        long usage = -1L;
        String result = this.HttpAction("GET", this.formatPath("/") + "/?usage");
        if (!this.isEmpty(result)) {
            try {
                usage = Long.parseLong(result.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return usage;
    }

    @Deprecated
    public long getFolderUsage(String path) {
        long usage = -1L;
        String result = this.HttpAction("GET", this.formatPath(path) + "/?usage");
        if (!this.isEmpty(result)) {
            try {
                usage = Long.parseLong(result.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return usage;
    }

    public boolean writeFile(String filePath, byte[] datas) {
        return this.writeFile(filePath, datas, false, null);
    }

    public boolean writeFile(String filePath, byte[] datas, boolean auto) {
        return this.writeFile(filePath, datas, auto, null);
    }

    public boolean writeFile(String filePath, byte[] datas, boolean auto, Map<String, String> params) {
        return this.HttpAction("PUT", this.formatPath(filePath), datas, null, auto, params) != null;
    }

    public boolean writeFile(String filePath, String datas) {
        return this.writeFile(filePath, datas, false, null);
    }

    public boolean writeFile(String filePath, String datas, boolean auto) {
        return this.writeFile(filePath, datas, auto, null);
    }

    public boolean writeFile(String filePath, String datas, boolean auto, Map<String, String> params) {
        boolean result = false;
        try {
            result = this.writeFile(filePath, datas.getBytes(UTF8), auto, params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean writeFile(String filePath, File file) throws IOException {
        return this.writeFile(filePath, file, false, null);
    }

    public boolean writeFile(String filePath, File file, boolean auto) throws IOException {
        return this.writeFile(filePath, file, auto, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeFile(String filePath, File file, boolean auto, Map<String, String> params) throws IOException {
        filePath = this.formatPath(filePath);
        FileInputStream is = null;
        OutputStream os = null;
        HttpURLConnection conn = null;
        try {
            is = new FileInputStream(file);
            URL url = new URL("http://" + this.apiDomain + filePath);
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(this.timeout);
            conn.setRequestMethod("PUT");
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            conn.setChunkedStreamingMode(0);
            conn.setRequestProperty("Date", this.getGMTDate());
            conn.setRequestProperty("Authorization", this.sign(conn, filePath, file.length()));
            if (!this.isEmpty(this.contentMD5)) {
                conn.setRequestProperty("Content-MD5", this.contentMD5);
                this.contentMD5 = null;
            }
            if (!this.isEmpty(this.fileSecret)) {
                conn.setRequestProperty("Content-Secret", this.fileSecret);
                this.fileSecret = null;
            }
            if (auto) {
                conn.setRequestProperty("mkdir", "true");
            }
            if (params != null && !params.isEmpty()) {
                for (Map.Entry<String, String> param : params.entrySet()) {
                    conn.setRequestProperty(param.getKey(), param.getValue());
                }
            }
            conn.connect();
            os = conn.getOutputStream();
            byte[] data = new byte[4096];
            int temp = 0;
            while ((temp = ((InputStream)is).read(data)) != -1) {
                os.write(data, 0, temp);
            }
            this.getText(conn, false);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            if (this.debug) {
                e.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (os != null) {
                os.close();
                os = null;
            }
            if (is != null) {
                ((InputStream)is).close();
                is = null;
            }
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
    }

    public String readFile(String filePath) {
        return this.HttpAction("GET", this.formatPath(filePath));
    }

    public boolean readFile(String filePath, File file) {
        String result = this.HttpAction("GET", this.formatPath(filePath), null, file, false);
        return "".equals(result);
    }

    public Map<String, String> getFileInfo(String filePath) {
        this.HttpAction("HEAD", this.formatPath(filePath));
        if (this.isEmpty(this.fileType) && this.isEmpty(this.fileSize) && this.isEmpty(this.fileDate)) {
            return null;
        }
        HashMap<String, String> mp = new HashMap<String, String>();
        mp.put("type", this.fileType);
        mp.put("size", this.fileSize);
        mp.put("date", this.fileDate);
        return mp;
    }

    public boolean deleteFile(String filePath) {
        return this.HttpAction("DELETE", this.formatPath(filePath)) != null;
    }

    public boolean mkDir(String path) {
        return this.mkDir(path, false);
    }

    public boolean mkDir(String path, boolean auto) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put(PARAMS.KEY_MAKE_DIR.getValue(), "true");
        String result = this.HttpAction("PUT", this.formatPath(path), null, null, auto, params);
        return result != null;
    }

    public List<FolderItem> readDir(String path) {
        String result = this.HttpAction("GET", this.formatPath(path) + "/");
        if (this.isEmpty(result)) {
            return null;
        }
        LinkedList<FolderItem> list = new LinkedList<FolderItem>();
        String[] datas = result.split("\n");
        for (int i = 0; i < datas.length; ++i) {
            if (datas[i].indexOf("\t") <= 0) continue;
            list.add(new FolderItem(datas[i]));
        }
        return list;
    }

    public boolean rmDir(String path) {
        return this.HttpAction("DELETE", this.formatPath(path)) != null;
    }

    public String getWritedFileInfo(String key) {
        if (this.isEmpty(this.picWidth)) {
            return null;
        }
        if ("x-upyun-width".equals(key)) {
            return this.picWidth;
        }
        if ("x-upyun-height".equals(key)) {
            return this.picHeight;
        }
        if ("x-upyun-frames".equals(key)) {
            return this.picFrames;
        }
        if ("x-upyun-file-type".equals(key)) {
            return this.picType;
        }
        return null;
    }

    public static String md5(String str) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            md5.update(str.getBytes(UTF8));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        byte[] encodedValue = md5.digest();
        int j = encodedValue.length;
        char[] finalValue = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; ++i) {
            byte encoded = encodedValue[i];
            finalValue[k++] = hexDigits[encoded >> 4 & 0xF];
            finalValue[k++] = hexDigits[encoded & 0xF];
        }
        return new String(finalValue);
    }

    public static String md5(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            int n = 0;
            byte[] buffer = new byte[1024];
            do {
                if ((n = is.read(buffer)) <= 0) continue;
                md5.update(buffer, 0, n);
            } while (n != -1);
            is.skip(0L);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        finally {
            is.close();
        }
        byte[] encodedValue = md5.digest();
        int j = encodedValue.length;
        char[] finalValue = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; ++i) {
            byte encoded = encodedValue[i];
            finalValue[k++] = hexDigits[encoded >> 4 & 0xF];
            finalValue[k++] = hexDigits[encoded & 0xF];
        }
        return new String(finalValue);
    }

    private String getGMTDate() {
        SimpleDateFormat formater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        formater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formater.format(new Date());
    }

    private String sign(HttpURLConnection conn, String uri, long length) {
        String sign = conn.getRequestMethod() + "&" + uri + "&" + conn.getRequestProperty("Date") + "&" + length + "&" + this.password;
        return "UpYun " + this.userName + ":" + UpYun.md5(sign);
    }

    private String HttpAction(String method, String uri) {
        return this.HttpAction(method, uri, null, null, false);
    }

    private String HttpAction(String method, String uri, byte[] datas, File outFile, boolean auto) {
        return this.HttpAction(method, uri, datas, outFile, auto, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String HttpAction(String method, String uri, byte[] datas, File outFile, boolean auto, Map<String, String> params) {
        String result = null;
        HttpURLConnection conn = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            URL url = new URL("http://" + this.apiDomain + uri);
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(this.timeout);
            conn.setRequestMethod(method);
            conn.setUseCaches(false);
            if (!(method.equals("DELETE") || method.equals("HEAD") || method.equals("GET"))) {
                conn.setDoOutput(true);
            }
            conn.setRequestProperty("Date", this.getGMTDate());
            if (auto) {
                conn.setRequestProperty("mkdir", "true");
            }
            long contentLength = 0L;
            if (datas == null) {
                conn.setRequestProperty("Content-Length", "0");
            } else {
                contentLength = datas.length;
                conn.setRequestProperty("Content-Length", String.valueOf(datas.length));
                if (!this.isEmpty(this.contentMD5)) {
                    conn.setRequestProperty("Content-MD5", this.contentMD5);
                    this.contentMD5 = null;
                }
                if (!this.isEmpty(this.fileSecret)) {
                    conn.setRequestProperty("Content-Secret", this.fileSecret);
                    this.fileSecret = null;
                }
            }
            conn.setRequestProperty("Authorization", this.sign(conn, uri, contentLength));
            boolean isFolder = false;
            if (params != null && !params.isEmpty()) {
                isFolder = !this.isEmpty(params.get(PARAMS.KEY_MAKE_DIR.getValue()));
                for (Map.Entry<String, String> param : params.entrySet()) {
                    conn.setRequestProperty(param.getKey(), param.getValue());
                }
            }
            conn.connect();
            if (datas != null) {
                os = conn.getOutputStream();
                os.write(datas);
                os.flush();
            }
            if (isFolder) {
                os = conn.getOutputStream();
                os.flush();
            }
            if (outFile == null) {
                result = this.getText(conn, "HEAD".equals(method));
            } else {
                result = "";
                os = new FileOutputStream(outFile);
                byte[] data = new byte[4096];
                int temp = 0;
                is = conn.getInputStream();
                while ((temp = is.read(data)) != -1) {
                    os.write(data, 0, temp);
                }
            }
        }
        catch (IOException e) {
            if (this.debug) {
                e.printStackTrace();
            }
            String string = null;
            return string;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                    os = null;
                }
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getText(HttpURLConnection conn, boolean isHeadMethod) throws IOException {
        StringBuilder text = new StringBuilder();
        this.fileType = null;
        InputStream is = null;
        InputStreamReader sr = null;
        BufferedReader br = null;
        int code = conn.getResponseCode();
        try {
            InputStream inputStream = is = code >= 400 ? conn.getErrorStream() : conn.getInputStream();
            if (!isHeadMethod) {
                sr = new InputStreamReader(is);
                br = new BufferedReader(sr);
                char[] chars = new char[4096];
                int length = 0;
                while ((length = br.read(chars)) != -1) {
                    text.append(chars, 0, length);
                }
            }
            if (200 == code && conn.getHeaderField("x-upyun-width") != null) {
                this.picWidth = conn.getHeaderField("x-upyun-width");
                this.picHeight = conn.getHeaderField("x-upyun-height");
                this.picFrames = conn.getHeaderField("x-upyun-frames");
                this.picType = conn.getHeaderField("x-upyun-file-type");
            } else {
                this.picType = null;
                this.picFrames = null;
                this.picHeight = null;
                this.picWidth = null;
            }
            if (200 == code && conn.getHeaderField("x-upyun-file-type") != null) {
                this.fileType = conn.getHeaderField("x-upyun-file-type");
                this.fileSize = conn.getHeaderField("x-upyun-file-size");
                this.fileDate = conn.getHeaderField("x-upyun-file-date");
            } else {
                this.fileDate = null;
                this.fileSize = null;
                this.fileType = null;
            }
        }
        finally {
            if (br != null) {
                br.close();
                br = null;
            }
            if (sr != null) {
                sr.close();
                sr = null;
            }
            if (is != null) {
                is.close();
                is = null;
            }
        }
        if (isHeadMethod) {
            if (code >= 400) {
                return null;
            }
            return "";
        }
        if (code >= 400) {
            throw new IOException(text.toString());
        }
        return text.toString();
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private String formatPath(String path) {
        if (!this.isEmpty(path) && !(path = path.trim()).startsWith("/")) {
            return "/" + this.bucketName + "/" + path;
        }
        return "/" + this.bucketName + path;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PARAMS {
        KEY_X_GMKERL_TYPE("x-gmkerl-type"),
        KEY_X_GMKERL_VALUE("x-gmkerl-value"),
        KEY_X_GMKERL_QUALITY("x-gmkerl-quality"),
        KEY_X_GMKERL_UNSHARP("x-gmkerl-unsharp"),
        KEY_X_GMKERL_THUMBNAIL("x-gmkerl-thumbnail"),
        KEY_X_GMKERL_ROTATE("x-gmkerl-rotate"),
        KEY_X_GMKERL_CROP("x-gmkerl-crop"),
        KEY_X_GMKERL_EXIF_SWITCH("x-gmkerl-exif-switch"),
        KEY_MAKE_DIR("folder"),
        VALUE_FIX_MAX("fix_max"),
        VALUE_FIX_MIN("fix_min"),
        VALUE_FIX_WIDTH_OR_HEIGHT("fix_width_or_height"),
        VALUE_FIX_WIDTH("fix_width"),
        VALUE_FIX_HEIGHT("fix_height"),
        VALUE_SQUARE("square"),
        VALUE_FIX_BOTH("fix_both"),
        VALUE_FIX_SCALE("fix_scale"),
        VALUE_ROTATE_AUTO("auto"),
        VALUE_ROTATE_90("90"),
        VALUE_ROTATE_180("180"),
        VALUE_ROTATE_270("270");

        private final String value;

        private PARAMS(String val) {
            this.value = val;
        }

        public String getValue() {
            return this.value;
        }
    }

    public class FolderItem {
        public String name;
        public String type;
        public long size;
        public Date date;

        public FolderItem(String data) {
            String[] a = data.split("\t");
            if (a.length == 4) {
                this.name = a[0];
                this.type = "N".equals(a[1]) ? "File" : "Folder";
                try {
                    this.size = Long.parseLong(a[2].trim());
                }
                catch (NumberFormatException e) {
                    this.size = -1L;
                }
                long da = 0L;
                try {
                    da = Long.parseLong(a[3].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.date = new Date(da * 1000L);
            }
        }

        public String toString() {
            return "time = " + this.date + "  size = " + this.size + "  type = " + this.type + "  name = " + this.name;
        }
    }
}

