/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cosapi.sign;

import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonCodecUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommonCodecUtils.class);
    private static final String HMAC_SHA1 = "HmacSHA1";

    public static String Base64Encode(byte[] binaryData) {
        String encodedstr = Base64.encodeBase64String((byte[])binaryData);
        return encodedstr;
    }

    public static String HashMd5(byte[] binaryData) {
        String md5Digest = DigestUtils.md5Hex((byte[])binaryData);
        return md5Digest;
    }

    public static String getFileSha1(byte[] fileContent) {
        String sha1Digest = DigestUtils.sha1Hex((byte[])fileContent);
        return sha1Digest;
    }

    public static String getFileSha1(InputStream fileInputStream) throws Exception {
        String sha1Digest = DigestUtils.sha1Hex((InputStream)fileInputStream);
        return sha1Digest;
    }

    public static byte[] HmacSha1(byte[] binaryData, String key) {
        Mac mac = null;
        try {
            mac = Mac.getInstance(HMAC_SHA1);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("mac not find algorithm {}", (Object)HMAC_SHA1);
            return null;
        }
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), HMAC_SHA1);
        try {
            mac.init(secretKey);
        }
        catch (InvalidKeyException e) {
            LOG.error("mac init key {} occur a error {}", (Object)key, (Object)e.toString());
            return null;
        }
        byte[] HmacSha1Digest = null;
        try {
            HmacSha1Digest = mac.doFinal(binaryData);
        }
        catch (IllegalStateException e) {
            LOG.error("mac.doFinal occur a error {}", (Object)e.toString());
        }
        return HmacSha1Digest;
    }

    public static byte[] HmacSha1(String plainText, String key) {
        return CommonCodecUtils.HmacSha1(plainText.getBytes(), key);
    }
}

