/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cosapi.http;

import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;

public final class IdleConnectionMonitorThread
extends Thread {
    private final HttpClientConnectionManager connMgr;
    private volatile boolean shutdown;
    private static final int MONITOR_INTERVAL_MS = 2000;
    private static final int IDLE_ALIVE_MS = 5000;

    public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr) {
        this.connMgr = connMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.shutdown) {
                IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                synchronized (idleConnectionMonitorThread) {
                    this.wait(2000L);
                    this.connMgr.closeExpiredConnections();
                    this.connMgr.closeIdleConnections(5000L, TimeUnit.MILLISECONDS);
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        IdleConnectionMonitorThread idleConnectionMonitorThread = this;
        synchronized (idleConnectionMonitorThread) {
            this.notifyAll();
        }
    }
}

