/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cosapi.api;

import com.qcloud.cosapi.file.FileProcess;
import com.qcloud.cosapi.http.HttpSender;
import com.qcloud.cosapi.sign.CommonCodecUtils;
import com.qcloud.cosapi.sign.Sign;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosCloud {
    private static final Logger LOG = LoggerFactory.getLogger(CosCloud.class);
    private static final String COSAPI_CGI_URL = "http://web.file.myqcloud.com/files/v1";
    private static final int DEFAULT_TIMEOUT_IN_SECONDS = 60;
    private static final String PATH_DELIMITER = "/";
    private static final int DEFAULT_SIGN_EXPIRED_IN_SECONDS = 1800;
    private static final int DEFAULT_SLICE_LEN = 524288;
    private static final int SLICE_UPLOAD_RETRY_COUNT = 3;
    private static final int THREAD_POOL_SIZE = 20;
    private final ExecutorService executorService = Executors.newFixedThreadPool(20);
    private static final int MAX_WAIT_TIME_PARALL_SEND_FILE = 1800;
    private HttpSender httpSender = null;
    private int appId;
    private String secretId;
    private String secretKey;
    private int timeOut;

    public CosCloud(int appId, String secretId, String secretKey) {
        this(appId, secretId, secretKey, 60);
    }

    public CosCloud(int appId, String secretId, String secretKey, int timeOut) {
        this.appId = appId;
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.timeOut = timeOut;
        this.httpSender = new HttpSender();
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    private boolean isRootPath(String remotePath) {
        return remotePath.equals(PATH_DELIMITER);
    }

    private String getEncodedCosUrl(String bucketName, String remotePath) {
        String cosUrl = PATH_DELIMITER + this.appId + PATH_DELIMITER + bucketName + PATH_DELIMITER + remotePath;
        return COSAPI_CGI_URL + this.encodeRemotePath(cosUrl);
    }

    private String encodeRemotePath(String remotePath) {
        String[] pathSegmentsArr = remotePath.split(PATH_DELIMITER);
        StringBuilder pathBuilder = new StringBuilder();
        for (String pathSegment : pathSegmentsArr) {
            if (pathSegment.trim().isEmpty()) continue;
            try {
                pathBuilder.append(PATH_DELIMITER).append(URLEncoder.encode(pathSegment.trim(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("Unsupported ecnode exception", (Throwable)e);
            }
        }
        if (remotePath.endsWith(PATH_DELIMITER)) {
            pathBuilder.append(PATH_DELIMITER);
        }
        return pathBuilder.toString();
    }

    private String formatPath(String remotePath) {
        String[] pathSegmentsArr = remotePath.split(PATH_DELIMITER);
        StringBuilder pathBuilder = new StringBuilder();
        for (String pathSegment : pathSegmentsArr) {
            String trimedPathSegment = pathSegment.trim();
            if (trimedPathSegment.isEmpty()) continue;
            pathBuilder.append(PATH_DELIMITER).append(trimedPathSegment);
        }
        if (remotePath.endsWith(PATH_DELIMITER)) {
            pathBuilder.append(PATH_DELIMITER);
        }
        return pathBuilder.toString();
    }

    public String updateFolder(String bucketName, String remotePath, String bizAttribute) throws Exception {
        remotePath = this.formatPath(remotePath);
        return this.updateFile(bucketName, remotePath, bizAttribute);
    }

    public String updateFile(String bucketName, String remotePath, String bizAttribute) throws Exception {
        if (this.isRootPath(remotePath = this.formatPath(remotePath))) {
            String errorMsg = "update bucket only allowed by http://console.qcloud.com/cos!";
            LOG.error(errorMsg);
            JSONObject errorRet = new JSONObject();
            errorRet.put("code", -1);
            errorRet.put("message", (Object)errorMsg);
            return errorRet.toString();
        }
        String url = this.getEncodedCosUrl(bucketName, remotePath);
        HashMap<String, String> updateData = new HashMap<String, String>();
        updateData.put("op", "update");
        updateData.put("biz_attr", bizAttribute);
        String sign = Sign.appSignatureOnce(this.appId, this.secretId, this.secretKey, remotePath, bucketName);
        HashMap<String, String> httpHeader = new HashMap<String, String>();
        httpHeader.put("Authorization", sign);
        httpHeader.put("Content-Type", "application/json");
        return this.httpSender.sendJsonRequest(url, httpHeader, updateData, this.timeOut);
    }

    public String deleteFolder(String bucketName, String remotePath) throws Exception {
        remotePath = this.formatPath(remotePath);
        return this.deleteFile(bucketName, remotePath);
    }

    public String deleteFile(String bucketName, String remotePath) throws Exception {
        if (this.isRootPath(remotePath = this.formatPath(remotePath))) {
            String errorMsg = "delete bucket only allowed by http://console.qcloud.com/cos!";
            LOG.error(errorMsg);
            JSONObject errorRet = new JSONObject();
            errorRet.put("code", -1);
            errorRet.put("message", (Object)errorMsg);
            return errorRet.toString();
        }
        String url = this.getEncodedCosUrl(bucketName, remotePath);
        HashMap<String, String> postBody = new HashMap<String, String>();
        postBody.put("op", "delete");
        String sign = Sign.appSignatureOnce(this.appId, this.secretId, this.secretKey, remotePath, bucketName);
        HashMap<String, String> httpHeader = new HashMap<String, String>();
        httpHeader.put("Authorization", sign);
        httpHeader.put("Content-Type", "application/json");
        return this.httpSender.sendJsonRequest(url, httpHeader, postBody, this.timeOut);
    }

    public String getFolderStat(String bucketName, String remotePath) throws Exception {
        remotePath = this.formatPath(remotePath);
        return this.getFileStat(bucketName, remotePath);
    }

    public String getFileStat(String bucketName, String remotePath) throws Exception {
        String url = this.getEncodedCosUrl(bucketName, remotePath);
        long expired = this.getExpiredTimeInSec();
        String sign = Sign.appSignature(this.appId, this.secretId, this.secretKey, expired, bucketName);
        HashMap<String, String> getBody = new HashMap<String, String>();
        getBody.put("op", "stat");
        HashMap<String, String> httpHeader = new HashMap<String, String>();
        httpHeader.put("Authorization", sign);
        return this.httpSender.sendGetRequest(url, httpHeader, getBody, this.timeOut);
    }

    public String createFolder(String bucketName, String remotePath) throws Exception {
        if (this.isRootPath(remotePath = this.formatPath(remotePath))) {
            String errorMsg = "create bucket only allowed by http://console.qcloud.com/cos!";
            LOG.error(errorMsg);
            JSONObject errorRet = new JSONObject();
            errorRet.put("code", -1);
            errorRet.put("message", (Object)errorMsg);
            return errorRet.toString();
        }
        String url = this.getEncodedCosUrl(bucketName, remotePath);
        long expired = this.getExpiredTimeInSec();
        String sign = Sign.appSignature(this.appId, this.secretId, this.secretKey, expired, bucketName);
        HashMap<String, String> postBody = new HashMap<String, String>();
        postBody.put("op", "create");
        HashMap<String, String> httpHeader = new HashMap<String, String>();
        httpHeader.put("Authorization", sign);
        httpHeader.put("Content-Type", "application/json");
        return this.httpSender.sendJsonRequest(url, httpHeader, postBody, this.timeOut);
    }

    private String getPatternString(FolderPattern pattern) {
        String patternStr = null;
        switch (pattern) {
            case File: {
                patternStr = "eListFileOnly";
                break;
            }
            case Folder: {
                patternStr = "eListDirOnly";
                break;
            }
            default: {
                patternStr = "eListBoth";
            }
        }
        return patternStr;
    }

    public String getFolderList(String bucketName, String remotePath, int num, String context, int order, FolderPattern pattern) throws Exception {
        remotePath = this.formatPath(remotePath);
        return this.getFolderList(bucketName, remotePath, "", num, context, order, pattern);
    }

    public String getFolderList(String bucketName, String remotePath, String prefix, int num, String context, int order, FolderPattern pattern) throws Exception {
        remotePath = remotePath + PATH_DELIMITER + prefix;
        remotePath = this.formatPath(remotePath);
        String url = this.getEncodedCosUrl(bucketName, remotePath);
        long expiredTimeInSec = this.getExpiredTimeInSec();
        String sign = Sign.appSignature(this.appId, this.secretId, this.secretKey, expiredTimeInSec, bucketName);
        HashMap<String, String> getBody = new HashMap<String, String>();
        getBody.put("op", "list");
        getBody.put("num", String.valueOf(num));
        getBody.put("context", context);
        getBody.put("order", String.valueOf(order));
        getBody.put("pattern", this.getPatternString(pattern));
        HashMap<String, String> httpHeader = new HashMap<String, String>();
        httpHeader.put("Authorization", sign);
        return this.httpSender.sendGetRequest(url, httpHeader, getBody, this.timeOut);
    }

    public String uploadFile(String bucketName, String remotePath, String localPath) throws Exception {
        if (!FileProcess.isLegalFile(localPath)) {
            String errorMsg = localPath + " is not file or not exist or can't be read!";
            LOG.error(errorMsg);
            JSONObject errorRet = new JSONObject();
            errorRet.put("code", -1);
            errorRet.put("message", (Object)errorMsg);
            return errorRet.toString();
        }
        FileInputStream localFileInputStream = null;
        try {
            localFileInputStream = FileProcess.getFileInputStream(localPath);
            String errorRet = this.uploadFile(bucketName, remotePath, localFileInputStream);
            return errorRet;
        }
        catch (Exception e) {
            LOG.error("UploadFile {} occur a error {}", (Object)localPath, (Object)e.toString());
            throw e;
        }
        finally {
            FileProcess.closeFileStream(localFileInputStream, localPath);
        }
    }

    public String uploadFile(String bucketName, String remotePath, InputStream inputStream) throws Exception {
        String url = this.getEncodedCosUrl(bucketName, remotePath);
        byte[] fileContent = FileProcess.getFileContent(inputStream);
        String shaDigest = CommonCodecUtils.getFileSha1(fileContent);
        HashMap<String, String> postData = new HashMap<String, String>();
        postData.put("op", "upload");
        postData.put("sha", shaDigest);
        long expired = this.getExpiredTimeInSec();
        String sign = Sign.appSignature(this.appId, this.secretId, this.secretKey, expired, bucketName);
        HashMap<String, String> httpHeader = new HashMap<String, String>();
        httpHeader.put("Authorization", sign);
        return this.httpSender.sendFileRequest(url, httpHeader, postData, fileContent, this.timeOut);
    }

    public String sliceUploadFile(String bucketName, String remotePath, String localPath) throws Exception {
        return this.sliceUploadFile(bucketName, remotePath, localPath, 524288);
    }

    public String sliceUploadFile(String bucketName, String remotePath, String localPath, int sliceSize) throws Exception {
        if (!FileProcess.isLegalFile(localPath)) {
            String errorMsg = localPath + " is not file or not exist or can't be read!";
            LOG.error(errorMsg);
            JSONObject errorRet = new JSONObject();
            errorRet.put("code", -1);
            errorRet.put("message", (Object)errorMsg);
            return errorRet.toString();
        }
        String url = this.getEncodedCosUrl(bucketName, remotePath);
        JSONObject sliceControlResult = this.sliceUploadFileControlCmd(url, bucketName, localPath, sliceSize);
        LOG.info("Slice upload first step:localfile {} remotePath {} result {}", new Object[]{localPath, remotePath, sliceControlResult});
        if (sliceControlResult.getInt("code") != 0) {
            return sliceControlResult.toString();
        }
        JSONObject controlDataMember = sliceControlResult.getJSONObject("data");
        if (controlDataMember.has("access_url")) {
            return sliceControlResult.toString();
        }
        String sessionId = controlDataMember.getString("session");
        sliceSize = controlDataMember.getInt("slice_size");
        long offset = controlDataMember.getLong("offset");
        return this.sliceUploadFileData(url, bucketName, sessionId, offset, sliceSize, localPath);
    }

    public String sliceUploadFileParallel(String bucketName, String remotePath, String localPath, int sliceSize) throws Exception {
        if (!FileProcess.isLegalFile(localPath)) {
            String errorMsg = localPath + " is not file or not exist or can't be read!";
            LOG.error(errorMsg);
            JSONObject errorRet = new JSONObject();
            errorRet.put("code", -1);
            errorRet.put("message", (Object)errorMsg);
            return errorRet.toString();
        }
        String url = this.getEncodedCosUrl(bucketName, remotePath);
        JSONObject resultJson = this.sliceUploadFileControlCmd(url, bucketName, localPath, sliceSize);
        if (resultJson.getInt("code") != 0) {
            return resultJson.toString();
        }
        JSONObject data = resultJson.getJSONObject("data");
        if (data.has("access_url")) {
            return resultJson.toString();
        }
        String sessionId = data.getString("session");
        sliceSize = data.getInt("slice_size");
        long fileLen = FileProcess.getFileLength(localPath);
        ArrayList<FutureTask<JSONObject>> futureTasks = new ArrayList<FutureTask<JSONObject>>();
        ArrayList<SliceUploadInner> sliceUploadInners = new ArrayList<SliceUploadInner>();
        for (long offset = data.getLong("offset"); offset < fileLen; offset += (long)sliceSize) {
            SliceUploadInner sliceUploadInner = new SliceUploadInner(url, bucketName, localPath, sessionId, offset, sliceSize);
            sliceUploadInners.add(sliceUploadInner);
            FutureTask<JSONObject> task = new FutureTask<JSONObject>(sliceUploadInner);
            futureTasks.add(task);
        }
        CountDownLatch doneSignal = new CountDownLatch(futureTasks.size());
        for (SliceUploadInner sliceUploadInner : sliceUploadInners) {
            sliceUploadInner.setCountDownLatch(doneSignal);
        }
        for (FutureTask futureTask : futureTasks) {
            this.executorService.execute(futureTask);
        }
        if (!doneSignal.await(1800L, TimeUnit.SECONDS)) {
            String errMsg = "sliceUpload File parallel" + localPath + " time out!";
            LOG.error(errMsg);
            throw new Exception("slice uploadFile parall time out");
        }
        Iterator it = futureTasks.iterator();
        Object var17_20 = null;
        String uploadParaRet = "";
        while (it.hasNext()) {
            FutureTask task = (FutureTask)it.next();
            try {
                JSONObject jSONObject = (JSONObject)task.get();
                if (jSONObject.getInt("code") != 0) {
                    return jSONObject.toString();
                }
                JSONObject dataJson = jSONObject.getJSONObject("data");
                if (dataJson.has("access_url")) {
                    return jSONObject.toString();
                }
                uploadParaRet = jSONObject.toString();
            }
            catch (Exception e) {
                LOG.error("task execute occur a exception {}", (Object)e.toString());
                throw e;
            }
        }
        return uploadParaRet;
    }

    private JSONObject sliceUploadFileControlCmd(String url, String bucketName, String localPath, int sliceSize) throws Exception {
        long fileSize = FileProcess.getFileLength(localPath);
        String sha1Digest = FileProcess.getFileSha1(localPath);
        HashMap<String, String> postBody = new HashMap<String, String>();
        postBody.put("op", "upload_slice");
        postBody.put("sha", sha1Digest);
        postBody.put("filesize", String.valueOf(fileSize));
        postBody.put("slice_size", String.valueOf(sliceSize));
        long expired = this.getExpiredTimeInSec();
        String sign = Sign.appSignature(this.appId, this.secretId, this.secretKey, expired, bucketName);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", sign);
        String resultStr = this.httpSender.sendFileRequest(url, header, postBody, null, this.timeOut);
        try {
            JSONObject resultJson = new JSONObject(resultStr);
            return resultJson;
        }
        catch (JSONException e) {
            LOG.error("sendJsonResult return illegal json, result {}", (Object)resultStr);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String sliceUploadFileData(String url, String bucketName, String sessionId, long offset, int sliceSize, String localPath) throws Exception {
        block6: {
            inputStream = null;
            try {
                fileSize = FileProcess.getFileLength(localPath);
                inputStream = FileProcess.getFileInputStream(localPath);
                inputStream.skip(offset);
                resultJson = null;
                while (offset < fileSize) {
                    sliceContent = FileProcess.getFileContent(inputStream, 0L, sliceSize);
                    if (sliceContent == null) {
                        errMsg = "get FileSlicent content return empty, file:" + localPath + " offset:" + offset + " sliceSize" + sliceSize;
                        CosCloud.LOG.error(errMsg);
                        throw new Exception(errMsg);
                    }
                    resultJson = this.sliceUploadFileData(url, bucketName, sessionId, offset, sliceContent);
                    if (resultJson.getInt("code") == 0) {
                        offset += (long)sliceSize;
                        continue;
                    }
                    var13_12 = resultJson.toString();
                    break block6;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var14_13) {
                FileProcess.closeFileStream(inputStream, localPath);
                throw var14_13;
            }
        }
        FileProcess.closeFileStream(inputStream, localPath);
        return var13_12;
lbl-1000:
        // 1 sources

        {
            var12_10 = resultJson.toString();
        }
        FileProcess.closeFileStream(inputStream, localPath);
        return var12_10;
    }

    public JSONObject sliceUploadFileData(String url, String bucketName, String sessionId, long offset, byte[] sliceContent) throws Exception {
        HashMap<String, String> postBody = new HashMap<String, String>();
        postBody.put("op", "upload_slice");
        postBody.put("session", sessionId);
        postBody.put("offset", String.valueOf(offset));
        long expired = this.getExpiredTimeInSec();
        String sign = Sign.appSignature(this.appId, this.secretId, this.secretKey, expired, bucketName);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", sign);
        String resultStr = null;
        JSONObject resultJson = null;
        for (int retryCount = 0; retryCount < 3; ++retryCount) {
            resultStr = this.httpSender.sendFileRequest(url, header, postBody, sliceContent, this.timeOut);
            try {
                resultJson = new JSONObject(resultStr);
                if (resultJson.getInt("code") != 0) continue;
                return resultJson;
            }
            catch (JSONException e) {
                LOG.error("sendFileRequest result is not legal json, result {}", (Object)resultStr);
                throw e;
            }
        }
        return resultJson;
    }

    public void shutdown() {
        this.executorService.shutdown();
        this.httpSender.shutdown();
    }

    private long getExpiredTimeInSec() {
        return System.currentTimeMillis() / 1000L + 1800L;
    }

    private class SliceUploadInner
    implements Callable<JSONObject> {
        private String url;
        private String bucketName;
        private String localPath;
        private String sessionId;
        private long offset;
        private int sliceSize;
        CountDownLatch countDownLatch;

        public void setCountDownLatch(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        public SliceUploadInner(String url, String bucketName, String localPath, String sessionId, long offset, int sliceSize) {
            this.url = url;
            this.bucketName = bucketName;
            this.localPath = localPath;
            this.sessionId = sessionId;
            this.offset = offset;
            this.sliceSize = sliceSize;
        }

        @Override
        public JSONObject call() throws Exception {
            try {
                JSONObject resultJson;
                byte[] sliceContent = FileProcess.getFileContent(this.localPath, this.offset, this.sliceSize);
                JSONObject jSONObject = resultJson = CosCloud.this.sliceUploadFileData(this.url, this.bucketName, this.sessionId, this.offset, sliceContent);
                return jSONObject;
            }
            catch (Exception e) {
                String errMsg = "SliceUploadInner send file failed!" + " url:" + this.url + " bucketName:" + this.bucketName + " filePath:" + this.localPath + " offset:" + this.offset + " sliceSize:" + this.sliceSize;
                LOG.error(errMsg);
                throw e;
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }

    public static enum FolderPattern {
        File,
        Folder,
        Both;

    }
}

