/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.image.HeapHistogram;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedField;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;

public final class ObjectGroupHistogram {
    private final NativeImageHeap heap;
    private final Set<NativeImageHeap.ObjectInfo> objects;
    private final Map<NativeImageHeap.ObjectInfo, String> groups;
    private final Map<String, HeapHistogram> groupHistograms;

    public static void print(NativeImageHeap heap) {
        new ObjectGroupHistogram(heap).doPrint();
    }

    private ObjectGroupHistogram(NativeImageHeap heap) {
        this.heap = heap;
        this.groups = new HashMap<NativeImageHeap.ObjectInfo, String>();
        this.groupHistograms = new LinkedHashMap<String, HeapHistogram>();
        this.objects = new HashSet<NativeImageHeap.ObjectInfo>(heap.objects.size());
        for (NativeImageHeap.ObjectInfo info : heap.objects.values()) {
            this.objects.add(info);
        }
    }

    private static boolean filterCodeInfoObjects(NativeImageHeap.ObjectInfo info, int recursionLevel) {
        return recursionLevel <= 2;
    }

    private static boolean filterDynamicHubField(NativeImageHeap.ObjectInfo info, HostedField field) {
        if (info.getObject() instanceof DynamicHub) {
            return field.getName().equals("name") || field.getName().equals("assignableFromMatches") || field.getName().equals("pointerMapEncoding");
        }
        return true;
    }

    private static boolean filterGraalSupportObjects(NativeImageHeap.ObjectInfo info, int recursionLevel) {
        return recursionLevel <= 1;
    }

    private static boolean filterObjectConstantField(NativeImageHeap.ObjectInfo info, HostedField field) {
        if (info.getObject() instanceof SubstrateObjectConstant) {
            return !field.getName().equals("object");
        }
        return true;
    }

    private void doPrint() {
        this.processType(DynamicHub.class, "DynamicHub", true, null, ObjectGroupHistogram::filterDynamicHubField);
        this.processObject(DynamicHubSupport.getReferenceMapEncoding(), "DynamicHub", true, null, null);
        this.processObject(CodeInfoTable.getImageCodeCache(), "ImageCodeInfo", true, ObjectGroupHistogram::filterCodeInfoObjects, null);
        this.processObject(ObjectGroupHistogram.readGraalSupportField("graphEncoding"), "CompressedGraph", true, ObjectGroupHistogram::filterGraalSupportObjects, null);
        this.processObject(ObjectGroupHistogram.readGraalSupportField("graphObjects"), "CompressedGraph", true, ObjectGroupHistogram::filterGraalSupportObjects, null);
        this.processObject(ObjectGroupHistogram.readGraalSupportField("graphNodeTypes"), "CompressedGraph", true, ObjectGroupHistogram::filterGraalSupportObjects, null);
        this.processType(ResolvedJavaType.class, "Graal Metadata", false, null, null);
        this.processType(ResolvedJavaMethod.class, "Graal Metadata", false, null, null);
        this.processType(ResolvedJavaField.class, "Graal Metadata", false, null, null);
        try {
            Field field = Class.forName("com.oracle.svm.graal.SubstrateRuntimeProvider").getDeclaredField("graphObjects");
            Object object = SubstrateObjectConstant.asObject((Constant)this.heap.getMetaAccess().lookupJavaField(field).readValue(null));
            this.processObject(this.heap.objects.get(object), "CompressedGraphObjects", true, null, ObjectGroupHistogram::filterObjectConstantField);
        }
        catch (Throwable field) {
            // empty catch block
        }
        HeapHistogram totalHistogram = new HeapHistogram();
        for (NativeImageHeap.ObjectInfo objectInfo : this.objects) {
            totalHistogram.add(objectInfo, objectInfo.getSize());
            this.addToGroup(objectInfo, "Other");
        }
        totalHistogram.printHeadings("=== Total ===");
        totalHistogram.print();
        for (Map.Entry entry : this.groupHistograms.entrySet()) {
            ((HeapHistogram)entry.getValue()).printHeadings("=== " + (String)entry.getKey() + " ===");
            ((HeapHistogram)entry.getValue()).print();
        }
        System.out.println();
        System.out.println("=== Summary ===");
        for (Map.Entry entry : this.groupHistograms.entrySet()) {
            System.out.format("%s; %d; %d\n", entry.getKey(), ((HeapHistogram)entry.getValue()).getTotalCount(), ((HeapHistogram)entry.getValue()).getTotalSize());
        }
        System.out.format("%s; %d; %d\n", "Total", totalHistogram.getTotalCount(), totalHistogram.getTotalSize());
    }

    private static Object readGraalSupportField(String name) {
        try {
            Class<?> graalSupportClass = Class.forName("com.oracle.svm.graal.GraalSupport");
            Object graalSupport = ImageSingletons.lookup(graalSupportClass);
            Field field = graalSupportClass.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(graalSupport);
        }
        catch (Throwable ex) {
            System.out.println("Warning: cannot read field from GraalSupport: " + name);
            return null;
        }
    }

    public void processType(Class<?> clazz, String group2, boolean addObject, ObjectFilter objectFilter, FieldFilter fieldFilter) {
        for (NativeImageHeap.ObjectInfo info : this.objects) {
            if (!clazz.isInstance(info.getObject())) continue;
            this.processObject(info, group2, addObject, 1, objectFilter, fieldFilter);
        }
    }

    public void processObject(Object object, String group2, boolean addObject, ObjectFilter objectFilter, FieldFilter fieldFilter) {
        if (object != null) {
            this.processObject(this.heap.objects.get(object), group2, addObject, 1, objectFilter, fieldFilter);
        }
    }

    private void processObject(NativeImageHeap.ObjectInfo info, String group2, boolean addObject, int recursionLevel, ObjectFilter objectFilter, FieldFilter fieldFilter) {
        block6: {
            block5: {
                if (objectFilter != null && !objectFilter.test(info, recursionLevel)) {
                    return;
                }
                assert (info != null);
                if (addObject && !this.addToGroup(info, group2)) {
                    return;
                }
                if (!info.getClazz().isInstanceClass()) break block5;
                JavaConstant con = SubstrateObjectConstant.forObject(info.getObject());
                for (HostedField field : info.getClazz().getInstanceFields(true)) {
                    Object fieldValue;
                    if (field.getType().getStorageKind() != JavaKind.Object || HybridLayout.isHybridField(field) || !field.isAccessed() || fieldFilter != null && !fieldFilter.test(info, field) || (fieldValue = SubstrateObjectConstant.asObject((Constant)field.readStorageValue(con))) == null) continue;
                    this.processObject(this.heap.objects.get(fieldValue), group2, true, recursionLevel + 1, objectFilter, fieldFilter);
                }
                break block6;
            }
            if (!(info.getObject() instanceof Object[])) break block6;
            for (Object element : (Object[])info.getObject()) {
                if (element == null) continue;
                this.processObject(this.heap.objects.get(element), group2, true, recursionLevel + 1, objectFilter, fieldFilter);
            }
        }
    }

    private boolean addToGroup(NativeImageHeap.ObjectInfo info, String group2) {
        if (!this.groups.containsKey(info)) {
            this.groups.put(info, group2);
            HeapHistogram histogram = this.groupHistograms.get(group2);
            if (histogram == null) {
                histogram = new HeapHistogram();
                this.groupHistograms.put(group2, histogram);
            }
            histogram.add(info, info.getSize());
            return true;
        }
        return false;
    }

    public static interface FieldFilter {
        public boolean test(NativeImageHeap.ObjectInfo var1, HostedField var2);
    }

    public static interface ObjectFilter {
        public boolean test(NativeImageHeap.ObjectInfo var1, int var2);
    }
}

