/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.hosted.GraalFeature;
import java.lang.reflect.Field;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.debug.DebugContext;

@TargetClass(value=DebugContext.class, innerClass={"Immutable"}, onlyWith={GraalFeature.IsEnabled.class})
final class Target_org_graalvm_compiler_debug_DebugContext_Immutable {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClearImmutableCache.class)
    private static Target_org_graalvm_compiler_debug_DebugContext_Immutable[] CACHE;

    Target_org_graalvm_compiler_debug_DebugContext_Immutable() {
    }

    static class ClearImmutableCache
    implements RecomputeFieldValue.CustomFieldValueComputer {
        ClearImmutableCache() {
        }

        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            for (Class<?> c : DebugContext.class.getDeclaredClasses()) {
                if (!c.getSimpleName().equals("Immutable")) continue;
                try {
                    Field f = c.getDeclaredField("CACHE");
                    f.setAccessible(true);
                    Object[] cache = (Object[])f.get(null);
                    Object[] clearedCache = (Object[])cache.clone();
                    for (int i = 0; i < clearedCache.length; ++i) {
                        clearedCache[i] = null;
                    }
                    return clearedCache;
                }
                catch (Exception e) {
                    throw VMError.shouldNotReachHere("Cannot read value of " + DebugContext.class.getName() + ".Immutable.CACHE", e);
                }
            }
            throw VMError.shouldNotReachHere("Cannot find " + DebugContext.class.getName() + ".Immutable");
        }
    }
}

