/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapVerifierImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.heap.DiscoverableReference;
import com.oracle.svm.core.heap.FeebleReference;
import com.oracle.svm.core.heap.FeebleReferenceList;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class DiscoverableReferenceProcessing {
    public static void discoverDiscoverableReference(Object object) {
        Object obj = KnownIntrinsics.convertUnknownValue(object, Object.class);
        if (obj instanceof DiscoverableReference) {
            Log trace = Log.noopLog().string("[DiscoverableReference.discoverDiscoverableReference:");
            DiscoverableReference dr = (DiscoverableReference)obj;
            trace.string("  dr: ").object(dr);
            if (dr.isDiscoverableReferenceInitialized()) {
                if (trace.isEnabled()) {
                    trace.string("  referent: ").hex((WordBase)DiscoverableReference.TestingBackDoor.getReferentPointer(dr));
                }
                DiscoverableReferenceProcessing.addToDiscoveredReferences(dr);
            } else {
                trace.string("  uninitialized");
            }
            trace.string("]").newline();
        }
    }

    public static DiscoverableReference getDiscoveredList() {
        return HeapImpl.getHeapImpl().getGCImpl().getDiscoveredReferenceList();
    }

    static void clearDiscoveredReferences() {
        Log trace = Log.noopLog().string("[DiscoverableReference.clearDiscoveredList:").newline();
        DiscoverableReference current = DiscoverableReferenceProcessing.popDiscoveredReference();
        while (current != null) {
            trace.string("  current: ").object(current).string("  referent: ").hex((WordBase)current.getReferentPointer()).newline();
            current.clean();
            current = DiscoverableReferenceProcessing.popDiscoveredReference();
        }
        DiscoverableReferenceProcessing.setDiscoveredList(null);
        trace.string("]");
    }

    private static void addToDiscoveredReferences(DiscoverableReference dr) {
        Log trace = Log.noopLog().string("[DiscoverableReference.addToDiscoveredReferences:").string("  this: ").object(dr).string("  referent: ").hex((WordBase)dr.getReferentPointer());
        if (dr.getIsDiscovered()) {
            trace.string("  already on list]").newline();
            return;
        }
        trace.newline().string("  [adding to list:").string("  oldList: ").object(DiscoverableReferenceProcessing.getDiscoveredList());
        DiscoverableReferenceProcessing.setDiscoveredList(dr.prependToDiscoveredReference(DiscoverableReferenceProcessing.getDiscoveredList()));
        trace.string("  new list: ").object(DiscoverableReferenceProcessing.getDiscoveredList()).string("]");
        trace.string("]").newline();
    }

    static void processDiscoveredReferences() {
        Log trace = Log.noopLog().string("[DiscoverableReference.processDiscoveredReferences: ").string("  discoveredList: ").object(DiscoverableReferenceProcessing.getDiscoveredList()).newline();
        DiscoverableReference newList = null;
        DiscoverableReference current = DiscoverableReferenceProcessing.popDiscoveredReference();
        while (current != null) {
            trace.string("  [current: ").object(current).string("  referent before: ").hex((WordBase)current.getReferentPointer()).string("]").newline();
            if (!DiscoverableReferenceProcessing.processReferent(current)) {
                trace.string("  unpromoted current: ").object(current).newline();
                newList = current.prependToDiscoveredReference(newList);
            } else {
                trace.string("  promoted current: ").object(current).newline();
            }
            current = DiscoverableReferenceProcessing.popDiscoveredReference();
        }
        DiscoverableReferenceProcessing.setDiscoveredList(newList);
        trace.string("]").newline();
    }

    private static boolean processReferent(DiscoverableReference dr) {
        Log trace = Log.noopLog().string("[DiscoverableReference.processReferent:").string("  this: ").object(dr);
        Pointer refPointer = dr.getReferentPointer();
        trace.string("  referent: ").hex((WordBase)refPointer);
        if (refPointer.isNull()) {
            trace.string("  null referent").string("]").newline();
            return false;
        }
        UnsignedWord header = ObjectHeader.readHeaderFromPointer(refPointer);
        if (ObjectHeaderImpl.getObjectHeaderImpl().isForwardedHeader(header)) {
            Pointer forwardedPointer = ObjectHeaderImpl.getObjectHeaderImpl().getForwardingPointer(refPointer);
            dr.setReferentPointer(forwardedPointer);
            trace.string("  forwarded header: updated referent: ").hex((WordBase)forwardedPointer).string("]").newline();
            return true;
        }
        Object refObject = refPointer.toObject();
        if (HeapImpl.getHeapImpl().hasSurvivedThisCollection(refObject)) {
            trace.string("  referent will survive: not updated").string("]").newline();
            return true;
        }
        dr.clear();
        trace.string("  has not survived: nulled referent").string("]").newline();
        return false;
    }

    private static DiscoverableReference popDiscoveredReference() {
        DiscoverableReference result = DiscoverableReferenceProcessing.getDiscoveredList();
        if (result != null) {
            DiscoverableReferenceProcessing.setDiscoveredList(result.getNextDiscoverableReference());
            result.clean();
        }
        return result;
    }

    private static void setDiscoveredList(DiscoverableReference value) {
        HeapImpl.getHeapImpl().getGCImpl().setDiscoveredReferenceList(value);
    }

    public static boolean verify(DiscoverableReference dr) {
        boolean refOldPinnedTo;
        Pointer refPointer = dr.getReferentPointer();
        int refClassification = HeapVerifierImpl.classifyPointer(refPointer);
        if (refClassification < 0) {
            Log witness = Log.log();
            witness.string("[DiscoverableReference.verify:");
            witness.string("  epoch: ").unsigned((WordBase)HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch());
            witness.string("  refClassification: ").signed(refClassification);
            witness.string("]").newline();
            assert (refClassification >= 0) : "Bad referent.";
            return false;
        }
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        boolean refNull = refPointer.isNull();
        boolean refBootImage = !refNull && HeapVerifierImpl.slowlyFindPointerInBootImage(refPointer);
        boolean refYoung = !refNull && youngGen.slowlyFindPointer(refPointer);
        boolean refOldFrom = !refNull && oldGen.slowlyFindPointerInFromSpace(refPointer);
        boolean refOldTo = !refNull && oldGen.slowlyFindPointerInToSpace(refPointer);
        boolean refOldPinnedFrom = !refNull && oldGen.slowlyFindPointerInPinnedFromSpace(refPointer);
        boolean bl = refOldPinnedTo = !refNull && oldGen.slowlyFindPointerInPinnedToSpace(refPointer);
        if (!(refNull || refYoung || refBootImage || refOldFrom || refOldPinnedFrom)) {
            Log witness = Log.log();
            witness.string("[DiscoverableReference.verify:");
            witness.string("  epoch: ").unsigned((WordBase)HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch());
            witness.string("  refBootImage: ").bool(refBootImage);
            witness.string("  refYoung: ").bool(refYoung);
            witness.string("  refOldFrom: ").bool(refOldFrom);
            witness.string("  refOldPinnedFrom: ").bool(refOldPinnedFrom);
            witness.string("  referent should be in heap.");
            witness.string("]").newline();
            return false;
        }
        assert (!refOldTo && !refOldPinnedTo) : "referent should be in the heap.";
        return true;
    }

    static final class Scatterer {
        private Scatterer() {
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate during a collection.")
        static void distributeReferences() {
            Log trace = Log.noopLog().string("[DiscoverableReferenceProcessing.Scatterer.distributeReferences:").newline();
            for (DiscoverableReference dr = DiscoverableReferenceProcessing.getDiscoveredList(); dr != null; dr = dr.getNextDiscoverableReference()) {
                trace.string("  dr: ").object(dr).newline();
                if (!(dr instanceof FeebleReference)) continue;
                FeebleReference fr = (FeebleReference)dr;
                if (fr.hasList()) {
                    FeebleReferenceList frList = fr.getList();
                    if (frList != null) {
                        trace.string("  frList: ").object(frList).newline();
                        frList.push(fr);
                        continue;
                    }
                    trace.string("  frList is null").newline();
                    continue;
                }
                Log failureLog = Log.log().string("[DiscoverableReferenceProcessing.Scatterer.distributeReferences:").indent(true);
                failureLog.string("  dr: ").object(dr).string("  .referent (should be null): ").hex((WordBase)dr.getReferentPointer()).string("  .isDiscovered (should be true): ").bool(dr.getIsDiscovered()).string("  .isDiscoverableReferenceInitialized (should be true): ").bool(dr.isDiscoverableReferenceInitialized()).newline();
                failureLog.string("  fr: ").object(fr).string("  .isFeebleReferenceInitialized (should be true): ").bool(fr.isFeeblReferenceInitialized()).string("  .hasList (should be true): ").bool(fr.hasList());
                failureLog.string("]").indent(false);
                throw VMError.shouldNotReachHere("DiscoverableReferenceProcessing.Scatterer.distributeReferences: FeebleReference with null list");
            }
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                trace.string("  broadcasting").newline();
                FeebleReferenceList.guaranteeIsLocked();
                FeebleReferenceList.broadcast();
            }
            trace.string("]").newline();
        }
    }
}

