/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul;

import com.netflix.zuul.FilterProcessor;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import com.netflix.zuul.http.HttpServletRequestWrapper;
import com.netflix.zuul.http.HttpServletResponseWrapper;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

public class ZuulRunner {
    private boolean bufferRequests;

    public ZuulRunner() {
        this.bufferRequests = true;
    }

    public ZuulRunner(boolean bufferRequests) {
        this.bufferRequests = bufferRequests;
    }

    public void init(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        RequestContext ctx = RequestContext.getCurrentContext();
        if (this.bufferRequests) {
            ctx.setRequest(new HttpServletRequestWrapper(servletRequest));
        } else {
            ctx.setRequest(servletRequest);
        }
        ctx.setResponse((HttpServletResponse)new HttpServletResponseWrapper(servletResponse));
    }

    public void postRoute() throws ZuulException {
        FilterProcessor.getInstance().postRoute();
    }

    public void route() throws ZuulException {
        FilterProcessor.getInstance().route();
    }

    public void preRoute() throws ZuulException {
        FilterProcessor.getInstance().preRoute();
    }

    public void error() {
        FilterProcessor.getInstance().error();
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Mock
        ZuulFilter filter;
        @Mock
        HttpServletRequest servletRequest;
        @Mock
        HttpServletResponse servletResponse;
        @Mock
        FilterProcessor processor;
        @Mock
        PrintWriter writer;

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testProcessZuulFilter() {
            ZuulRunner runner = new ZuulRunner();
            runner = (ZuulRunner)Mockito.spy((Object)runner);
            RequestContext context = (RequestContext)Mockito.spy((Object)RequestContext.getCurrentContext());
            try {
                FilterProcessor.setProcessor(this.processor);
                RequestContext.testSetCurrentContext(context);
                Mockito.when((Object)this.servletResponse.getWriter()).thenReturn((Object)this.writer);
                runner.init(this.servletRequest, this.servletResponse);
                ((ZuulRunner)Mockito.verify((Object)runner, (VerificationMode)Mockito.times((int)1))).init(this.servletRequest, this.servletResponse);
                Assert.assertTrue((boolean)(RequestContext.getCurrentContext().getRequest() instanceof HttpServletRequestWrapper));
                Assert.assertTrue((boolean)(RequestContext.getCurrentContext().getResponse() instanceof HttpServletResponseWrapper));
                runner.preRoute();
                ((FilterProcessor)Mockito.verify((Object)this.processor, (VerificationMode)Mockito.times((int)1))).preRoute();
                runner.postRoute();
                ((FilterProcessor)Mockito.verify((Object)this.processor, (VerificationMode)Mockito.times((int)1))).postRoute();
                runner.route();
                ((FilterProcessor)Mockito.verify((Object)this.processor, (VerificationMode)Mockito.times((int)1))).route();
                RequestContext.testSetCurrentContext(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

