/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.BackgroundPathable;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.CuratorWatcher;
import com.netflix.curator.framework.api.ExistsBuilder;
import com.netflix.curator.framework.api.Pathable;
import com.netflix.curator.framework.imps.BackgroundOperation;
import com.netflix.curator.framework.imps.Backgrounding;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.OperationAndData;
import com.netflix.curator.framework.imps.Watching;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

class ExistsBuilderImpl
implements ExistsBuilder,
BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding;
    private Watching watching;

    ExistsBuilderImpl(CuratorFrameworkImpl curatorFrameworkImpl) {
        this.client = curatorFrameworkImpl;
        this.backgrounding = new Backgrounding();
        this.watching = new Watching();
    }

    @Override
    public BackgroundPathable<Stat> watched() {
        this.watching = new Watching(true);
        return this;
    }

    @Override
    public BackgroundPathable<Stat> usingWatcher(Watcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public BackgroundPathable<Stat> usingWatcher(CuratorWatcher curatorWatcher) {
        this.watching = new Watching(this.client, curatorWatcher);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(BackgroundCallback backgroundCallback, Object object) {
        this.backgrounding = new Backgrounding(backgroundCallback, object);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(BackgroundCallback backgroundCallback, Object object, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, backgroundCallback, object, executor);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(BackgroundCallback backgroundCallback) {
        this.backgrounding = new Backgrounding(backgroundCallback);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, backgroundCallback, executor);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(Object object) {
        this.backgrounding = new Backgrounding(object);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("ExistsBuilderImpl-Background");
        AsyncCallback.StatCallback statCallback = new AsyncCallback.StatCallback(){

            public void processResult(int n, String string, Object object, Stat stat) {
                timeTrace.commit();
                CuratorEventImpl curatorEventImpl = new CuratorEventImpl(ExistsBuilderImpl.this.client, CuratorEventType.EXISTS, n, string, null, object, stat, null, null, null, null);
                ExistsBuilderImpl.this.client.processBackgroundOperation(operationAndData, curatorEventImpl);
            }
        };
        if (this.watching.isWatched()) {
            this.client.getZooKeeper().exists(operationAndData.getData(), true, statCallback, this.backgrounding.getContext());
        } else {
            this.client.getZooKeeper().exists(operationAndData.getData(), this.watching.getWatcher(), statCallback, this.backgrounding.getContext());
        }
    }

    @Override
    public Stat forPath(String string) throws Exception {
        string = this.client.fixForNamespace(string);
        Stat stat = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, string, this.backgrounding.getCallback(), null), null);
        } else {
            stat = this.pathInForeground(string);
        }
        return stat;
    }

    private Stat pathInForeground(final String string) throws Exception {
        TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("ExistsBuilderImpl-Foreground");
        Stat stat = (Stat)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<Stat>(){

            @Override
            public Stat call() throws Exception {
                Stat stat = ExistsBuilderImpl.this.watching.isWatched() ? ExistsBuilderImpl.this.client.getZooKeeper().exists(string, true) : ExistsBuilderImpl.this.client.getZooKeeper().exists(string, ExistsBuilderImpl.this.watching.getWatcher());
                return stat;
            }
        });
        timeTrace.commit();
        return stat;
    }
}

