/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.BackgroundPathable;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.DeleteBuilder;
import com.netflix.curator.framework.api.DeleteBuilderBase;
import com.netflix.curator.framework.api.Pathable;
import com.netflix.curator.framework.api.transaction.CuratorTransactionBridge;
import com.netflix.curator.framework.api.transaction.OperationType;
import com.netflix.curator.framework.api.transaction.TransactionDeleteBuilder;
import com.netflix.curator.framework.imps.BackgroundOperation;
import com.netflix.curator.framework.imps.Backgrounding;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.CuratorMultiTransactionRecord;
import com.netflix.curator.framework.imps.CuratorTransactionImpl;
import com.netflix.curator.framework.imps.OperationAndData;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;

class DeleteBuilderImpl
implements DeleteBuilder,
BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private int version;
    private Backgrounding backgrounding;
    private boolean guaranteed;

    DeleteBuilderImpl(CuratorFrameworkImpl curatorFrameworkImpl) {
        this.client = curatorFrameworkImpl;
        this.version = -1;
        this.backgrounding = new Backgrounding();
        this.guaranteed = false;
    }

    TransactionDeleteBuilder asTransactionDeleteBuilder(final CuratorTransactionImpl curatorTransactionImpl, final CuratorMultiTransactionRecord curatorMultiTransactionRecord) {
        return new TransactionDeleteBuilder(){

            @Override
            public CuratorTransactionBridge forPath(String string) throws Exception {
                String string2 = DeleteBuilderImpl.this.client.fixForNamespace(string);
                curatorMultiTransactionRecord.add(Op.delete((String)string2, (int)DeleteBuilderImpl.this.version), OperationType.DELETE, string);
                return curatorTransactionImpl;
            }

            @Override
            public Pathable<CuratorTransactionBridge> withVersion(int n) {
                DeleteBuilderImpl.this.withVersion(n);
                return this;
            }
        };
    }

    @Override
    public DeleteBuilderBase guaranteed() {
        this.guaranteed = true;
        return this;
    }

    @Override
    public BackgroundPathable<Void> withVersion(int n) {
        this.version = n;
        return this;
    }

    @Override
    public Pathable<Void> inBackground(BackgroundCallback backgroundCallback, Object object) {
        this.backgrounding = new Backgrounding(backgroundCallback, object);
        return this;
    }

    @Override
    public Pathable<Void> inBackground(BackgroundCallback backgroundCallback, Object object, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, backgroundCallback, object, executor);
        return this;
    }

    @Override
    public Pathable<Void> inBackground(BackgroundCallback backgroundCallback) {
        this.backgrounding = new Backgrounding(backgroundCallback);
        return this;
    }

    @Override
    public Pathable<Void> inBackground(BackgroundCallback backgroundCallback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, backgroundCallback, executor);
        return this;
    }

    @Override
    public Pathable<Void> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public Pathable<Void> inBackground(Object object) {
        this.backgrounding = new Backgrounding(object);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("DeleteBuilderImpl-Background");
        this.client.getZooKeeper().delete(operationAndData.getData(), this.version, new AsyncCallback.VoidCallback(){

            public void processResult(int n, String string, Object object) {
                timeTrace.commit();
                CuratorEventImpl curatorEventImpl = new CuratorEventImpl(DeleteBuilderImpl.this.client, CuratorEventType.DELETE, n, string, null, object, null, null, null, null, null);
                DeleteBuilderImpl.this.client.processBackgroundOperation(operationAndData, curatorEventImpl);
            }
        }, this.backgrounding.getContext());
    }

    @Override
    public Void forPath(String string) throws Exception {
        final String string2 = string;
        string = this.client.fixForNamespace(string);
        if (this.backgrounding.inBackground()) {
            OperationAndData.ErrorCallback<String> errorCallback = null;
            if (this.guaranteed) {
                errorCallback = new OperationAndData.ErrorCallback<String>(){

                    @Override
                    public void retriesExhausted(OperationAndData<String> operationAndData) {
                        DeleteBuilderImpl.this.client.getFailedDeleteManager().addFailedDelete(string2);
                    }
                };
            }
            this.client.processBackgroundOperation(new OperationAndData<String>(this, string, this.backgrounding.getCallback(), errorCallback), null);
        } else {
            this.pathInForeground(string, string2);
        }
        return null;
    }

    protected int getVersion() {
        return this.version;
    }

    private void pathInForeground(final String string, String string2) throws Exception {
        TimeTrace timeTrace = this.client.getZookeeperClient().startTracer("DeleteBuilderImpl-Foreground");
        try {
            RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    DeleteBuilderImpl.this.client.getZooKeeper().delete(string, DeleteBuilderImpl.this.version);
                    return null;
                }
            });
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw nodeExistsException;
        }
        catch (Exception exception) {
            if (this.guaranteed) {
                this.client.getFailedDeleteManager().addFailedDelete(string2);
            }
            throw exception;
        }
        timeTrace.commit();
    }
}

