/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.internal.guava.collect;

import com.mycila.inject.internal.guava.annotations.Beta;
import com.mycila.inject.internal.guava.base.FinalizableReferenceQueue;
import com.mycila.inject.internal.guava.base.FinalizableWeakReference;
import com.mycila.inject.internal.guava.base.Preconditions;
import com.mycila.inject.internal.guava.collect.Interner;
import com.mycila.inject.internal.guava.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Interners {
    private Interners() {
    }

    public static <E> Interner<E> newStrongInterner() {
        final ConcurrentMap map = new MapMaker().makeMap();
        return new Interner<E>(){

            @Override
            public E intern(E sample) {
                Object canonical = map.putIfAbsent(Preconditions.checkNotNull(sample), sample);
                return canonical == null ? sample : canonical;
            }
        };
    }

    public static <E> Interner<E> newWeakInterner() {
        return new WeakInterner();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakInterner<E>
    implements Interner<E> {
        private final ConcurrentMap<InternReference, InternReference> map = new MapMaker().makeMap();
        private static final FinalizableReferenceQueue frq = new FinalizableReferenceQueue();

        private WeakInterner() {
        }

        @Override
        public E intern(final E sample) {
            InternReference sneakyRef;
            Object canonical;
            Object canonical2;
            final int hashCode = sample.hashCode();
            Object fakeReference = new Object(){

                public int hashCode() {
                    return hashCode;
                }

                public boolean equals(Object object) {
                    if (object.hashCode() != hashCode) {
                        return false;
                    }
                    InternReference that = (InternReference)object;
                    return sample.equals(that.get());
                }
            };
            InternReference existingRef = (InternReference)this.map.get(fakeReference);
            if (existingRef != null && (canonical2 = existingRef.get()) != null) {
                return canonical2;
            }
            InternReference newRef = new InternReference(sample, hashCode);
            do {
                if ((sneakyRef = this.map.putIfAbsent(newRef, newRef)) != null) continue;
                return sample;
            } while ((canonical = sneakyRef.get()) == null);
            return canonical;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class InternReference
        extends FinalizableWeakReference<E> {
            final int hashCode;

            InternReference(E key, int hash) {
                super(key, frq);
                this.hashCode = hash;
            }

            @Override
            public void finalizeReferent() {
                WeakInterner.this.map.remove(this);
            }

            @Override
            public E get() {
                Object referent = super.get();
                if (referent == null) {
                    this.finalizeReferent();
                }
                return referent;
            }

            public int hashCode() {
                return this.hashCode;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof InternReference) {
                    InternReference that = (InternReference)object;
                    if (that.hashCode != this.hashCode) {
                        return false;
                    }
                    Object referent = super.get();
                    return referent != null && referent.equals(that.get());
                }
                return object.equals(this);
            }
        }
    }
}

