/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.protocol;

import com.fasterxml.jackson.core.JsonParseException;
import com.microsoft.rest.v2.Base64Url;
import com.microsoft.rest.v2.DateTimeRfc1123;
import com.microsoft.rest.v2.RestException;
import com.microsoft.rest.v2.RestResponse;
import com.microsoft.rest.v2.SwaggerMethodParser;
import com.microsoft.rest.v2.UnixTime;
import com.microsoft.rest.v2.annotations.HeaderCollection;
import com.microsoft.rest.v2.http.BufferedHttpResponse;
import com.microsoft.rest.v2.http.HttpHeader;
import com.microsoft.rest.v2.http.HttpHeaders;
import com.microsoft.rest.v2.http.HttpMethod;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.protocol.SerializerAdapter;
import com.microsoft.rest.v2.protocol.SerializerEncoding;
import com.microsoft.rest.v2.util.FlowableUtil;
import com.microsoft.rest.v2.util.TypeUtil;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class HttpResponseDecoder {
    private final SwaggerMethodParser methodParser;
    private final SerializerAdapter<?> serializer;

    public HttpResponseDecoder(SwaggerMethodParser methodParser, SerializerAdapter<?> serializer) {
        this.methodParser = methodParser;
        this.serializer = serializer;
    }

    public Single<HttpResponse> decode(final HttpResponse response) {
        Single result;
        Object deserializedHeaders;
        response.withIsDecoded(true);
        try {
            deserializedHeaders = this.deserializeHeaders(response.headers());
        }
        catch (IOException e) {
            return Single.error((Throwable)new RestException("HTTP response has malformed headers", response, e));
        }
        final Type returnValueWireType = this.methodParser.returnValueWireType();
        Type entityType = this.getEntityType();
        boolean isSerializableBody = this.methodParser.httpMethod() != HttpMethod.HEAD && !FlowableUtil.isFlowableByteBuffer(entityType) && !TypeUtil.isTypeOrSubTypeOf(entityType, Completable.class) && !TypeUtil.isTypeOrSubTypeOf(entityType, byte[].class) && !TypeUtil.isTypeOrSubTypeOf(entityType, Void.TYPE) && !TypeUtil.isTypeOrSubTypeOf(entityType, Void.class);
        int[] expectedStatuses = this.methodParser.expectedStatusCodes();
        boolean isErrorStatus = true;
        if (expectedStatuses != null) {
            for (int expectedStatus : expectedStatuses) {
                if (expectedStatus != response.statusCode()) continue;
                isErrorStatus = false;
                break;
            }
        } else {
            boolean bl = isErrorStatus = response.statusCode() / 100 != 2;
        }
        if (isErrorStatus) {
            final BufferedHttpResponse bufferedResponse = response.buffer();
            result = ((HttpResponse)bufferedResponse).bodyAsString().map((Function)new Function<String, HttpResponse>(){

                public HttpResponse apply(String bodyString) throws Exception {
                    bufferedResponse.withDeserializedHeaders(deserializedHeaders);
                    Object body = null;
                    try {
                        body = HttpResponseDecoder.this.deserializeBody(bodyString, HttpResponseDecoder.this.methodParser.exceptionBodyType(), null, SerializerEncoding.fromHeaders(response.headers()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return bufferedResponse.withDeserializedBody(body);
                }
            });
        } else if (isSerializableBody) {
            final BufferedHttpResponse bufferedResponse = response.buffer();
            result = ((HttpResponse)bufferedResponse).bodyAsString().map((Function)new Function<String, HttpResponse>(){

                public HttpResponse apply(String bodyString) throws Exception {
                    try {
                        Object body = HttpResponseDecoder.this.deserializeBody(bodyString, HttpResponseDecoder.this.getEntityType(), returnValueWireType, SerializerEncoding.fromHeaders(response.headers()));
                        return bufferedResponse.withDeserializedHeaders(deserializedHeaders).withDeserializedBody(body);
                    }
                    catch (JsonParseException e) {
                        throw new RestException("HTTP response has a malformed body", response, e);
                    }
                }
            });
        } else {
            result = Single.just((Object)response.withDeserializedHeaders(deserializedHeaders));
        }
        return result;
    }

    private Object deserializeBody(String value, Type resultType, Type wireType, SerializerEncoding encoding) throws IOException {
        Object result;
        if (wireType == null) {
            result = this.serializer.deserialize(value, resultType, encoding);
        } else {
            Type wireResponseType = this.constructWireResponseType(resultType, wireType);
            Object wireResponse = this.serializer.deserialize(value, wireResponseType, encoding);
            result = this.convertToResultType(wireResponse, resultType, wireType);
        }
        return result;
    }

    private Type constructWireResponseType(Type resultType, Type wireType) {
        Object wireResponseType = resultType;
        if (resultType == byte[].class) {
            if (wireType == Base64Url.class) {
                wireResponseType = Base64Url.class;
            }
        } else if (resultType == OffsetDateTime.class) {
            if (wireType == DateTimeRfc1123.class) {
                wireResponseType = DateTimeRfc1123.class;
            } else if (wireType == UnixTime.class) {
                wireResponseType = UnixTime.class;
            }
        } else if (TypeUtil.isTypeOrSubTypeOf(resultType, List.class)) {
            Type resultElementType = TypeUtil.getTypeArgument(resultType);
            Type wireResponseElementType = this.constructWireResponseType(resultElementType, wireType);
            wireResponseType = TypeUtil.createParameterizedType((Class)((ParameterizedType)resultType).getRawType(), wireResponseElementType);
        } else if (TypeUtil.isTypeOrSubTypeOf(resultType, Map.class) || TypeUtil.isTypeOrSubTypeOf(resultType, RestResponse.class)) {
            Type[] typeArguments = TypeUtil.getTypeArguments(resultType);
            Type resultValueType = typeArguments[1];
            Type wireResponseValueType = this.constructWireResponseType(resultValueType, wireType);
            wireResponseType = TypeUtil.createParameterizedType((Class)((ParameterizedType)resultType).getRawType(), typeArguments[0], wireResponseValueType);
        }
        return wireResponseType;
    }

    private Object convertToResultType(Object wireResponse, Type resultType, Type wireType) {
        RestResponse result = wireResponse;
        if (wireResponse != null) {
            if (resultType == byte[].class) {
                if (wireType == Base64Url.class) {
                    result = (RestResponse)((Base64Url)wireResponse).decodedBytes();
                }
            } else if (resultType == OffsetDateTime.class) {
                if (wireType == DateTimeRfc1123.class) {
                    result = ((DateTimeRfc1123)wireResponse).dateTime();
                } else if (wireType == UnixTime.class) {
                    result = ((UnixTime)wireResponse).dateTime();
                }
            } else if (TypeUtil.isTypeOrSubTypeOf(resultType, List.class)) {
                Type resultElementType = TypeUtil.getTypeArgument(resultType);
                List wireResponseList = (List)wireResponse;
                int wireResponseListSize = wireResponseList.size();
                for (int i = 0; i < wireResponseListSize; ++i) {
                    Object resultElement;
                    Object wireResponseElement = wireResponseList.get(i);
                    if (wireResponseElement == (resultElement = this.convertToResultType(wireResponseElement, resultElementType, wireType))) continue;
                    wireResponseList.set(i, resultElement);
                }
                result = wireResponseList;
            } else if (TypeUtil.isTypeOrSubTypeOf(resultType, Map.class)) {
                Type resultValueType = TypeUtil.getTypeArguments(resultType)[1];
                Map wireResponseMap = (Map)wireResponse;
                Set wireResponseKeys = wireResponseMap.keySet();
                for (String wireResponseKey : wireResponseKeys) {
                    Object resultValue;
                    Object wireResponseValue = wireResponseMap.get(wireResponseKey);
                    if (wireResponseValue == (resultValue = this.convertToResultType(wireResponseValue, resultValueType, wireType))) continue;
                    wireResponseMap.put(wireResponseKey, resultValue);
                }
            } else if (TypeUtil.isTypeOrSubTypeOf(resultType, RestResponse.class)) {
                Object resultBody;
                RestResponse restResponse = (RestResponse)wireResponse;
                Object wireResponseBody = restResponse.body();
                result = wireResponseBody != (resultBody = this.convertToResultType(wireResponseBody, TypeUtil.getTypeArguments(resultType)[1], wireType)) ? new RestResponse(restResponse.request(), restResponse.statusCode(), restResponse.headers(), restResponse.rawHeaders(), resultBody) : restResponse;
            }
        }
        return result;
    }

    private Type getEntityType() {
        Type token = this.methodParser.returnType();
        if (TypeUtil.isTypeOrSubTypeOf(token, Single.class) || TypeUtil.isTypeOrSubTypeOf(token, Maybe.class) || TypeUtil.isTypeOrSubTypeOf(token, Observable.class)) {
            token = TypeUtil.getTypeArgument(token);
        }
        if (TypeUtil.isTypeOrSubTypeOf(token, RestResponse.class)) {
            token = TypeUtil.getSuperType(token, RestResponse.class);
            token = TypeUtil.getTypeArguments(token)[1];
        }
        try {
            if (TypeUtil.isTypeOrSubTypeOf(token, Class.forName("com.microsoft.azure.v2.OperationStatus"))) {
                token = TypeUtil.getTypeArgument(token);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return token;
    }

    private Type getHeadersType() {
        Type token = this.methodParser.returnType();
        Type headersType = null;
        if (TypeUtil.isTypeOrSubTypeOf(token, Single.class)) {
            token = TypeUtil.getTypeArgument(token);
        }
        if (TypeUtil.isTypeOrSubTypeOf(token, RestResponse.class)) {
            headersType = TypeUtil.getTypeArguments(TypeUtil.getSuperType(token, RestResponse.class))[0];
        }
        return headersType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deserializeHeaders(HttpHeaders headers) throws IOException {
        Field[] declaredFields;
        Type deserializedHeadersType = this.getHeadersType();
        if (deserializedHeadersType == null) {
            return null;
        }
        String headersJsonString = this.serializer.serialize(headers, SerializerEncoding.JSON);
        Object deserializedHeaders = this.serializer.deserialize(headersJsonString, deserializedHeadersType, SerializerEncoding.JSON);
        Class<?> deserializedHeadersClass = TypeUtil.getRawClass(deserializedHeadersType);
        for (Field declaredField : declaredFields = deserializedHeadersClass.getDeclaredFields()) {
            HeaderCollection headerCollectionAnnotation;
            String headerCollectionPrefix;
            int headerCollectionPrefixLength;
            Type[] mapTypeArguments;
            if (!declaredField.isAnnotationPresent(HeaderCollection.class)) continue;
            Type declaredFieldType = declaredField.getGenericType();
            if (!TypeUtil.isTypeOrSubTypeOf(declaredField.getType(), Map.class) || (mapTypeArguments = TypeUtil.getTypeArguments(declaredFieldType)).length != 2 || mapTypeArguments[0] != String.class || mapTypeArguments[1] != String.class || (headerCollectionPrefixLength = (headerCollectionPrefix = (headerCollectionAnnotation = declaredField.getAnnotation(HeaderCollection.class)).value().toLowerCase()).length()) <= 0) continue;
            HashMap<String, String> headerCollection = new HashMap<String, String>();
            for (HttpHeader header : headers) {
                String headerName = header.name();
                if (!headerName.toLowerCase().startsWith(headerCollectionPrefix)) continue;
                headerCollection.put(headerName.substring(headerCollectionPrefixLength), header.value());
            }
            boolean declaredFieldAccessibleBackup = declaredField.isAccessible();
            try {
                if (!declaredFieldAccessibleBackup) {
                    declaredField.setAccessible(true);
                }
                declaredField.set(deserializedHeaders, headerCollection);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            finally {
                if (!declaredFieldAccessibleBackup) {
                    declaredField.setAccessible(declaredFieldAccessibleBackup);
                }
            }
        }
        return deserializedHeaders;
    }
}

